/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public final class LootUtil {
    public static LootTable getTable(ServerLevel world, ResourceLocation table) {
        return world.m_142572_().m_129898_().m_79217_(table);
    }

    @Nonnull
    public static List<ItemStack> generateLoot(ServerLevel world, ResourceLocation table, LootContext context) {
        LootTable lootTable = LootUtil.getTable(world, table);
        if (lootTable == LootTable.f_79105_) {
            return Lists.newArrayList();
        }
        return lootTable.m_79129_(context);
    }

    public static LootContext getGiftContext(ServerLevel world, Vec3 position, Entity targetEntity) {
        return LootUtil.getGiftContext(world, position, 0.0f, targetEntity);
    }

    public static LootContext getGiftContext(ServerLevel world, Vec3 position, float luck, Entity targetEntity) {
        return new LootContext.Builder(world).m_78977_(world.m_5822_()).m_78972_(LootContextParams.f_81455_, (Object)targetEntity).m_78972_(LootContextParams.f_81460_, (Object)position).m_78963_(luck).m_78975_(LootContextParamSets.f_81416_);
    }
}

