/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public final class ObjectUtil {
    public static String bufferedReaderToString(BufferedReader reader) {
        StringBuilder content = new StringBuilder();
        reader.lines().forEach(line -> {
            content.append((String)line);
            content.append("\n");
        });
        return content.toString();
    }

    @Nullable
    public static <T> T getFromCollection(Collection<T> collection, Predicate<T> predicate) {
        for (T t : collection) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    public static JsonObject stackToJson(ItemStack stack) {
        JsonObject json = new JsonObject();
        json.add("item", (JsonElement)new JsonPrimitive(stack.m_41720_().getRegistryName().toString()));
        if (stack.m_41613_() == 1 && !stack.m_41782_()) {
            return json;
        }
        json.addProperty("count", (Number)stack.m_41613_());
        if (stack.m_41782_()) {
            json.add("nbt", (JsonElement)((JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)stack.m_41783_())).getAsJsonObject());
        }
        return json;
    }

    public static <T> JsonObject codecToJson(Codec<T> codec, T object, Function<String, String> errMsg) {
        DataResult result = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, object);
        Optional output = result.resultOrPartial(error -> {
            throw new IllegalArgumentException((String)errMsg.apply((String)error));
        });
        return ((JsonElement)output.get()).getAsJsonObject();
    }
}

