/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ToastPopupPacket;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.content.capability.adventplayer.AdventPlayerCapability;
import net.tslat.aoa3.content.capability.adventplayer.AdventPlayerCapabilityHandles;
import net.tslat.aoa3.content.capability.adventplayer.AdventPlayerCapabilityProvider;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.PlayerDataManager;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.WorldUtil;

public final class PlayerUtil {
    private static final Int2FloatOpenHashMap XP_MAP = new Int2FloatOpenHashMap(1000);
    private static final Int2FloatOpenHashMap TIME_BASED_XP_MAP = new Int2FloatOpenHashMap(1000);

    public static void init() {
        int i;
        for (i = 1; i <= 99; ++i) {
            XP_MAP.put(i, (float)Math.pow(1.1, i) * 50.0f);
            TIME_BASED_XP_MAP.put(i, XP_MAP.get(i) / (float)(20.0 + Math.pow(Math.pow(i, 3.0) / 18000.0, 1.75)));
        }
        for (i = 100; i <= 999; ++i) {
            XP_MAP.put(i, (float)Math.pow(i - 10, 2.5) / 100.0f + 630000.0f);
            TIME_BASED_XP_MAP.put(i, XP_MAP.get(i) / (float)(1050 + i));
        }
    }

    @Nonnull
    public static ServerPlayerDataManager getAdventPlayer(@Nonnull ServerPlayer player) {
        AdventPlayerCapabilityHandles cap = (AdventPlayerCapabilityHandles)player.getCapability(AdventPlayerCapabilityProvider.CAPABILITY, null).orElseGet(() -> new AdventPlayerCapability(player));
        return cap.getPlayerData();
    }

    @Nonnull
    public static PlayerDataManager getAdventPlayer(@Nonnull Player player) {
        PlayerDataManager plData = !player.f_19853_.m_5776_() ? PlayerUtil.getAdventPlayer((ServerPlayer)player) : ClientOperations.CLIENT_PLAYER_DATA;
        if (plData.player() == null) {
            plData.updatePlayerInstance(player);
        }
        return plData;
    }

    @Nonnull
    public static AoASkill.Instance getSkill(Player player, AoASkill skill) {
        return PlayerUtil.getAdventPlayer(player).getSkill(skill);
    }

    public static int getLevel(Player player, AoASkill skill) {
        AoASkill.Instance instance = PlayerUtil.getSkill(player, skill);
        return instance == AoASkills.DEFAULT ? 0 : instance.getLevel(true);
    }

    public static boolean doesPlayerHaveLevel(Player player, AoASkill skill, int level) {
        return PlayerUtil.getLevel(player, skill) >= level;
    }

    public static void giveXpToPlayer(ServerPlayer player, AoASkill skill, float xp, boolean ignoreXpBuffs) {
        AoASkill.Instance instance = PlayerUtil.getSkill((Player)player, skill);
        if (instance != AoASkills.DEFAULT) {
            instance.adjustXp(xp, false, ignoreXpBuffs);
        }
    }

    @Nonnull
    public static AoAResource.Instance getResource(Player player, AoAResource resource) {
        return PlayerUtil.getAdventPlayer(player).getResource(resource);
    }

    public static float getResourceValue(Player player, AoAResource resource) {
        AoAResource.Instance instance = PlayerUtil.getResource(player, resource);
        return instance == AoAResources.DEFAULT ? 0.0f : instance.getCurrentValue();
    }

    public static void addResourceToPlayer(ServerPlayer player, AoAResource resource, float amount) {
        AoAResource.Instance instance = PlayerUtil.getResource((Player)player, resource);
        if (instance != AoAResources.DEFAULT) {
            instance.addValue(amount);
        }
    }

    public static boolean consumeResource(ServerPlayer player, AoAResource resource, float amount, boolean forceConsume) {
        AoAResource.Instance instance = PlayerUtil.getResource((Player)player, resource);
        if (instance == AoAResources.DEFAULT) {
            return false;
        }
        return instance.consume(amount, forceConsume);
    }

    public static int getLevelProgressPercentage(int lvl, float xp) {
        return lvl >= 1000 ? 100 : (int)(xp / PlayerUtil.getXpRequiredForNextLevel(lvl) * 100.0f);
    }

    public static float getXpRequiredForNextLevel(int currentLevel) {
        return XP_MAP.get(currentLevel);
    }

    public static boolean isWearingFullSet(ServerPlayer player, AdventArmour.Type setType) {
        return PlayerUtil.getAdventPlayer(player).equipment().getCurrentFullArmourSet() == setType;
    }

    public static float getXpRemainingUntilLevel(PlayerDataManager plData, AoASkill skill) {
        AoASkill.Instance instance = plData.getSkill(skill);
        if (instance == AoASkills.DEFAULT) {
            return -1.0f;
        }
        return PlayerUtil.getXpRequiredForNextLevel(instance.getLevel(true)) - instance.getXp();
    }

    public static float getTimeBasedXpForLevel(int currentLevel, float timeIntervalTicks) {
        return TIME_BASED_XP_MAP.get(currentLevel) * (timeIntervalTicks / 100.0f);
    }

    public static float getXpForFractionOfLevel(int currentLevel, float fraction) {
        return PlayerUtil.getXpRequiredForNextLevel(currentLevel) * fraction;
    }

    @Nullable
    public static AoASkill getLowestSkillWithLimit(PlayerDataManager plData, int limit) {
        AoASkill.Instance lowestSkill = null;
        int lowestVal = 1001;
        for (AoASkill.Instance skill : plData.getSkills()) {
            int temp = skill.getLevel(true);
            if (temp < limit || temp >= lowestVal) continue;
            lowestVal = temp;
            lowestSkill = skill;
        }
        if (lowestVal >= 1000) {
            return null;
        }
        return lowestSkill.type();
    }

    @Nullable
    public static AoASkill getHighestSkill(PlayerDataManager plData) {
        AoASkill.Instance highestSkill = null;
        int highestVal = 0;
        for (AoASkill.Instance skill : plData.getSkills()) {
            int lvl = skill.getLevel(true);
            if (lvl <= highestVal) continue;
            highestSkill = skill;
            highestVal = lvl;
        }
        return highestSkill == null ? null : highestSkill.type();
    }

    public static void notifyPlayer(Player player, Component msg) {
        player.m_6352_(msg, Util.f_137441_);
    }

    public static void notifyPlayerOfInsufficientLevel(ServerPlayer player, AoASkill skill, int level) {
        AoAPackets.messagePlayer(player, new ToastPopupPacket(skill, level));
    }

    public static void notifyPlayerOfInsufficientResources(ServerPlayer player, AoAResource resource, float amount) {
        AoAPackets.messagePlayer(player, new ToastPopupPacket(resource, amount));
    }

    public static void messageAllPlayersInRange(Component msg, Level world, BlockPos center, int radius) {
        for (Player pl : WorldUtil.getAllPlayersInRegion(world, new AABB(center).m_82400_((double)radius))) {
            pl.m_6352_(msg, Util.f_137441_);
        }
    }

    public static boolean shouldPlayerBeAffected(Player pl) {
        return pl.m_6084_() && !pl.m_5833_() && !pl.m_7500_();
    }

    public static int getPlayerLevelFromExp(int xp) {
        if (xp > 1507) {
            return (int)Math.floor((162.5 + Math.sqrt(26406.25 - 18.0 * (double)(2220 - xp))) / 9.0);
        }
        if (xp > 352) {
            return (int)Math.floor((40.5 + Math.sqrt(1640.25 - 10.0 * (double)(360 - xp))) / 5.0);
        }
        return (int)Math.floor((-6.0 + Math.sqrt(36 - 4 * -xp)) / 2.0);
    }

    public static BlockPos getBlockAimingAt(Player pl, double distance) {
        float angleZ;
        float sinPitch;
        float cosPitch;
        Vec3 startVec = new Vec3(pl.m_20185_(), pl.m_20186_() + (double)pl.m_20192_(), pl.m_20189_());
        float cosYaw = Mth.m_14089_((float)((float)((double)(-pl.m_146908_()) * Math.toRadians(1.0) - Math.PI)));
        float sinYaw = Mth.m_14031_((float)((float)((double)(-pl.m_146908_()) * Math.toRadians(1.0) - Math.PI)));
        float angleX = sinYaw * (cosPitch = -Mth.m_14089_((float)((float)((double)(-pl.m_146909_()) * Math.toRadians(1.0)))));
        Vec3 endVec = startVec.m_82520_((double)angleX * distance, (double)(sinPitch = Mth.m_14031_((float)((float)((double)(-pl.m_146909_()) * Math.toRadians(1.0))))) * distance, (double)(angleZ = cosYaw * cosPitch) * distance);
        BlockHitResult ray = pl.f_19853_.m_45547_(new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null));
        if (ray.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        return ray.m_82425_();
    }

    public static void playSoundForPlayer(ServerPlayer player, SoundEvent sound, SoundSource category, double posX, double posY, double posZ, float volume, float pitch) {
        player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(sound, category, posX, posY, posZ, volume, pitch));
    }

    @Nullable
    public static Player getPlayerOrOwnerIfApplicable(@Nullable Entity entity) {
        Projectile projectile;
        OwnableEntity tameable;
        Entity entity2;
        if (entity == null) {
            return null;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        if (entity instanceof OwnableEntity && (entity2 = (tameable = (OwnableEntity)entity).m_142480_()) instanceof Player) {
            Player player = (Player)entity2;
            return player;
        }
        if (entity instanceof Projectile && (entity2 = (projectile = (Projectile)entity).m_37282_()) instanceof Player) {
            Player player = (Player)entity2;
            return player;
        }
        return null;
    }

    public static EquipmentSlot handToEquipmentSlotType(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
    }

    public static GameType getGameMode(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.f_8941_.m_9290_();
        }
        return ClientOperations.getGameMode();
    }
}

