/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.aoa3.geckolib3.renderers.geo;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import software.bernie.aoa3.geckolib3.core.processor.IBone;
import software.bernie.aoa3.geckolib3.geo.render.built.GeoBone;
import software.bernie.aoa3.geckolib3.geo.render.built.GeoCube;
import software.bernie.aoa3.geckolib3.geo.render.built.GeoModel;
import software.bernie.aoa3.geckolib3.item.GeoArmorItem;
import software.bernie.aoa3.geckolib3.model.AnimatedGeoModel;
import software.bernie.aoa3.geckolib3.renderers.geo.GeoEntityRenderer;

@OnlyIn(value=Dist.CLIENT)
public abstract class ExtendedGeoEntityRenderer<T extends LivingEntity>
extends GeoEntityRenderer<T> {
    protected float widthScale;
    protected float heightScale;
    private EModelRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;
    private T currentEntityBeingRendered;
    private MultiBufferSource rtb;
    protected final HumanoidModel<LivingEntity> DEFAULT_BIPED_ARMOR_MODEL_INNER = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_));
    protected final HumanoidModel<LivingEntity> DEFAULT_BIPED_ARMOR_MODEL_OUTER = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171165_));
    private VertexConsumer currentVertexBuilderInUse;
    private float currentPartialTicks;
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

    protected EModelRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    protected void setCurrentModelRenderCycle(EModelRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    protected ExtendedGeoEntityRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<T> modelProvider) {
        this(renderManager, modelProvider, 1.0f, 1.0f, 0.0f);
    }

    protected void bindTexture(ResourceLocation textureLocation) {
        Minecraft.m_91087_().f_90987_.m_174784_(textureLocation);
    }

    protected ExtendedGeoEntityRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<T> modelProvider, float widthScale, float heightScale, float shadowSize) {
        super(renderManager, modelProvider);
        this.f_114477_ = shadowSize;
        this.widthScale = widthScale;
        this.heightScale = heightScale;
    }

    @Override
    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        this.setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);
        super.render(entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
    }

    @Override
    public void render(GeoModel model, T animatable, float partialTicks, RenderType type, PoseStack matrixStackIn, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        super.render(model, animatable, partialTicks, type, matrixStackIn, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.setCurrentModelRenderCycle(EModelRenderCycle.REPEATED);
    }

    protected float getWidthScale(T entity) {
        return this.widthScale;
    }

    protected float getHeightScale(T entity) {
        return this.heightScale;
    }

    @Override
    public void renderEarly(T animatable, PoseStack stackIn, float ticks, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        this.rtb = renderTypeBuffer;
        super.renderEarly(animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
        if (this.getCurrentModelRenderCycle() == EModelRenderCycle.INITIAL) {
            float width = this.getWidthScale(animatable);
            float height = this.getHeightScale(animatable);
            stackIn.m_85841_(width, height, width);
        }
    }

    @Override
    public ResourceLocation getTextureLocation(T entity) {
        return this.modelProvider.getTextureLocation(entity);
    }

    @Override
    public void renderLate(T animatable, PoseStack stackIn, float ticks, MultiBufferSource renderTypeBuffer, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        super.renderLate(animatable, stackIn, ticks, renderTypeBuffer, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
        this.currentEntityBeingRendered = animatable;
        this.currentVertexBuilderInUse = bufferIn;
        this.currentPartialTicks = partialTicks;
    }

    protected abstract boolean isArmorBone(GeoBone var1);

    protected void moveAndRotateMatrixToMatchBone(PoseStack stack, GeoBone bone) {
        stack.m_85837_((double)(bone.getPivotX() / 16.0f), (double)(bone.getPivotY() / 16.0f), (double)(bone.getPositionZ() / 16.0f));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(bone.getRotationX()));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(bone.getRotationY()));
        stack.m_85845_(Vector3f.f_122227_.m_122240_(bone.getRotationZ()));
    }

    protected void handleArmorRenderingForBone(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, ResourceLocation currentTexture) {
        ItemStack armorForBone = this.getArmorForBone(bone.getName(), this.currentEntityBeingRendered);
        EquipmentSlot boneSlot = this.getEquipmentSlotForArmorBone(bone.getName(), this.currentEntityBeingRendered);
        if (armorForBone != null && armorForBone.m_41720_() instanceof ArmorItem && armorForBone.m_41720_() instanceof ArmorItem && !(armorForBone.m_41720_() instanceof GeoArmorItem) && boneSlot != null) {
            if (!(armorForBone.m_41720_() instanceof GeoArmorItem)) {
                ArmorItem armorItem = (ArmorItem)armorForBone.m_41720_();
                HumanoidModel armorModel = (HumanoidModel)ForgeHooksClient.getArmorModel(this.currentEntityBeingRendered, (ItemStack)armorForBone, (EquipmentSlot)boneSlot, boneSlot == EquipmentSlot.LEGS ? this.DEFAULT_BIPED_ARMOR_MODEL_INNER : this.DEFAULT_BIPED_ARMOR_MODEL_OUTER);
                if (armorModel != null) {
                    ModelPart sourceLimb = this.getArmorPartForBone(bone.getName(), armorModel);
                    List cubeList = sourceLimb.f_104212_;
                    if (sourceLimb != null && cubeList != null && !cubeList.isEmpty()) {
                        this.prepareArmorPositionAndScale(bone, cubeList, sourceLimb, stack);
                        stack.m_85841_(-1.0f, -1.0f, 1.0f);
                        stack.m_85836_();
                        ResourceLocation armorResource = this.getArmorResource((Entity)this.currentEntityBeingRendered, armorForBone, boneSlot, null);
                        this.bindTexture(armorResource);
                        this.renderArmorOfItem(armorItem, armorForBone, boneSlot, armorResource, sourceLimb, stack, packedLightIn, packedOverlayIn);
                        stack.m_85849_();
                        this.bindTexture(currentTexture);
                        bufferIn = this.rtb.m_6299_(RenderType.m_110473_((ResourceLocation)currentTexture));
                    }
                }
            } else if (armorForBone.m_41720_() instanceof GeoArmorItem) {
                // empty if block
            }
        }
    }

    protected void renderArmorOfItem(ArmorItem armorItem, ItemStack armorForBone, EquipmentSlot boneSlot, ResourceLocation armorResource, ModelPart sourceLimb, PoseStack stack, int packedLightIn, int packedOverlayIn) {
        if (armorItem instanceof DyeableArmorItem) {
            int i = ((DyeableArmorItem)armorItem).m_41121_(armorForBone);
            float r = (float)(i >> 16 & 0xFF) / 255.0f;
            float g = (float)(i >> 8 & 0xFF) / 255.0f;
            float b = (float)(i & 0xFF) / 255.0f;
            this.renderArmorPart(stack, sourceLimb, packedLightIn, packedOverlayIn, r, g, b, 1.0f, armorForBone, armorResource);
            this.renderArmorPart(stack, sourceLimb, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f, armorForBone, this.getArmorResource((Entity)this.currentEntityBeingRendered, armorForBone, boneSlot, "overlay"));
        } else {
            this.renderArmorPart(stack, sourceLimb, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f, armorForBone, armorResource);
        }
    }

    protected void prepareArmorPositionAndScale(GeoBone bone, List<ModelPart.Cube> cubeList, ModelPart sourceLimb, PoseStack stack) {
        GeoCube firstCube = bone.childCubes.get(0);
        ModelPart.Cube armorCube = cubeList.get(0);
        float targetSizeX = firstCube.size.m_122239_();
        float targetSizeY = firstCube.size.m_122260_();
        float targetSizeZ = firstCube.size.m_122269_();
        float sourceSizeX = Math.abs(armorCube.f_104338_ - armorCube.f_104335_);
        float sourceSizeY = Math.abs(armorCube.f_104339_ - armorCube.f_104336_);
        float sourceSizeZ = Math.abs(armorCube.f_104340_ - armorCube.f_104337_);
        float scaleX = targetSizeX / sourceSizeX;
        float scaleY = targetSizeY / sourceSizeY;
        float scaleZ = targetSizeZ / sourceSizeZ;
        sourceLimb.m_104227_(-(bone.getPivotX() + sourceSizeX - targetSizeX), -(bone.getPivotY() + sourceSizeY - targetSizeY), bone.getPivotZ() + sourceSizeZ - targetSizeZ);
        sourceLimb.f_104203_ = -bone.getRotationX();
        sourceLimb.f_104204_ = -bone.getRotationY();
        sourceLimb.f_104205_ = bone.getRotationZ();
        stack.m_85841_(scaleX, scaleY, scaleZ);
    }

    @Override
    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ResourceLocation tfb = this.getCurrentModelRenderCycle() != EModelRenderCycle.INITIAL ? null : this.getTextureForBone(bone.getName(), this.currentEntityBeingRendered);
        boolean customTextureMarker = tfb != null;
        ResourceLocation currentTexture = this.getTextureLocation(this.currentEntityBeingRendered);
        if (customTextureMarker) {
            currentTexture = tfb;
            this.bindTexture(currentTexture);
            if (this.rtb != null) {
                RenderType rt = this.getRenderTypeForBone(bone, this.currentEntityBeingRendered, this.currentPartialTicks, stack, bufferIn, this.rtb, packedLightIn, currentTexture);
                bufferIn = this.rtb.m_6299_(rt);
            }
        }
        if (this.getCurrentModelRenderCycle() == EModelRenderCycle.INITIAL) {
            stack.m_85836_();
            if (this.isArmorBone(bone)) {
                this.handleArmorRenderingForBone(bone, stack, bufferIn, packedLightIn, packedOverlayIn, currentTexture);
            } else {
                ItemStack boneItem = this.getHeldItemForBone(bone.getName(), this.currentEntityBeingRendered);
                BlockState boneBlock = this.getHeldBlockForBone(bone.getName(), this.currentEntityBeingRendered);
                if (boneItem != null || boneBlock != null) {
                    stack.m_85836_();
                    stack.m_85837_((double)(bone.getPivotX() / 16.0f), (double)(bone.getPivotY() / 16.0f), (double)(bone.getPositionZ() / 16.0f));
                    stack.m_85845_(Vector3f.f_122223_.m_122240_(bone.getRotationX()));
                    stack.m_85845_(Vector3f.f_122225_.m_122240_(bone.getRotationY()));
                    stack.m_85845_(Vector3f.f_122227_.m_122240_(bone.getRotationZ()));
                    if (boneItem != null) {
                        this.preRenderItem(stack, boneItem, bone.getName(), this.currentEntityBeingRendered, bone);
                        Minecraft.m_91087_().m_91292_().m_109322_(this.currentEntityBeingRendered, boneItem, this.getCameraTransformForItemAtBone(boneItem, bone.getName()), false, stack, this.rtb, packedLightIn);
                        this.postRenderItem(stack, boneItem, bone.getName(), this.currentEntityBeingRendered, bone);
                    }
                    if (boneBlock != null) {
                        this.preRenderBlock(boneBlock, bone.getName(), this.currentEntityBeingRendered);
                        this.renderBlock(stack, this.rtb, packedLightIn, boneBlock);
                        this.postRenderBlock(boneBlock, bone.getName(), this.currentEntityBeingRendered);
                    }
                    stack.m_85849_();
                    bufferIn = this.rtb.m_6299_(RenderType.m_110473_((ResourceLocation)currentTexture));
                }
            }
            stack.m_85849_();
        }
        if (customTextureMarker) {
            bufferIn = this.currentVertexBuilderInUse;
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (customTextureMarker) {
            this.bindTexture(this.getTextureLocation(this.currentEntityBeingRendered));
        }
    }

    private RenderType getRenderTypeForBone(GeoBone bone, T currentEntityBeingRendered2, float currentPartialTicks2, PoseStack stack, VertexConsumer bufferIn, MultiBufferSource currentRenderTypeBufferInUse2, int packedLightIn, ResourceLocation currentTexture) {
        return this.getRenderType(currentEntityBeingRendered2, currentPartialTicks2, stack, currentRenderTypeBufferInUse2, bufferIn, packedLightIn, currentTexture);
    }

    protected void renderArmorPart(PoseStack stack, ModelPart sourceLimb, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, ItemStack armorForBone, ResourceLocation armorResource) {
        VertexConsumer ivb = ItemRenderer.m_115184_((MultiBufferSource)this.rtb, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)armorForBone.m_41790_());
        sourceLimb.m_104306_(stack, ivb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Nullable
    protected abstract ResourceLocation getTextureForBone(String var1, T var2);

    protected void renderBlock(PoseStack matrixStack, MultiBufferSource rtb, int packedLightIn, BlockState iBlockState) {
    }

    @Nullable
    protected abstract ItemStack getHeldItemForBone(String var1, T var2);

    protected abstract ItemTransforms.TransformType getCameraTransformForItemAtBone(ItemStack var1, String var2);

    @Nullable
    protected abstract BlockState getHeldBlockForBone(String var1, T var2);

    protected abstract void preRenderItem(PoseStack var1, ItemStack var2, String var3, T var4, IBone var5);

    protected abstract void preRenderBlock(BlockState var1, String var2, T var3);

    protected abstract void postRenderItem(PoseStack var1, ItemStack var2, String var3, T var4, IBone var5);

    protected abstract void postRenderBlock(BlockState var1, String var2, T var3);

    @Nullable
    protected ItemStack getArmorForBone(String boneName, T currentEntity) {
        return null;
    }

    @Nullable
    protected EquipmentSlot getEquipmentSlotForArmorBone(String boneName, T currentEntity) {
        return null;
    }

    @Nullable
    protected ModelPart getArmorPartForBone(String name, HumanoidModel<?> armorModel) {
        return null;
    }

    protected ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    static enum EModelRenderCycle {
        INITIAL,
        REPEATED,
        SPECIAL;

    }
}

