/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.aoa3.geckolib3.renderers.geo;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import software.bernie.aoa3.geckolib3.compat.PatchouliCompat;
import software.bernie.aoa3.geckolib3.core.IAnimatable;
import software.bernie.aoa3.geckolib3.core.controller.AnimationController;
import software.bernie.aoa3.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.aoa3.geckolib3.core.processor.IBone;
import software.bernie.aoa3.geckolib3.core.util.Color;
import software.bernie.aoa3.geckolib3.geo.render.built.GeoModel;
import software.bernie.aoa3.geckolib3.model.AnimatedGeoModel;
import software.bernie.aoa3.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.aoa3.geckolib3.util.GeoUtils;

public abstract class GeoArmorRenderer<T extends ArmorItem>
extends HumanoidModel
implements IGeoRenderer<T> {
    private static Map<Class<? extends ArmorItem>, GeoArmorRenderer> renderers = new ConcurrentHashMap<Class<? extends ArmorItem>, GeoArmorRenderer>();
    protected T currentArmorItem;
    protected LivingEntity entityLiving;
    protected ItemStack itemStack;
    protected EquipmentSlot armorSlot;
    public String headBone = "armorHead";
    public String bodyBone = "armorBody";
    public String rightArmBone = "armorRightArm";
    public String leftArmBone = "armorLeftArm";
    public String rightLegBone = "armorRightLeg";
    public String leftLegBone = "armorLeftLeg";
    public String rightBootBone = "armorRightBoot";
    public String leftBootBone = "armorLeftBoot";
    private final AnimatedGeoModel<T> modelProvider;

    public static void registerArmorRenderer(Class<? extends ArmorItem> itemClass, GeoArmorRenderer renderer) {
        renderers.put(itemClass, renderer);
    }

    public static GeoArmorRenderer getRenderer(Class<? extends ArmorItem> item) {
        GeoArmorRenderer renderer = renderers.get(item);
        if (renderer == null) {
            throw new IllegalArgumentException("Renderer not registered for item " + item);
        }
        return renderer;
    }

    public GeoArmorRenderer(AnimatedGeoModel<T> modelProvider) {
        super(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_));
        this.modelProvider = modelProvider;
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.render(0.0f, matrixStackIn, bufferIn, packedLightIn);
    }

    public void render(float partialTicks, PoseStack stack, VertexConsumer bufferIn, int packedLightIn) {
        stack.m_85837_(0.0, 1.5, 0.0);
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(this.currentArmorItem));
        AnimationEvent<IAnimatable> itemEvent = new AnimationEvent<IAnimatable>((IAnimatable)this.currentArmorItem, 0.0f, 0.0f, 0.0f, false, Arrays.asList(this.itemStack, this.entityLiving, this.armorSlot));
        this.modelProvider.setLivingAnimations(this.currentArmorItem, this.getUniqueID(this.currentArmorItem), (AnimationEvent)itemEvent);
        this.fitToBiped();
        stack.m_85836_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureLocation(this.currentArmorItem));
        Color renderColor = this.getRenderColor(this.currentArmorItem, partialTicks, stack, null, bufferIn, packedLightIn);
        RenderType renderType = this.getRenderType(this.currentArmorItem, partialTicks, stack, null, bufferIn, packedLightIn, this.getTextureLocation(this.currentArmorItem));
        this.render(model, this.currentArmorItem, partialTicks, renderType, stack, null, bufferIn, packedLightIn, OverlayTexture.f_118083_, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliCompat.patchouliLoaded(stack);
        }
        stack.m_85849_();
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_85837_(0.0, -1.5, 0.0);
    }

    protected void fitToBiped() {
        if (!(this.entityLiving instanceof ArmorStand)) {
            if (this.headBone != null) {
                IBone headBone = this.modelProvider.getBone(this.headBone);
                GeoUtils.copyRotations(this.f_102808_, headBone);
                headBone.setPositionX(this.f_102808_.f_104200_);
                headBone.setPositionY(-this.f_102808_.f_104201_);
                headBone.setPositionZ(this.f_102808_.f_104202_);
            }
            if (this.bodyBone != null) {
                IBone bodyBone = this.modelProvider.getBone(this.bodyBone);
                GeoUtils.copyRotations(this.f_102810_, bodyBone);
                bodyBone.setPositionX(this.f_102810_.f_104200_);
                bodyBone.setPositionY(-this.f_102810_.f_104201_);
                bodyBone.setPositionZ(this.f_102810_.f_104202_);
            }
            if (this.rightArmBone != null) {
                IBone rightArmBone = this.modelProvider.getBone(this.rightArmBone);
                GeoUtils.copyRotations(this.f_102811_, rightArmBone);
                rightArmBone.setPositionX(this.f_102811_.f_104200_ + 5.0f);
                rightArmBone.setPositionY(2.0f - this.f_102811_.f_104201_);
                rightArmBone.setPositionZ(this.f_102811_.f_104202_);
            }
            if (this.leftArmBone != null) {
                IBone leftArmBone = this.modelProvider.getBone(this.leftArmBone);
                GeoUtils.copyRotations(this.f_102812_, leftArmBone);
                leftArmBone.setPositionX(this.f_102812_.f_104200_ - 5.0f);
                leftArmBone.setPositionY(2.0f - this.f_102812_.f_104201_);
                leftArmBone.setPositionZ(this.f_102812_.f_104202_);
            }
            if (this.rightLegBone != null) {
                IBone rightLegBone = this.modelProvider.getBone(this.rightLegBone);
                GeoUtils.copyRotations(this.f_102813_, rightLegBone);
                rightLegBone.setPositionX(this.f_102813_.f_104200_ + 2.0f);
                rightLegBone.setPositionY(12.0f - this.f_102813_.f_104201_);
                rightLegBone.setPositionZ(this.f_102813_.f_104202_);
                if (this.rightBootBone != null) {
                    IBone rightBootBone = this.modelProvider.getBone(this.rightBootBone);
                    GeoUtils.copyRotations(this.f_102813_, rightBootBone);
                    rightBootBone.setPositionX(this.f_102813_.f_104200_ + 2.0f);
                    rightBootBone.setPositionY(12.0f - this.f_102813_.f_104201_);
                    rightBootBone.setPositionZ(this.f_102813_.f_104202_);
                }
            }
            if (this.leftLegBone != null) {
                IBone leftLegBone = this.modelProvider.getBone(this.leftLegBone);
                GeoUtils.copyRotations(this.f_102814_, leftLegBone);
                leftLegBone.setPositionX(this.f_102814_.f_104200_ - 2.0f);
                leftLegBone.setPositionY(12.0f - this.f_102814_.f_104201_);
                leftLegBone.setPositionZ(this.f_102814_.f_104202_);
                if (this.leftBootBone != null) {
                    IBone leftBootBone = this.modelProvider.getBone(this.leftBootBone);
                    GeoUtils.copyRotations(this.f_102814_, leftBootBone);
                    leftBootBone.setPositionX(this.f_102814_.f_104200_ - 2.0f);
                    leftBootBone.setPositionY(12.0f - this.f_102814_.f_104201_);
                    leftBootBone.setPositionZ(this.f_102814_.f_104202_);
                }
            }
        }
    }

    @Override
    public AnimatedGeoModel<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    @Override
    public ResourceLocation getTextureLocation(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    public GeoArmorRenderer setCurrentItem(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot) {
        this.entityLiving = entityLiving;
        this.itemStack = itemStack;
        this.armorSlot = armorSlot;
        this.currentArmorItem = (ArmorItem)itemStack.m_41720_();
        return this;
    }

    public final GeoArmorRenderer applyEntityStats(HumanoidModel defaultArmor) {
        this.f_102610_ = defaultArmor.f_102610_;
        this.f_102817_ = defaultArmor.f_102817_;
        this.f_102609_ = defaultArmor.f_102609_;
        this.f_102816_ = defaultArmor.f_102816_;
        this.f_102815_ = defaultArmor.f_102815_;
        return this;
    }

    public GeoArmorRenderer applySlot(EquipmentSlot slot) {
        this.modelProvider.getModel(this.modelProvider.getModelLocation(this.currentArmorItem));
        IBone headBone = this.getAndHideBone(this.headBone);
        IBone bodyBone = this.getAndHideBone(this.bodyBone);
        IBone rightArmBone = this.getAndHideBone(this.rightArmBone);
        IBone leftArmBone = this.getAndHideBone(this.leftArmBone);
        IBone rightLegBone = this.getAndHideBone(this.rightLegBone);
        IBone leftLegBone = this.getAndHideBone(this.leftLegBone);
        IBone rightBootBone = this.getAndHideBone(this.rightBootBone);
        IBone leftBootBone = this.getAndHideBone(this.leftBootBone);
        switch (slot) {
            case HEAD: {
                if (headBone == null) break;
                headBone.setHidden(false);
                break;
            }
            case CHEST: {
                if (bodyBone != null) {
                    bodyBone.setHidden(false);
                }
                if (rightArmBone != null) {
                    rightArmBone.setHidden(false);
                }
                if (leftArmBone == null) break;
                leftArmBone.setHidden(false);
                break;
            }
            case LEGS: {
                if (rightLegBone != null) {
                    rightLegBone.setHidden(false);
                }
                if (leftLegBone == null) break;
                leftLegBone.setHidden(false);
                break;
            }
            case FEET: {
                if (rightBootBone != null) {
                    rightBootBone.setHidden(false);
                }
                if (leftBootBone == null) break;
                leftBootBone.setHidden(false);
            }
        }
        return this;
    }

    protected IBone getAndHideBone(String boneName) {
        if (boneName != null) {
            IBone bone = this.modelProvider.getBone(boneName);
            bone.setHidden(true);
            return bone;
        }
        return null;
    }

    @Override
    public Integer getUniqueID(T animatable) {
        return Objects.hash(this.armorSlot, this.itemStack.m_41720_(), this.itemStack.m_41613_(), this.itemStack.m_41782_() ? this.itemStack.m_41783_().toString() : Integer.valueOf(1), this.entityLiving.m_142081_().toString());
    }

    static {
        AnimationController.addModelFetcher(object -> {
            if (object instanceof ArmorItem) {
                GeoArmorRenderer renderer = renderers.get(object.getClass());
                return renderer == null ? null : renderer.getGeoModelProvider();
            }
            return null;
        });
    }
}

