/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.aoa3.geckolib3.renderers.geo;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.aoa3.geckolib3.core.controller.AnimationController;
import software.bernie.aoa3.geckolib3.core.util.Color;
import software.bernie.aoa3.geckolib3.geo.render.built.GeoModel;
import software.bernie.aoa3.geckolib3.model.AnimatedGeoModel;
import software.bernie.aoa3.geckolib3.renderers.geo.IGeoRenderer;

public abstract class GeoBlockRenderer<T extends BlockEntity>
implements IGeoRenderer<T>,
BlockEntityRenderer {
    private final AnimatedGeoModel<T> modelProvider;

    public GeoBlockRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn, AnimatedGeoModel<T> modelProvider) {
        this.modelProvider = modelProvider;
    }

    public void m_6922_(BlockEntity tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.render(tile, partialTicks, matrixStackIn, bufferIn, combinedLightIn);
    }

    public void render(T tile, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(tile));
        this.modelProvider.setLivingAnimations(tile, this.getUniqueID(tile));
        stack.m_85836_();
        stack.m_85837_(0.0, (double)0.01f, 0.0);
        stack.m_85837_(0.5, 0.0, 0.5);
        this.rotateBlock(this.getFacing(tile), stack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureLocation(tile));
        Color renderColor = this.getRenderColor(tile, partialTicks, stack, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(tile, partialTicks, stack, bufferIn, null, packedLightIn, this.getTextureLocation(tile));
        this.render(model, tile, partialTicks, renderType, stack, bufferIn, null, packedLightIn, OverlayTexture.f_118083_, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        stack.m_85849_();
    }

    @Override
    public Integer getUniqueID(T animatable) {
        return animatable.m_58899_().hashCode();
    }

    @Override
    public AnimatedGeoModel<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    protected void rotateBlock(Direction facing, PoseStack stack) {
        switch (facing) {
            case SOUTH: {
                stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                break;
            }
            case WEST: {
                stack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                break;
            }
            case NORTH: {
                stack.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
                break;
            }
            case EAST: {
                stack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
                break;
            }
            case UP: {
                stack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                break;
            }
            case DOWN: {
                stack.m_85845_(Vector3f.f_122222_.m_122240_(90.0f));
            }
        }
    }

    private Direction getFacing(T tile) {
        BlockState blockState = tile.m_58900_();
        if (blockState.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
            return (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        }
        if (blockState.m_61138_((Property)DirectionalBlock.f_52588_)) {
            return (Direction)blockState.m_61143_((Property)DirectionalBlock.f_52588_);
        }
        return Direction.NORTH;
    }

    @Override
    public ResourceLocation getTextureLocation(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    static {
        AnimationController.addModelFetcher(object -> {
            if (object instanceof BlockEntity) {
                BlockEntity tile = (BlockEntity)object;
                BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(tile);
                if (renderer instanceof GeoBlockRenderer) {
                    return ((GeoBlockRenderer)renderer).getGeoModelProvider();
                }
            }
            return null;
        });
    }
}

