/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.aoa3.geckolib3.renderers.geo;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import software.bernie.aoa3.geckolib3.compat.PatchouliCompat;
import software.bernie.aoa3.geckolib3.core.IAnimatableModel;
import software.bernie.aoa3.geckolib3.core.controller.AnimationController;
import software.bernie.aoa3.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.aoa3.geckolib3.core.util.Color;
import software.bernie.aoa3.geckolib3.geo.render.built.GeoModel;
import software.bernie.aoa3.geckolib3.model.AnimatedGeoModel;
import software.bernie.aoa3.geckolib3.model.provider.GeoModelProvider;
import software.bernie.aoa3.geckolib3.model.provider.data.EntityModelData;
import software.bernie.aoa3.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.aoa3.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.aoa3.geckolib3.util.AnimationUtils;

public abstract class GeoEntityRenderer<T extends LivingEntity>
extends EntityRenderer<T>
implements IGeoRenderer<T> {
    protected final AnimatedGeoModel<T> modelProvider;
    protected final List<GeoLayerRenderer<T>> layerRenderers = Lists.newArrayList();
    public ItemStack mainHand;
    public ItemStack offHand;
    public ItemStack helmet;
    public ItemStack chestplate;
    public ItemStack leggings;
    public ItemStack boots;
    public MultiBufferSource rtb;
    public ResourceLocation whTexture;

    public GeoEntityRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<T> modelProvider) {
        super(renderManager);
        this.modelProvider = modelProvider;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        Direction direction;
        stack.m_85836_();
        boolean shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = entity.m_6162_();
        float f = Mth.m_14189_((float)partialTicks, (float)((LivingEntity)entity).f_20884_, (float)((LivingEntity)entity).f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)((LivingEntity)entity).f_20886_, (float)((LivingEntity)entity).f_20885_);
        float netHeadYaw = f1 - f;
        if (shouldSit && entity.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.m_20202_();
            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            netHeadYaw = f1 - f;
            float f3 = Mth.m_14177_((float)netHeadYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            netHeadYaw = f1 - f;
        }
        float headPitch = Mth.m_14179_((float)partialTicks, (float)entity.m_146909_(), (float)entity.m_146909_());
        if (entity.m_20089_() == Pose.SLEEPING && (direction = entity.m_21259_()) != null) {
            float f4 = entity.m_20236_(Pose.STANDING) - 0.1f;
            stack.m_85837_((double)((float)(-direction.m_122429_()) * f4), 0.0, (double)((float)(-direction.m_122431_()) * f4));
        }
        float f7 = this.handleRotationFloat(entity, partialTicks);
        this.applyRotations(entity, stack, f7, f, partialTicks);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && entity.m_6084_()) {
            limbSwingAmount = Mth.m_14179_((float)partialTicks, (float)((LivingEntity)entity).f_20923_, (float)((LivingEntity)entity).f_20924_);
            limbSwing = ((LivingEntity)entity).f_20925_ - ((LivingEntity)entity).f_20924_ * (1.0f - partialTicks);
            if (entity.m_6162_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -netHeadYaw;
        AnimationEvent<T> predicate = new AnimationEvent<T>(entity, limbSwing, limbSwingAmount, partialTicks, !(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f), Collections.singletonList(entityModelData));
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(entity));
        if (this.modelProvider instanceof IAnimatableModel) {
            this.modelProvider.setLivingAnimations(entity, this.getUniqueID(entity), (AnimationEvent)predicate);
        }
        stack.m_85837_(0.0, (double)0.01f, 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureLocation(entity));
        Color renderColor = this.getRenderColor(entity, partialTicks, stack, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(entity, partialTicks, stack, bufferIn, null, packedLightIn, this.getTextureLocation(entity));
        if (!entity.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            this.render(model, entity, partialTicks, renderType, stack, bufferIn, null, packedLightIn, GeoEntityRenderer.getPackedOverlay(entity, 0.0f), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        }
        if (!entity.m_5833_()) {
            for (GeoLayerRenderer<T> layerRenderer : this.layerRenderers) {
                layerRenderer.render(stack, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, f7, netHeadYaw, headPitch);
            }
        }
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliCompat.patchouliLoaded(stack);
        }
        stack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
    }

    @Override
    public Integer getUniqueID(T animatable) {
        return animatable.m_142081_().hashCode();
    }

    @Override
    public void renderEarly(T animatable, PoseStack stackIn, float ticks, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        this.mainHand = animatable.m_6844_(EquipmentSlot.MAINHAND);
        this.offHand = animatable.m_6844_(EquipmentSlot.OFFHAND);
        this.helmet = animatable.m_6844_(EquipmentSlot.HEAD);
        this.chestplate = animatable.m_6844_(EquipmentSlot.CHEST);
        this.leggings = animatable.m_6844_(EquipmentSlot.LEGS);
        this.boots = animatable.m_6844_(EquipmentSlot.FEET);
        this.rtb = renderTypeBuffer;
        this.whTexture = this.getTextureLocation(animatable);
        IGeoRenderer.super.renderEarly(animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
    }

    @Override
    public GeoModelProvider<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    public static int getPackedOverlay(LivingEntity livingEntityIn, float uIn) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)uIn), (int)OverlayTexture.m_118096_((livingEntityIn.f_20916_ > 0 || livingEntityIn.f_20919_ > 0 ? 1 : 0) != 0));
    }

    protected void applyRotations(T entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        String s;
        Pose pose = entityLiving.m_20089_();
        if (pose != Pose.SLEEPING) {
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rotationYaw));
        }
        if (((LivingEntity)entityLiving).f_20919_ > 0) {
            float f = ((float)((LivingEntity)entityLiving).f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(f * this.getDeathMaxRotation(entityLiving)));
        } else if (entityLiving.m_21209_()) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f - entityLiving.m_146909_()));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(((float)((LivingEntity)entityLiving).f_19797_ + partialTicks) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction direction = entityLiving.m_21259_();
            float f1 = direction != null ? GeoEntityRenderer.getFacingAngle(direction) : rotationYaw;
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f1));
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(this.getDeathMaxRotation(entityLiving)));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
        } else if ((entityLiving.m_8077_() || entityLiving instanceof Player) && ("Dinnerbone".equals(s = ChatFormatting.m_126649_((String)entityLiving.m_7755_().getString())) || "Grumm".equals(s)) && (!(entityLiving instanceof Player) || ((Player)entityLiving).m_36170_(PlayerModelPart.CAPE))) {
            matrixStackIn.m_85837_(0.0, (double)(entityLiving.m_20206_() + 0.1f), 0.0);
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        }
    }

    protected boolean isVisible(T livingEntityIn) {
        return !livingEntityIn.m_20145_();
    }

    private static float getFacingAngle(Direction facingIn) {
        switch (facingIn) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected float getDeathMaxRotation(T entityLivingBaseIn) {
        return 90.0f;
    }

    public boolean shouldShowName(T entity) {
        float f;
        double d0 = this.f_114476_.m_114471_(entity);
        float f2 = f = entity.m_20163_() ? 32.0f : 64.0f;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        return entity == this.f_114476_.f_114359_ && entity.m_8077_();
    }

    protected float getSwingProgress(T livingBase, float partialTickTime) {
        return livingBase.m_21324_(partialTickTime);
    }

    protected float handleRotationFloat(T livingBase, float partialTicks) {
        return (float)((LivingEntity)livingBase).f_19797_ + partialTicks;
    }

    @Override
    public ResourceLocation getTextureLocation(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    public final boolean addLayer(GeoLayerRenderer<T> layer) {
        return this.layerRenderers.add(layer);
    }

    static {
        AnimationController.addModelFetcher(object -> {
            if (object instanceof Entity) {
                return (IAnimatableModel)((Object)AnimationUtils.getGeoModelForEntity((Entity)object));
            }
            return null;
        });
    }
}

