/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.aoa3.geckolib3.renderers.geo;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.RenderProperties;
import software.bernie.aoa3.geckolib3.core.IAnimatable;
import software.bernie.aoa3.geckolib3.core.controller.AnimationController;
import software.bernie.aoa3.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.aoa3.geckolib3.core.util.Color;
import software.bernie.aoa3.geckolib3.geo.render.built.GeoModel;
import software.bernie.aoa3.geckolib3.model.AnimatedGeoModel;
import software.bernie.aoa3.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.aoa3.geckolib3.util.GeckoLibUtil;

public abstract class GeoItemRenderer<T extends Item>
extends BlockEntityWithoutLevelRenderer
implements IGeoRenderer<T> {
    protected AnimatedGeoModel<T> modelProvider;
    protected ItemStack currentItemStack;

    public GeoItemRenderer(AnimatedGeoModel<T> modelProvider) {
        this(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_(), modelProvider);
    }

    public GeoItemRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet, AnimatedGeoModel<T> modelProvider) {
        super(dispatcher, modelSet);
        this.modelProvider = modelProvider;
    }

    public void setModel(AnimatedGeoModel<T> model) {
        this.modelProvider = model;
    }

    @Override
    public AnimatedGeoModel<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    public void m_108829_(ItemStack itemStack, ItemTransforms.TransformType p_239207_2_, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int p_239207_6_) {
        if (p_239207_2_ == ItemTransforms.TransformType.GUI) {
            matrixStack.m_85836_();
            MultiBufferSource.BufferSource irendertypebuffer$impl = Minecraft.m_91087_().m_91269_().m_110104_();
            Lighting.m_84930_();
            this.render(itemStack.m_41720_(), matrixStack, bufferIn, combinedLightIn, itemStack);
            irendertypebuffer$impl.m_109911_();
            RenderSystem.m_69482_();
            Lighting.m_84931_();
            matrixStack.m_85849_();
        } else {
            this.render(itemStack.m_41720_(), matrixStack, bufferIn, combinedLightIn, itemStack);
        }
    }

    public void render(T animatable, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn, ItemStack itemStack) {
        this.currentItemStack = itemStack;
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(animatable));
        AnimationEvent<IAnimatable> itemEvent = new AnimationEvent<IAnimatable>((IAnimatable)animatable, 0.0f, 0.0f, Minecraft.m_91087_().m_91296_(), false, Collections.singletonList(itemStack));
        this.modelProvider.setLivingAnimations(animatable, this.getUniqueID(animatable), (AnimationEvent)itemEvent);
        stack.m_85836_();
        stack.m_85837_(0.0, (double)0.01f, 0.0);
        stack.m_85837_(0.5, 0.5, 0.5);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureLocation(animatable));
        Color renderColor = this.getRenderColor(animatable, 0.0f, stack, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(animatable, 0.0f, stack, bufferIn, null, packedLightIn, this.getTextureLocation(animatable));
        this.render(model, animatable, 0.0f, renderType, stack, bufferIn, null, packedLightIn, OverlayTexture.f_118083_, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        stack.m_85849_();
    }

    @Override
    public ResourceLocation getTextureLocation(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    @Override
    public Integer getUniqueID(T animatable) {
        return GeckoLibUtil.getIDFromStack(this.currentItemStack);
    }

    static {
        AnimationController.addModelFetcher(object -> {
            Item item;
            BlockEntityWithoutLevelRenderer renderer;
            if (object instanceof Item && (renderer = RenderProperties.get((Item)(item = (Item)object)).getItemStackRenderer()) instanceof GeoItemRenderer) {
                return ((GeoItemRenderer)renderer).getGeoModelProvider();
            }
            return null;
        });
    }
}

