/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.container.item;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.IRoutingFilterProvider;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ContainerFilter
extends AbstractContainerMenu {
    public final InventoryFilter inventoryFilter;
    private final int PLAYER_INVENTORY_ROWS = 3;
    private final int PLAYER_INVENTORY_COLUMNS = 9;
    public final Player player;
    public final ItemStack filterStack;
    public int lastGhostSlotClicked = -1;
    private int slotsOccupied = 9;

    public ContainerFilter(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(windowId, playerInventory.f_35978_, playerInventory, extraData.m_130267_());
    }

    public ContainerFilter(int windowId, Player player, Inventory playerInventory, ItemStack filterStack) {
        super((MenuType)BloodMagicBlocks.FILTER_CONTAINER.get(), windowId);
        this.player = player;
        this.filterStack = filterStack;
        this.inventoryFilter = new InventoryFilter(filterStack);
        int currentSlotHeldIn = player.m_150109_().f_35977_;
        this.setup(playerInventory, currentSlotHeldIn);
    }

    public void setup(Inventory inventory, int currentSlotHeldIn) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new SlotGhostItem(this, this.inventoryFilter, this.player, j + i * 3, 110 + j * 21, 15 + i * 21));
            }
        }
        for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < 9; ++columnIndex) {
                this.m_38897_(new Slot((Container)this.player.m_150109_(), columnIndex + rowIndex * 9 + 9, 8 + columnIndex * 18, 105 + rowIndex * 18));
            }
        }
        for (int actionBarIndex = 0; actionBarIndex < 9; ++actionBarIndex) {
            if (actionBarIndex == currentSlotHeldIn) {
                this.m_38897_(new SlotDisabled((Container)this.player.m_150109_(), actionBarIndex, 8 + actionBarIndex * 18, 163));
                continue;
            }
            this.m_38897_(new Slot((Container)this.player.m_150109_(), actionBarIndex, 8 + actionBarIndex * 18, 163));
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        Slot slot;
        Inventory inventoryPlayer = player.m_150109_();
        if (slotId >= 0 && (slot = (Slot)this.f_38839_.get(slotId)) instanceof SlotGhostItem) {
            this.lastGhostSlotClicked = slot.getSlotIndex();
            if (dragType == 0 || dragType == 1) {
                ItemStack slotStack = slot.m_7993_();
                ItemStack heldStack = this.m_142621_();
                if (dragType == 0) {
                    if (heldStack.m_41619_() && !slotStack.m_41619_()) {
                        return;
                    }
                    if (!heldStack.m_41619_() && slotStack.m_41619_()) {
                        if (!((SlotGhostItem)slot).canBeAccessed()) {
                            super.m_150399_(slotId, dragType, clickTypeIn, player);
                            return;
                        }
                        ItemStack copyStack = heldStack.m_41777_();
                        GhostItemHelper.setItemGhostAmount(copyStack, 0);
                        copyStack.m_41764_(1);
                        slot.m_5852_(copyStack);
                        if (this.filterStack.m_41720_() instanceof IRoutingFilterProvider) {
                            ItemStack filterCopy = ((IRoutingFilterProvider)this.filterStack.m_41720_()).getContainedStackForItem(this.filterStack, heldStack);
                            slot.m_5852_(filterCopy);
                        }
                    }
                } else {
                    slot.m_5852_(ItemStack.f_41583_);
                }
            }
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public boolean m_6875_(Player entityPlayer) {
        return true;
    }

    public void m_6877_(Player entityPlayer) {
        super.m_6877_(entityPlayer);
        if (!entityPlayer.m_20193_().f_46443_) {
            this.saveInventory(entityPlayer);
        }
    }

    public void m_38946_() {
        super.m_38946_();
        if (!this.player.m_20193_().f_46443_) {
            this.saveInventory(this.player);
        }
    }

    public ItemStack m_7648_(Player entityPlayer, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotIndex >= 0 ? itemstack1.m_41720_() instanceof IRoutingFilterProvider && !this.m_38903_(itemstack1, 0, 1, false) : !this.m_38903_(itemstack1, this.slotsOccupied, 36 + this.slotsOccupied, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(entityPlayer, itemstack1);
        }
        return itemstack;
    }

    public void saveInventory(Player entityPlayer) {
        this.inventoryFilter.onGuiSaved(entityPlayer);
    }

    private class SlotGhostItem
    extends Slot {
        private final Player player;
        private ContainerFilter containerHolding;

        public SlotGhostItem(ContainerFilter containerHolding, Container inventory, Player player, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
            this.player = player;
            this.containerHolding = containerHolding;
        }

        public void m_6654_() {
            super.m_6654_();
            if (EffectiveSide.get().isServer()) {
                this.containerHolding.saveInventory(this.player);
            }
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player playerIn) {
            return false;
        }

        public boolean canBeAccessed() {
            return this.containerHolding.inventoryFilter.canInventoryBeManipulated();
        }
    }

    private class SlotDisabled
    extends Slot {
        public SlotDisabled(Container inventory, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
        }

        public boolean m_5857_(ItemStack itemStack) {
            return false;
        }

        public boolean m_8010_(Player player) {
            return false;
        }
    }
}

