/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.ILivingUpgradePointsProvider;

public class ItemLivingTomeScrap
extends Item
implements ILivingUpgradePointsProvider {
    public ItemLivingTomeScrap() {
        super(new Item.Properties().m_41487_(1).m_41491_(BloodMagic.TAB));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.livingtomescrap.desc").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.livingtomescrap.points", new Object[]{this.getTotalUpgradePoints(stack)}).m_130940_(ChatFormatting.GOLD));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.m_41389_(group)) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)this);
        this.setTotalUpgradePoints(stack, 256);
        items.add((Object)stack);
    }

    @Override
    public int getAvailableUpgradePoints(ItemStack stack, int drain) {
        return Math.min(this.getTotalUpgradePoints(stack), drain);
    }

    @Override
    public ItemStack getResultingStack(ItemStack stack, int syphonedPoints) {
        if (this.canSyphonPoints(stack, syphonedPoints)) {
            int totalPoints = this.getTotalUpgradePoints(stack);
            int remaining = Math.max(0, totalPoints - syphonedPoints);
            if (remaining > 0) {
                ItemStack newStack = stack.m_41777_();
                this.setTotalUpgradePoints(newStack, remaining);
                return newStack;
            }
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @Override
    public int getExcessUpgradePoints(ItemStack stack, int drain) {
        return this.getTotalUpgradePoints(stack) - this.getAvailableUpgradePoints(stack, drain);
    }

    @Override
    public boolean canSyphonPoints(ItemStack stack, int drain) {
        return true;
    }

    public void setTotalUpgradePoints(ItemStack stack, int points) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = stack.m_41783_();
        tag.m_128405_("storedPoints", points);
    }

    @Override
    public int getTotalUpgradePoints(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = stack.m_41783_();
        return tag.m_128451_("storedPoints");
    }

    @Override
    public int getPriority(ItemStack stack) {
        return 0;
    }
}

