/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.client.button.FilterButtonTogglePress;
import wayoftime.bloodmagic.common.container.item.ContainerFilter;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.CollectionEnchantFilterKey;
import wayoftime.bloodmagic.common.item.routing.EnchantFilterKey;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.INestableItemFilterProvider;
import wayoftime.bloodmagic.common.item.routing.ItemRouterFilter;
import wayoftime.bloodmagic.common.item.routing.NoEnchantsFilterKey;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ItemEnchantFilterCore
extends ItemRouterFilter
implements INestableItemFilterProvider {
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack filterStack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.enchantfilter.desc").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        if (filterStack.m_41783_() == null) {
            return;
        }
        boolean sneaking = Screen.m_96638_();
        if (!sneaking) {
            tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.extraInfo").m_130940_(ChatFormatting.BLUE));
        } else {
            boolean isWhitelist;
            int whitelistState = this.getCurrentButtonState(filterStack, "blackwhitelist", 0);
            boolean bl = isWhitelist = whitelistState == 0;
            if (isWhitelist) {
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.whitelist").m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.blacklist").m_130940_(ChatFormatting.GRAY));
            }
            InventoryFilter inv = new InventoryFilter(filterStack);
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (stack.m_41619_()) continue;
                List<Component> list = this.getTextForHoverItem(filterStack, "enchant", i);
                List<Component> fuzzyList = this.getTextForHoverItem(filterStack, "enchant_lvl", i);
                if (list.size() <= 0 || fuzzyList.size() <= 0) continue;
                TranslatableComponent fuzzyText = new TranslatableComponent("tooltip.bloodmagic.filter.enchant_combination", new Object[]{fuzzyList.get(0), list.get(0)});
                if (isWhitelist) {
                    int amount = GhostItemHelper.getItemGhostAmount(stack);
                    if (amount > 0) {
                        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.count", new Object[]{amount, fuzzyText}));
                    } else {
                        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.all", new Object[]{fuzzyText}));
                    }
                } else {
                    tooltip.add((Component)fuzzyText);
                }
                for (int j = 1; j < list.size(); ++j) {
                    tooltip.add(list.get(j));
                }
            }
        }
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        int index = this.getEnchantmentIndex(filterStack, slot);
        boolean isFuzzy = this.getIsFuzzy(filterStack, slot);
        if (index == 0 || index == 1) {
            Map enchants = EnchantmentHelper.m_44831_((ItemStack)ghostStack);
            if (enchants.size() <= 0) {
                return new NoEnchantsFilterKey(amount);
            }
            boolean matchAll = index == 1;
            return new CollectionEnchantFilterKey(enchants, isFuzzy, matchAll, amount);
        }
        Pair<Enchantment, Integer> enchant = this.getEnchantment(filterStack, slot);
        if (enchant != null) {
            return new EnchantFilterKey((Enchantment)enchant.getKey(), (Integer)enchant.getRight(), isFuzzy, amount);
        }
        return new NoEnchantsFilterKey(amount);
    }

    public int getEnchantmentIndex(ItemStack filterStack, int slot) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            filterStack.m_41751_(tag);
        }
        return tag.m_128451_("button:enchant" + slot);
    }

    public void setEnchantmentIndex(ItemStack filterStack, int slot, int index) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            filterStack.m_41751_(tag);
        }
        tag.m_128405_("button:enchant" + slot, index);
    }

    public void cycleToNextEnchant(ItemStack filterStack, int slot) {
        InventoryFilter inv = new InventoryFilter(filterStack);
        ItemStack ghostStack = inv.m_8020_(slot);
        if (ghostStack.m_41619_()) {
            return;
        }
        int index = this.getEnchantmentIndex(filterStack, slot);
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)ghostStack);
        if (++index >= enchants.size() + 2 || enchants.size() == 0) {
            index = 0;
        }
        if (enchants.size() == 1 && index == 1) {
            index = 2;
        }
        this.setEnchantmentIndex(filterStack, slot, index);
    }

    public Pair<Enchantment, Integer> getEnchantment(ItemStack filterStack, int slot) {
        int index = this.getEnchantmentIndex(filterStack, slot);
        if (index <= 0) {
            return null;
        }
        index -= 2;
        InventoryFilter inv = new InventoryFilter(filterStack);
        ItemStack ghostStack = inv.m_8020_(slot);
        if (ghostStack.m_41619_()) {
            return null;
        }
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)ghostStack);
        if (enchants.size() < index) {
            return null;
        }
        ArrayList enchantList = new ArrayList(enchants.entrySet());
        Map.Entry entry = enchantList.get(index);
        return Pair.of((Object)((Enchantment)entry.getKey()), (Object)((Integer)entry.getValue()));
    }

    public boolean getIsFuzzy(ItemStack filterStack, int slot) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            filterStack.m_41751_(tag);
        }
        return tag.m_128471_("button:enchant_fuzzy" + slot);
    }

    public void setIsFuzzy(ItemStack filterStack, int slot, boolean value) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            filterStack.m_41751_(tag);
        }
        tag.m_128379_("button:enchant_fuzzy" + slot, value);
    }

    @Override
    public int receiveButtonPress(ItemStack filterStack, String buttonKey, int ghostItemSlot, int currentButtonState) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag == null) {
            filterStack.m_41751_(new CompoundTag());
            tag = filterStack.m_41783_();
        }
        if (buttonKey.equals("enchant")) {
            this.cycleToNextEnchant(filterStack, ghostItemSlot);
        } else if (buttonKey.equals("enchant_lvl")) {
            this.setIsFuzzy(filterStack, ghostItemSlot, currentButtonState == 0);
        }
        return super.receiveButtonPress(filterStack, buttonKey, ghostItemSlot, currentButtonState);
    }

    @Override
    public int getCurrentButtonState(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag != null) {
            if (buttonKey.equals("enchant")) {
                int state = this.getEnchantmentIndex(filterStack, ghostItemSlot);
                return state;
            }
            if (buttonKey.equals("enchant_lvl")) {
                return this.getIsFuzzy(filterStack, ghostItemSlot) ? 1 : 0;
            }
        }
        return super.getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<Component> getTextForHoverItem(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        List<Component> componentList = super.getTextForHoverItem(filterStack, buttonKey, ghostItemSlot);
        if (ghostItemSlot < 0) {
            return componentList;
        }
        int currentState = this.getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
        if (buttonKey.equals("enchant")) {
            if (currentState != 0 && currentState != 1) {
                Pair<Enchantment, Integer> enchant = this.getEnchantment(filterStack, ghostItemSlot);
                if (enchant == null) return componentList;
                componentList.add(((Enchantment)enchant.getLeft()).m_44700_(((Integer)enchant.getRight()).intValue()));
                return componentList;
            }
            InventoryFilter inv = new InventoryFilter(filterStack);
            ItemStack ghostStack = inv.m_8020_(ghostItemSlot);
            if (ghostStack.m_41619_()) {
                componentList.add((Component)new TranslatableComponent("filter.bloodmagic.noenchant"));
                return componentList;
            }
            Map enchants = EnchantmentHelper.m_44831_((ItemStack)ghostStack);
            if (enchants.size() <= 0) {
                componentList.add((Component)new TranslatableComponent("filter.bloodmagic.noenchant"));
                return componentList;
            }
            if (currentState == 0) {
                componentList.add((Component)new TranslatableComponent("filter.bloodmagic.anyenchant"));
            } else {
                componentList.add((Component)new TranslatableComponent("filter.bloodmagic.allenchant"));
            }
            Iterator iterator = enchants.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                componentList.add(((Enchantment)entry.getKey()).m_44700_(((Integer)entry.getValue()).intValue()));
            }
            return componentList;
        }
        if (!buttonKey.equals("enchant_lvl")) return componentList;
        boolean isFuzzy = this.getIsFuzzy(filterStack, ghostItemSlot);
        if (isFuzzy) {
            componentList.add((Component)new TranslatableComponent("filter.bloodmagic.enchantfuzzy"));
            return componentList;
        }
        componentList.add((Component)new TranslatableComponent("filter.bloodmagic.enchantnotfuzzy"));
        return componentList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<String, Button.OnPress>> getButtonAction(ContainerFilter container) {
        List<Pair<String, Button.OnPress>> buttonList = super.getButtonAction(container);
        buttonList.add((Pair<String, Button.OnPress>)Pair.of((Object)"enchant", (Object)new FilterButtonTogglePress("enchant", container)));
        buttonList.add((Pair<String, Button.OnPress>)Pair.of((Object)"enchant_lvl", (Object)new FilterButtonTogglePress("enchant_lvl", container)));
        return buttonList;
    }

    @Override
    public Pair<Integer, Integer> getTexturePositionForState(ItemStack filterStack, String buttonKey, int currentButtonState) {
        if (buttonKey.equals("enchant")) {
            switch (currentButtonState) {
                case 0: {
                    return Pair.of((Object)216, (Object)0);
                }
                case 1: {
                    return Pair.of((Object)216, (Object)20);
                }
            }
            return Pair.of((Object)216, (Object)40);
        }
        if (buttonKey.equals("enchant_lvl")) {
            switch (currentButtonState) {
                case 0: {
                    return Pair.of((Object)236, (Object)0);
                }
            }
            return Pair.of((Object)236, (Object)20);
        }
        return super.getTexturePositionForState(filterStack, buttonKey, currentButtonState);
    }

    @Override
    public boolean isButtonGlobal(ItemStack filterStack, String buttonKey) {
        return super.isButtonGlobal(filterStack, buttonKey);
    }
}

