/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import wayoftime.bloodmagic.recipe.RecipeAlchemyArray;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class AlchemyArrayRecipeSerializer<RECIPE extends RecipeAlchemyArray>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public AlchemyArrayRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input1 = GsonHelper.m_13885_((JsonObject)json, (String)"baseinput") ? GsonHelper.m_13933_((JsonObject)json, (String)"baseinput") : GsonHelper.m_13930_((JsonObject)json, (String)"baseinput");
        JsonArray input2 = GsonHelper.m_13885_((JsonObject)json, (String)"addedinput") ? GsonHelper.m_13933_((JsonObject)json, (String)"addedinput") : GsonHelper.m_13930_((JsonObject)json, (String)"addedinput");
        Ingredient baseInput = Ingredient.m_43917_((JsonElement)input1);
        Ingredient addedInput = Ingredient.m_43917_((JsonElement)input2);
        ResourceLocation texture = null;
        if (json.has("texture")) {
            texture = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"texture"));
        }
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        return this.factory.create(recipeId, texture, baseInput, addedInput, output);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        ResourceLocation texture = null;
        if (buffer.readBoolean()) {
            texture = buffer.m_130281_();
        }
        Ingredient baseInput = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        Ingredient addedInput = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack output = buffer.m_130267_();
        return this.factory.create(recipeId, texture, baseInput, addedInput, output);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        ((RecipeAlchemyArray)recipe).write(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipeAlchemyArray> {
        public RECIPE create(ResourceLocation var1, ResourceLocation var2, Ingredient var3, Ingredient var4, ItemStack var5);
    }
}

