/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile.routing;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Triple;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.container.tile.ContainerMasterRoutingNode;
import wayoftime.bloodmagic.common.item.routing.IRouterUpgrade;
import wayoftime.bloodmagic.common.routing.IInputItemRoutingNode;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.common.routing.IMasterRoutingNode;
import wayoftime.bloodmagic.common.routing.IOutputItemRoutingNode;
import wayoftime.bloodmagic.common.routing.IRoutingNode;
import wayoftime.bloodmagic.common.routing.NodeHelper;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileInventory;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;

public class TileMasterRoutingNode
extends TileInventory
implements IMasterRoutingNode,
MenuProvider {
    public static final int tickRate = 20;
    private int currentInput;
    private TreeMap<BlockPos, List<BlockPos>> connectionMap = new TreeMap();
    private List<BlockPos> generalNodeList = new LinkedList<BlockPos>();
    private List<BlockPos> outputNodeList = new LinkedList<BlockPos>();
    private List<BlockPos> inputNodeList = new LinkedList<BlockPos>();
    private static final int TREE_OFFSET = 10;
    public static final int SLOT = 0;

    public TileMasterRoutingNode(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, 1, "masterroutingnode", pos, state);
    }

    public TileMasterRoutingNode(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.MASTER_ROUTING_NODE_TYPE.get(), pos, state);
    }

    /*
     * WARNING - void declaration
     */
    public void tick() {
        if (!this.m_58904_().f_46443_) {
            this.currentInput = this.m_58904_().m_46751_(this.f_58858_);
        }
        if (this.m_58904_().f_46443_ || this.m_58904_().m_46467_() % 20L != 0L) {
            return;
        }
        TreeMap outputMap = new TreeMap();
        for (BlockPos blockPos : this.outputNodeList) {
            BlockEntity outputTile = this.m_58904_().m_7702_(blockPos);
            if (!this.isConnected(new LinkedList<BlockPos>(), blockPos) || !(outputTile instanceof IOutputItemRoutingNode)) continue;
            IOutputItemRoutingNode outputNode = (IOutputItemRoutingNode)outputTile;
            for (Direction facing : Direction.values()) {
                IItemFilter filter;
                if (!outputNode.isInventoryConnectedToSide(facing) || !outputNode.isOutput(facing) || (filter = outputNode.getOutputFilterForSide(facing)) == null) continue;
                int priority = outputNode.getPriority(facing);
                if (outputMap.containsKey(10 - priority)) {
                    ((List)outputMap.get(10 - priority)).add(filter);
                    continue;
                }
                LinkedList<IItemFilter> filterList = new LinkedList<IItemFilter>();
                filterList.add(filter);
                outputMap.put(10 - priority, filterList);
            }
        }
        TreeMap inputMap = new TreeMap();
        for (BlockPos inputPos : this.inputNodeList) {
            BlockEntity inputTile = this.m_58904_().m_7702_(inputPos);
            if (!this.isConnected(new LinkedList<BlockPos>(), inputPos) || !(inputTile instanceof IInputItemRoutingNode)) continue;
            IInputItemRoutingNode inputNode = (IInputItemRoutingNode)inputTile;
            for (Direction facing : Direction.values()) {
                IItemFilter filter;
                if (!inputNode.isInventoryConnectedToSide(facing) || !inputNode.isInput(facing) || (filter = inputNode.getInputFilterForSide(facing)) == null) continue;
                int priority = inputNode.getPriority(facing);
                if (inputMap.containsKey(10 - priority)) {
                    ((List)inputMap.get(10 - priority)).add(filter);
                    continue;
                }
                LinkedList<IItemFilter> filterList = new LinkedList<IItemFilter>();
                filterList.add(filter);
                inputMap.put(10 - priority, filterList);
            }
        }
        int n = this.getMaxTransferForDemonWill(WorldDemonWillHandler.getCurrentWill(this.m_58904_(), this.f_58858_, EnumDemonWillType.DEFAULT));
        int maxFluidTransfer = 1000;
        for (Map.Entry outputEntry : outputMap.entrySet()) {
            List outputList = (List)outputEntry.getValue();
            for (IItemFilter outputFilter : outputList) {
                for (Map.Entry inputEntry : inputMap.entrySet()) {
                    List inputList = (List)inputEntry.getValue();
                    for (IItemFilter inputFilter : inputList) {
                        void var3_6;
                        int amountTransfered;
                        if ((var3_6 -= (amountTransfered = inputFilter.transferThroughInputFilter(outputFilter, (int)var3_6))) > 0) continue;
                        return;
                    }
                }
            }
        }
    }

    public int getMaxTransferForDemonWill(double will) {
        int rate = 16;
        ItemStack upgradeStack = this.m_8020_(0);
        if (!upgradeStack.m_41619_() && upgradeStack.m_41720_() instanceof IRouterUpgrade) {
            rate += ((IRouterUpgrade)upgradeStack.m_41720_()).getMaxTransferIncrease(upgradeStack);
        }
        return rate;
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        CompoundTag posTag;
        super.serialize(tag);
        ListTag tags = new ListTag();
        for (BlockPos pos : this.generalNodeList) {
            posTag = new CompoundTag();
            posTag.m_128405_("xCoord", pos.m_123341_());
            posTag.m_128405_("yCoord", pos.m_123342_());
            posTag.m_128405_("zCoord", pos.m_123343_());
            tags.add((Object)posTag);
        }
        tag.m_128365_("generalList", (Tag)tags);
        tags = new ListTag();
        for (BlockPos pos : this.inputNodeList) {
            posTag = new CompoundTag();
            posTag.m_128405_("xCoord", pos.m_123341_());
            posTag.m_128405_("yCoord", pos.m_123342_());
            posTag.m_128405_("zCoord", pos.m_123343_());
            tags.add((Object)posTag);
        }
        tag.m_128365_("inputList", (Tag)tags);
        tags = new ListTag();
        for (BlockPos pos : this.outputNodeList) {
            posTag = new CompoundTag();
            posTag.m_128405_("xCoord", pos.m_123341_());
            posTag.m_128405_("yCoord", pos.m_123342_());
            posTag.m_128405_("zCoord", pos.m_123343_());
            tags.add((Object)posTag);
        }
        tag.m_128365_("outputList", (Tag)tags);
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        BlockPos newPos;
        CompoundTag blockTag;
        int i;
        super.deserialize(tag);
        ListTag tags = tag.m_128437_("generalList", 10);
        for (i = 0; i < tags.size(); ++i) {
            blockTag = tags.m_128728_(i);
            newPos = new BlockPos(blockTag.m_128451_("xCoord"), blockTag.m_128451_("yCoord"), blockTag.m_128451_("zCoord"));
            this.generalNodeList.add(newPos);
        }
        tags = tag.m_128437_("inputList", 10);
        for (i = 0; i < tags.size(); ++i) {
            blockTag = tags.m_128728_(i);
            newPos = new BlockPos(blockTag.m_128451_("xCoord"), blockTag.m_128451_("yCoord"), blockTag.m_128451_("zCoord"));
            this.inputNodeList.add(newPos);
        }
        tags = tag.m_128437_("outputList", 10);
        for (i = 0; i < tags.size(); ++i) {
            blockTag = tags.m_128728_(i);
            newPos = new BlockPos(blockTag.m_128451_("xCoord"), blockTag.m_128451_("yCoord"), blockTag.m_128451_("zCoord"));
            this.outputNodeList.add(newPos);
        }
    }

    @Override
    public boolean isConnected(List<BlockPos> path, BlockPos nodePos) {
        BlockEntity tile = this.m_58904_().m_7702_(nodePos);
        if (!(tile instanceof IRoutingNode)) {
            return false;
        }
        IRoutingNode node = (IRoutingNode)tile;
        List<BlockPos> connectionList = node.getConnected();
        path.add(nodePos);
        for (BlockPos testPos : connectionList) {
            if (path.contains(testPos)) continue;
            if (testPos.equals((Object)this.m_58899_()) && node.isConnectionEnabled(testPos)) {
                return true;
            }
            if (!NodeHelper.isNodeConnectionEnabled(this.m_58904_(), node, testPos) || !this.isConnected(path, testPos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnectionEnabled(BlockPos testPos) {
        return this.currentInput <= 0;
    }

    @Override
    public void addNodeToList(IRoutingNode node) {
        BlockPos newPos = node.getCurrentBlockPos();
        if (!this.generalNodeList.contains(newPos)) {
            this.generalNodeList.add(newPos);
        }
        if (node instanceof IInputItemRoutingNode && !this.inputNodeList.contains(newPos)) {
            this.inputNodeList.add(newPos);
        }
        if (node instanceof IOutputItemRoutingNode && !this.outputNodeList.contains(newPos)) {
            this.outputNodeList.add(newPos);
        }
    }

    @Override
    public void addConnections(BlockPos pos, List<BlockPos> connectionList) {
        for (BlockPos testPos : connectionList) {
            this.addConnection(pos, testPos);
        }
    }

    @Override
    public void addConnection(BlockPos pos1, BlockPos pos2) {
        LinkedList<BlockPos> list;
        if (this.connectionMap.containsKey(pos1) && !this.connectionMap.get(pos1).contains(pos2)) {
            this.connectionMap.get(pos1).add(pos2);
        } else {
            list = new LinkedList<BlockPos>();
            list.add(pos2);
            this.connectionMap.put(pos1, list);
        }
        if (this.connectionMap.containsKey(pos2) && !this.connectionMap.get(pos2).contains(pos1)) {
            this.connectionMap.get(pos2).add(pos1);
        } else {
            list = new LinkedList();
            list.add(pos1);
            this.connectionMap.put(pos2, list);
        }
    }

    @Override
    public void removeConnection(BlockPos pos1, BlockPos pos2) {
        List<BlockPos> posList;
        if (this.connectionMap.containsKey(pos1)) {
            posList = this.connectionMap.get(pos1);
            posList.remove(pos2);
            if (posList.isEmpty()) {
                this.connectionMap.remove(pos1);
            }
        }
        if (this.connectionMap.containsKey(pos2)) {
            posList = this.connectionMap.get(pos2);
            posList.remove(pos1);
            if (posList.isEmpty()) {
                this.connectionMap.remove(pos2);
            }
        }
    }

    @Override
    public void connectMasterToRemainingNode(Level world, List<BlockPos> alreadyChecked, IMasterRoutingNode master) {
    }

    @Override
    public BlockPos getCurrentBlockPos() {
        return this.m_58899_();
    }

    @Override
    public List<BlockPos> getConnected() {
        return new LinkedList<BlockPos>();
    }

    @Override
    public BlockPos getMasterPos() {
        return this.m_58899_();
    }

    @Override
    public boolean isMaster(IMasterRoutingNode master) {
        return false;
    }

    @Override
    public void addConnection(BlockPos pos1) {
    }

    @Override
    public void removeConnection(BlockPos pos1) {
        this.generalNodeList.remove(pos1);
        this.inputNodeList.remove(pos1);
        this.outputNodeList.remove(pos1);
    }

    @Override
    public void removeAllConnections() {
        List<BlockPos> list = this.generalNodeList.subList(0, this.generalNodeList.size());
        Iterator<BlockPos> itr = list.iterator();
        while (itr.hasNext()) {
            BlockPos testPos = itr.next();
            BlockEntity tile = this.m_58904_().m_7702_(testPos);
            if (tile instanceof IRoutingNode) {
                ((IRoutingNode)tile).removeConnection(this.f_58858_);
                this.m_58904_().m_7260_(this.m_58899_(), this.m_58904_().m_8055_(testPos), this.m_58904_().m_8055_(testPos), 3);
            }
            itr.remove();
            this.inputNodeList.remove(testPos);
            this.outputNodeList.remove(testPos);
        }
    }

    @Override
    public Triple<Boolean, List<BlockPos>, List<IRoutingNode>> recheckConnectionToMaster(List<BlockPos> alreadyChecked, List<IRoutingNode> nodeList) {
        return Triple.of((Object)true, alreadyChecked, nodeList);
    }

    @Override
    public List<BlockPos> checkAndPurgeConnectionToMaster(BlockPos ignorePos) {
        return new LinkedList<BlockPos>();
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }

    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        assert (this.f_58857_ != null);
        return new ContainerMasterRoutingNode(this, p_createMenu_1_, p_createMenu_2_);
    }

    public Component m_5446_() {
        return new TextComponent("Master Routing Node");
    }
}

