/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile.routing;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Triple;
import wayoftime.bloodmagic.common.routing.IItemRoutingNode;
import wayoftime.bloodmagic.common.routing.IMasterRoutingNode;
import wayoftime.bloodmagic.common.routing.IRoutingNode;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileInventory;

public class TileRoutingNode
extends TileInventory
implements IRoutingNode,
IItemRoutingNode {
    private int currentInput;
    private BlockPos masterPos = BlockPos.f_121853_;
    private List<BlockPos> connectionList = new LinkedList<BlockPos>();
    private AABB boundingBox;

    public TileRoutingNode(BlockEntityType<?> type, int size, String name, BlockPos pos, BlockState state) {
        super(type, size, name, pos, state);
    }

    public TileRoutingNode(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.ROUTING_NODE_TYPE.get(), 1, "routingnode", pos, state);
    }

    public void tick() {
        if (!this.m_58904_().f_46443_) {
            this.currentInput = this.m_58904_().m_46755_(this.f_58858_);
        }
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        super.serialize(tag);
        CompoundTag masterTag = new CompoundTag();
        masterTag.m_128405_("xCoord", this.masterPos.m_123341_());
        masterTag.m_128405_("yCoord", this.masterPos.m_123342_());
        masterTag.m_128405_("zCoord", this.masterPos.m_123343_());
        tag.m_128365_("master", (Tag)masterTag);
        ListTag tags = new ListTag();
        for (BlockPos pos : this.connectionList) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("xCoord", pos.m_123341_());
            posTag.m_128405_("yCoord", pos.m_123342_());
            posTag.m_128405_("zCoord", pos.m_123343_());
            tags.add((Object)posTag);
        }
        tag.m_128365_("connections", (Tag)tags);
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        this.connectionList.clear();
        CompoundTag masterTag = tag.m_128469_("master");
        this.masterPos = new BlockPos(masterTag.m_128451_("xCoord"), masterTag.m_128451_("yCoord"), masterTag.m_128451_("zCoord"));
        ListTag tags = tag.m_128437_("connections", 10);
        for (int i = 0; i < tags.size(); ++i) {
            CompoundTag blockTag = tags.m_128728_(i);
            BlockPos newPos = new BlockPos(blockTag.m_128451_("xCoord"), blockTag.m_128451_("yCoord"), blockTag.m_128451_("zCoord"));
            this.connectionList.add(newPos);
        }
    }

    @Override
    public void removeAllConnections() {
        BlockEntity testTile = this.m_58904_().m_7702_(this.getMasterPos());
        if (testTile instanceof IMasterRoutingNode) {
            ((IMasterRoutingNode)testTile).removeConnection(this.f_58858_);
        }
        for (BlockPos testPos : this.connectionList) {
            BlockEntity tile = this.m_58904_().m_7702_(testPos);
            if (!(tile instanceof IRoutingNode)) continue;
            ((IRoutingNode)tile).removeConnection(this.f_58858_);
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58904_().m_8055_(testPos), this.m_58904_().m_8055_(testPos), 3);
        }
        this.connectionList.clear();
    }

    @Override
    public void connectMasterToRemainingNode(Level world, List<BlockPos> alreadyChecked, IMasterRoutingNode master) {
        this.masterPos = master.getCurrentBlockPos();
        List<BlockPos> connectedList = this.getConnected();
        for (BlockPos testPos : connectedList) {
            IRoutingNode node;
            if (alreadyChecked.contains(testPos)) continue;
            alreadyChecked.add(testPos);
            BlockEntity tile = world.m_7702_(testPos);
            if (!(tile instanceof IRoutingNode) || !(node = (IRoutingNode)tile).getMasterPos().equals((Object)BlockPos.f_121853_)) continue;
            master.addNodeToList(node);
            node.connectMasterToRemainingNode(world, alreadyChecked, master);
        }
        master.addConnections(this.getCurrentBlockPos(), connectedList);
    }

    @Override
    public Triple<Boolean, List<BlockPos>, List<IRoutingNode>> recheckConnectionToMaster(List<BlockPos> alreadyChecked, List<IRoutingNode> nodeList) {
        if (this.masterPos.equals((Object)BlockPos.f_121853_)) {
            return Triple.of((Object)false, alreadyChecked, nodeList);
        }
        List<BlockPos> connectedList = this.getConnected();
        for (BlockPos testPos : connectedList) {
            if (alreadyChecked.contains(testPos)) continue;
            alreadyChecked.add(testPos);
            BlockEntity tile = this.f_58857_.m_7702_(testPos);
            if (!(tile instanceof IRoutingNode)) continue;
            IRoutingNode node = (IRoutingNode)tile;
            if (node instanceof IMasterRoutingNode) {
                return Triple.of((Object)true, alreadyChecked, nodeList);
            }
            Triple<Boolean, List<BlockPos>, List<IRoutingNode>> checkResult = node.recheckConnectionToMaster(alreadyChecked, nodeList);
            if (!((Boolean)checkResult.getLeft()).booleanValue()) continue;
            return checkResult;
        }
        nodeList.add(this);
        return Triple.of((Object)false, alreadyChecked, nodeList);
    }

    @Override
    public List<BlockPos> checkAndPurgeConnectionToMaster(BlockPos ignorePos) {
        LinkedList<BlockPos> posList = new LinkedList<BlockPos>();
        posList.add(ignorePos);
        Triple<Boolean, List<BlockPos>, List<IRoutingNode>> recheckResult = this.recheckConnectionToMaster(posList, new LinkedList<IRoutingNode>());
        if (!((Boolean)recheckResult.getLeft()).booleanValue()) {
            BlockEntity testTile = this.f_58857_.m_7702_(this.masterPos);
            IMasterRoutingNode masterNode = null;
            if (testTile instanceof IMasterRoutingNode) {
                masterNode = (IMasterRoutingNode)testTile;
                masterNode.removeConnection(this.getCurrentBlockPos());
            }
            for (IRoutingNode node : (List)recheckResult.getRight()) {
                BlockPos masterPos = node.getMasterPos();
                node.removeConnection(masterPos);
                if (masterNode == null) continue;
                masterNode.removeConnection(node.getCurrentBlockPos());
            }
            return (List)recheckResult.getMiddle();
        }
        return (List)recheckResult.getMiddle();
    }

    @Override
    public BlockPos getCurrentBlockPos() {
        return this.m_58899_();
    }

    @Override
    public List<BlockPos> getConnected() {
        return this.connectionList;
    }

    @Override
    public BlockPos getMasterPos() {
        return this.masterPos;
    }

    @Override
    public boolean isMaster(IMasterRoutingNode master) {
        BlockPos checkPos = master.getCurrentBlockPos();
        return checkPos.equals((Object)this.getMasterPos());
    }

    @Override
    public boolean isConnectionEnabled(BlockPos testPos) {
        return this.currentInput <= 0;
    }

    @Override
    public void addConnection(BlockPos pos1) {
        if (!this.connectionList.contains(pos1)) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58904_().m_8055_(this.m_58899_()), this.m_58904_().m_8055_(this.m_58899_()), 3);
            this.connectionList.add(pos1);
        }
    }

    @Override
    public void removeConnection(BlockPos pos1) {
        if (this.connectionList.contains(pos1)) {
            this.connectionList.remove(pos1);
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58904_().m_8055_(this.m_58899_()), this.m_58904_().m_8055_(this.m_58899_()), 3);
        }
        if (pos1.equals((Object)this.masterPos)) {
            this.masterPos = BlockPos.f_121853_;
        }
    }

    @Override
    public boolean isInventoryConnectedToSide(Direction side) {
        return false;
    }

    @Override
    public int getPriority(Direction side) {
        return 0;
    }

    public AABB getRenderBoundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = super.getRenderBoundingBox().m_82400_(5.0);
        }
        return this.boundingBox;
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }
}

