/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.patchouli.processors;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.RecipeAlchemyArray;

public class AlchemyArrayProcessor
implements IComponentProcessor {
    private RecipeAlchemyArray recipe;

    public void setup(IVariableProvider variables) {
        Recipe recipe;
        ResourceLocation id = new ResourceLocation(variables.get("recipe").asString());
        Optional recipeHandler = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(id);
        if (recipeHandler.isPresent() && (recipe = (Recipe)Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(id).get()).m_6671_().equals(BloodMagicRecipeType.ARRAY.get())) {
            this.recipe = (RecipeAlchemyArray)recipe;
        }
        if (this.recipe == null) {
            LogManager.getLogger().warn("Guidebook missing Alchemy Array recipe {}", (Object)id);
        }
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        switch (key) {
            case "baseinput": {
                return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.getBaseInput().m_43908_()).map(IVariable::from).collect(Collectors.toList()));
            }
            case "addedinput": {
                return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.getAddedInput().m_43908_()).map(IVariable::from).collect(Collectors.toList()));
            }
            case "output": {
                return IVariable.from((Object)this.recipe.getOutput());
            }
        }
        return null;
    }
}

