/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import wayoftime.bloodmagic.common.item.routing.IItemFilterProvider;

public class FilterButtonPacket {
    private int slot;
    private int ghostSlot;
    private String buttonKey;
    private int currentButtonState;

    public FilterButtonPacket() {
    }

    public FilterButtonPacket(int slot, int ghostSlot, String buttonKey, int currentButtonState) {
        this.slot = slot;
        this.ghostSlot = ghostSlot;
        this.buttonKey = buttonKey;
        this.currentButtonState = currentButtonState;
    }

    public static void encode(FilterButtonPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.slot);
        buf.writeInt(pkt.ghostSlot);
        buf.m_130070_(pkt.buttonKey);
        buf.writeInt(pkt.currentButtonState);
    }

    public static FilterButtonPacket decode(FriendlyByteBuf buf) {
        FilterButtonPacket pkt = new FilterButtonPacket(buf.readInt(), buf.readInt(), buf.m_130136_(Short.MAX_VALUE), buf.readInt());
        return pkt;
    }

    public static void handle(FilterButtonPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> FilterButtonPacket.sendKeyToServer(message, (Player)((NetworkEvent.Context)context.get()).getSender()));
        context.get().setPacketHandled(true);
    }

    public static void sendKeyToServer(FilterButtonPacket msg, Player playerEntity) {
        ItemStack itemStack = ItemStack.f_41583_;
        if (msg.slot > -1 && msg.slot < 9) {
            itemStack = playerEntity.m_150109_().m_8020_(msg.slot);
        }
        if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof IItemFilterProvider) {
            ((IItemFilterProvider)itemStack.m_41720_()).receiveButtonPress(itemStack, msg.buttonKey, msg.ghostSlot, msg.currentButtonState);
        }
    }
}

