/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import wayoftime.bloodmagic.common.tile.routing.TileFilteredRoutingNode;

public class ItemRoutingNodeButtonPacket {
    private BlockPos pos;
    private int buttonPress;

    public ItemRoutingNodeButtonPacket() {
        this(BlockPos.f_121853_, 0);
    }

    public ItemRoutingNodeButtonPacket(BlockPos pos, int buttonPress) {
        this.pos = pos;
        this.buttonPress = buttonPress;
    }

    public static void encode(ItemRoutingNodeButtonPacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.pos);
        buf.writeInt(pkt.buttonPress);
    }

    public static ItemRoutingNodeButtonPacket decode(FriendlyByteBuf buf) {
        ItemRoutingNodeButtonPacket pkt = new ItemRoutingNodeButtonPacket(buf.m_130135_(), buf.readInt());
        return pkt;
    }

    public static void handle(ItemRoutingNodeButtonPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null || player.f_19853_.f_46443_) {
                return;
            }
            BlockEntity tile = player.m_20193_().m_7702_(message.pos);
            if (tile instanceof TileFilteredRoutingNode) {
                int buttonPress = message.buttonPress;
                if (buttonPress >= 6) {
                    if (buttonPress == 6) {
                        ((TileFilteredRoutingNode)tile).incrementCurrentPriotiryToMaximum(9);
                    } else if (buttonPress == 7) {
                        ((TileFilteredRoutingNode)tile).decrementCurrentPriority();
                    }
                } else {
                    ((TileFilteredRoutingNode)tile).swapFilters(buttonPress);
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

