/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.will.DemonWillHolder;

@RitualRegister(value="grounding")
public class RitualGrounding
extends Ritual {
    public static final int willRefreshTime = 20;
    public static final String GROUNDING_RANGE = "groundingRange";
    public static final double willDrain = 0.1;

    public RitualGrounding() {
        super("ritualGrounding", 0, 5000, "ritual.bloodmagic.groundingRitual");
        this.addBlockRange(GROUNDING_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-10, 0, -10), 21, 30, 21));
        this.setMaximumVolumeAndDistanceOfRange(GROUNDING_RANGE, 0, 200, 200);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(world, pos);
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        double rawDrained = 0.0;
        double corrosiveDrained = 0.0;
        double destructiveDrained = 0.0;
        double steadfastDrained = 0.0;
        double vengefulDrained = 0.0;
        AreaDescriptor groundingRange = masterRitualStone.getBlockRange(GROUNDING_RANGE);
        List entities = world.m_45976_(LivingEntity.class, groundingRange.getAABB(pos));
        for (LivingEntity entity : entities) {
            double[] drainagePlayer;
            if (totalEffects >= maxEffects) break;
            if (entity instanceof Player && ((Player)entity).m_7500_()) continue;
            ++totalEffects;
            if (entity instanceof Player) {
                if (world.m_46467_() % 10L != 0L || !(rawWill >= 0.1)) continue;
                rawDrained += 0.1;
                drainagePlayer = this.sharedWillEffects(world, entity, corrosiveWill, destructiveWill, vengefulWill, corrosiveDrained, destructiveDrained, vengefulDrained);
                corrosiveDrained += drainagePlayer[0];
                destructiveDrained += drainagePlayer[1];
                vengefulDrained += drainagePlayer[2];
                continue;
            }
            if (entity.m_6072_()) {
                if (world.m_46467_() % 10L != 0L) continue;
                double[] drainageEntity = this.sharedWillEffects(world, entity, corrosiveWill, destructiveWill, vengefulWill, corrosiveDrained, destructiveDrained, vengefulDrained);
                corrosiveDrained += drainageEntity[0];
                destructiveDrained += drainageEntity[1];
                vengefulDrained += drainageEntity[2];
                continue;
            }
            if (entity.m_6072_() || !(steadfastWill >= 0.1)) continue;
            if (entity instanceof WitherBoss || entity instanceof EnderDragon) {
                entity.m_6478_(MoverType.SELF, new Vec3(0.0, -0.05, 0.0));
            }
            steadfastDrained += 0.01;
            drainagePlayer = this.sharedWillEffects(world, entity, corrosiveWill, destructiveWill, vengefulWill, corrosiveDrained, destructiveDrained, vengefulDrained);
            corrosiveDrained += drainagePlayer[0];
            destructiveDrained += drainagePlayer[1];
            vengefulDrained += drainagePlayer[2];
        }
        if (rawDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawDrained, true);
        }
        if (corrosiveDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, corrosiveDrained, true);
        }
        if (destructiveDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DESTRUCTIVE, destructiveDrained, true);
        }
        if (steadfastDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastDrained, true);
        }
        if (vengefulDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.VENGEFUL, vengefulDrained, true);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return Math.max(1, this.getBlockRange(GROUNDING_RANGE).getVolume() / 10000);
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 2, EnumRuneType.EARTH);
        this.addCornerRunes(components, 3, 3, EnumRuneType.EARTH);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualGrounding();
    }

    public double[] sharedWillEffects(Level world, LivingEntity entity, double corrosiveWill, double destructiveWill, double vengefulWill, double corrosiveDrained, double destructiveDrained, double vengefulDrained) {
        if (corrosiveWill >= 0.1) {
            entity.m_7292_(new MobEffectInstance(BloodMagicPotions.SUSPENDED, 20, 0));
            corrosiveDrained += 0.1;
        } else if (vengefulWill >= 0.1) {
            vengefulDrained += 0.1;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 20, 10));
        } else {
            entity.m_7292_(new MobEffectInstance(BloodMagicPotions.GROUNDED, 20, 0));
            entity.m_7292_(new MobEffectInstance(BloodMagicPotions.GRAVITY, 20, 0));
        }
        if (destructiveWill >= 0.1) {
            destructiveDrained += 0.1;
            entity.m_7292_(new MobEffectInstance(BloodMagicPotions.HEAVY_HEART, 100, 1));
        }
        return new double[]{corrosiveDrained, destructiveDrained, vengefulDrained};
    }

    @Override
    public Component[] provideInformationOfRitualToPlayer(Player player) {
        return new Component[]{new TranslatableComponent(this.getTranslationKey() + ".info"), new TranslatableComponent(this.getTranslationKey() + ".default.info"), new TranslatableComponent(this.getTranslationKey() + ".corrosive.info"), new TranslatableComponent(this.getTranslationKey() + ".steadfast.info"), new TranslatableComponent(this.getTranslationKey() + ".destructive.info"), new TranslatableComponent(this.getTranslationKey() + ".vengeful.info")};
    }
}

