/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;

public final class ColorHelper {
    public static final Function<DyeColor, Block> STAINED_GLASS_MAP = color -> (Block)Registry.f_122824_.m_6612_(new ResourceLocation(color.m_7912_() + "_stained_glass")).get();
    public static final Function<DyeColor, Block> STAINED_GLASS_PANE_MAP = color -> (Block)Registry.f_122824_.m_6612_(new ResourceLocation(color.m_7912_() + "_stained_glass_pane")).get();
    public static final Function<DyeColor, Block> TERRACOTTA_MAP = color -> (Block)Registry.f_122824_.m_6612_(new ResourceLocation(color.m_7912_() + "_terracotta")).get();
    public static final Function<DyeColor, Block> GLAZED_TERRACOTTA_MAP = color -> (Block)Registry.f_122824_.m_6612_(new ResourceLocation(color.m_7912_() + "_glazed_terracotta")).get();
    public static final Function<DyeColor, Block> WOOL_MAP = color -> (Block)Registry.f_122824_.m_6612_(new ResourceLocation(color.m_7912_() + "_wool")).get();
    public static final Function<DyeColor, Block> CARPET_MAP = color -> (Block)Registry.f_122824_.m_6612_(new ResourceLocation(color.m_7912_() + "_carpet")).get();
    public static final Function<DyeColor, Block> CONCRETE_MAP = color -> (Block)Registry.f_122824_.m_6612_(new ResourceLocation(color.m_7912_() + "_concrete")).get();
    public static final Function<DyeColor, Block> CONCRETE_POWDER_MAP = color -> (Block)Registry.f_122824_.m_6612_(new ResourceLocation(color.m_7912_() + "_concrete_powder")).get();

    @Nullable
    public static DyeColor getWoolColor(Block b) {
        ResourceLocation name = Registry.f_122824_.m_7981_((Object)b);
        if ("minecraft".equals(name.m_135827_()) && name.m_135815_().endsWith("_wool")) {
            String color = name.m_135815_().substring(0, name.m_135815_().length() - "_wool".length());
            return DyeColor.valueOf((String)color.toUpperCase(Locale.ROOT));
        }
        return null;
    }

    public static boolean isWool(Block b) {
        return ColorHelper.getWoolColor(b) != null;
    }

    public static int getColorValue(DyeColor color) {
        float[] colors = color.m_41068_();
        int r = (int)(colors[0] * 255.0f);
        int g = (int)(colors[1] * 255.0f);
        int b = (int)(colors[2] * 255.0f);
        return r << 16 | g << 8 | b;
    }

    private ColorHelper() {
    }
}

