/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.loot;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AdditionalTableModifier
extends LootModifier {
    private String tableID;
    private final LootTableReference reference;
    private final float chanceToRefer;

    protected AdditionalTableModifier(LootItemCondition[] conditionsIn, LootTableReference reference, String tableID, float chanceToRefer) {
        super(conditionsIn);
        this.chanceToRefer = chanceToRefer;
        this.tableID = tableID;
        this.reference = reference;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (context.m_78933_().nextFloat() <= this.chanceToRefer) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            this.reference.m_6948_(items::add, context);
            return items;
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AdditionalTableModifier> {
        public AdditionalTableModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            String tableID = GsonHelper.m_13906_((JsonObject)object, (String)"tableRef");
            LootTableReference reference = (LootTableReference)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation(tableID)).m_7512_();
            float referChance = GsonHelper.m_13915_((JsonObject)object, (String)"referChance");
            return new AdditionalTableModifier(ailootcondition, reference, tableID, referChance);
        }

        public JsonObject write(AdditionalTableModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.addProperty("tableRef", instance.tableID);
            object.addProperty("referChance", (Number)Float.valueOf(instance.chanceToRefer));
            return object;
        }
    }
}

