/*
 * Decompiled with CFR 0.152.
 */
package cn.leomc.curiosquarkobp;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import vazkii.quark.addons.oddities.item.BackpackItem;
import vazkii.quark.base.client.handler.ModelHandler;

public class BackpackCurioRenderer
implements ICurioRenderer {
    private final HumanoidModel model = ModelHandler.armorModel((ModelLayerLocation)ModelHandler.backpack, (EquipmentSlot)EquipmentSlot.CHEST);

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Item item = stack.m_41720_();
        if (item instanceof BackpackItem) {
            BackpackItem backpack = (BackpackItem)item;
            EntityModel entityModel = renderLayerParent.m_7200_();
            if (entityModel instanceof HumanoidModel) {
                HumanoidModel humanoidModel = (HumanoidModel)entityModel;
                humanoidModel.m_102872_(this.model);
            } else {
                entityModel.m_102624_((EntityModel)this.model);
            }
            boolean hasFoil = stack.m_41790_();
            int i = backpack.m_41121_(stack);
            float r = (float)(i >> 16 & 0xFF) / 255.0f;
            float g = (float)(i >> 8 & 0xFF) / 255.0f;
            float b = (float)(i & 0xFF) / 255.0f;
            this.render(poseStack, multiBufferSource, light, hasFoil, (Model)this.model, r, g, b, this.getArmorResource(stack, null));
            this.render(poseStack, multiBufferSource, light, hasFoil, (Model)this.model, 1.0f, 1.0f, 1.0f, this.getArmorResource(stack, "overlay"));
        }
    }

    private void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, boolean glint, Model backpackModel, float r, float g, float b, ResourceLocation armorResource) {
        VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)glint);
        backpackModel.m_7695_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
    }

    private ResourceLocation getArmorResource(ItemStack backpack, String type) {
        return new ResourceLocation(backpack.m_41720_().getArmorTexture(backpack, (Entity)Minecraft.m_91087_().f_91074_, EquipmentSlot.CHEST, type));
    }
}

