/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.blocks;

import com.fizzware.dramaticdoors.DDTags;
import com.fizzware.dramaticdoors.blocks.DDBlocks;
import com.fizzware.dramaticdoors.compat.Compats;
import com.fizzware.dramaticdoors.compat.QuarkCompat;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShortDoorBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public ShortDoorBlock(Block from) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)from));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.FALSE)).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return !this.m_7898_(stateIn, (LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
    }

    protected int getCloseSound() {
        return this.f_60442_ == Material.f_76279_ ? 1011 : 1012;
    }

    protected int getOpenSound() {
        return this.f_60442_ == Material.f_76279_ ? 1005 : 1006;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        if (blockpos.m_123342_() < context.m_43725_().m_151558_() && context.m_43725_().m_8055_(blockpos).m_60629_(context)) {
            Level level = context.m_43725_();
            boolean flag = level.m_46753_(blockpos) || level.m_46753_(blockpos.m_7494_());
            boolean waterfilled = level.m_6425_(blockpos).m_76152_() == Fluids.f_76193_;
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HINGE, (Comparable)this.getHinge(context))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled));
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }

    protected DoorHingeSide getHinge(BlockPlaceContext context) {
        boolean rightIsLowerOfSameType;
        Level BlockGetter2 = context.m_43725_();
        BlockPos placePos = context.m_8083_();
        Direction behindDir = context.m_8125_();
        Direction leftDir = behindDir.m_122428_();
        BlockPos leftPos = placePos.m_142300_(leftDir);
        BlockState leftBlockstate = BlockGetter2.m_8055_(leftPos);
        Direction rightDir = behindDir.m_122427_();
        BlockPos rightPos = placePos.m_142300_(rightDir);
        BlockState rightBlockstate = BlockGetter2.m_8055_(rightPos);
        int i = (leftBlockstate.m_60838_((BlockGetter)BlockGetter2, leftPos) ? -1 : 0) + (rightBlockstate.m_60838_((BlockGetter)BlockGetter2, rightPos) ? 1 : 0);
        boolean leftIsLowerOfSameType = leftBlockstate.m_60734_() == this;
        boolean bl = rightIsLowerOfSameType = rightBlockstate.m_60734_() == this;
        if ((!leftIsLowerOfSameType || rightIsLowerOfSameType) && i <= 0) {
            if ((!rightIsLowerOfSameType || leftIsLowerOfSameType) && i >= 0) {
                int j = behindDir.m_122429_();
                int k = behindDir.m_122431_();
                Vec3 vec3d = context.m_43720_();
                double d0 = vec3d.f_82479_ - (double)placePos.m_123341_();
                double d1 = vec3d.f_82481_ - (double)placePos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (this.f_60442_ == Material.f_76279_ && !state.m_204336_(DDTags.HAND_OPENABLE_SHORT_METAL_DOORS)) {
            return InteractionResult.PASS;
        }
        if (this == DDBlocks.SHORT_GOLD_DOOR.get() && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (this == DDBlocks.SHORT_SILVER_DOOR.get() && !((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        ShortDoorBlock.tryOpenDoubleDoor(level, state, pos);
        state = (BlockState)state.m_61122_((Property)OPEN);
        level.m_7731_(pos, state, 10);
        level.m_5898_(player, (Boolean)state.m_61143_((Property)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        level.m_142346_((Entity)player, (Boolean)state.m_61143_((Property)OPEN) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (DDBlocks.SHORT_TOOTH_DOOR != null && this == DDBlocks.SHORT_TOOTH_DOOR.get()) {
            level.m_186460_(pos, (Block)this, 20);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (this != DDBlocks.SHORT_TOOTH_DOOR.get()) {
            return;
        }
        if (!level.f_46443_) {
            state = (BlockState)state.m_61122_((Property)OPEN);
            level.m_7731_(pos, state, 10);
            level.m_5898_(null, (Boolean)state.m_61143_((Property)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        }
    }

    public void toggleDoor(Level level, BlockPos pos, boolean open) {
        BlockState blockstate = level.m_8055_(pos);
        if (blockstate.m_60734_() == this && (Boolean)blockstate.m_61143_((Property)OPEN) != open) {
            level.m_7731_(pos, (BlockState)blockstate.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.playSound(level, pos, open);
        }
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public void setOpen(@Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean open) {
        if (state.m_60713_((Block)this) && (Boolean)state.m_61143_((Property)OPEN) != open) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.playSound(level, pos, open);
            level.m_142346_(entity, open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
            ShortDoorBlock.tryOpenDoubleDoor(level, state, pos);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag = level.m_46753_(pos);
        if (blockIn != this && flag != (Boolean)state.m_61143_((Property)POWERED)) {
            if (this == DDBlocks.SHORT_GOLD_DOOR.get() || this == DDBlocks.SHORT_SILVER_DOOR.get() || this == DDBlocks.SHORT_LEAD_DOOR.get()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
            } else {
                if (flag != (Boolean)state.m_61143_((Property)OPEN)) {
                    this.playSound(level, pos, flag);
                }
                ShortDoorBlock.tryOpenDoubleDoor(level, state, pos);
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
            }
            if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    protected void playSound(Level level, BlockPos pos, boolean isOpen) {
        level.m_5898_(null, isOpen ? this.getOpenSound() : this.getCloseSound(), pos, 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_123342_(), (int)pos.m_123343_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, HINGE, POWERED, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        boolean flag = (Boolean)state.m_61143_((Property)OPEN) == false;
        boolean flag1 = state.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public boolean allowsMovement(BlockState state, BlockGetter level, BlockPos pos, BlockPathTypes type) {
        switch (type) {
            case WALKABLE: {
                return (Boolean)state.m_61143_((Property)OPEN);
            }
            case WATER: {
                return false;
            }
            case OPEN: {
                return (Boolean)state.m_61143_((Property)OPEN);
            }
        }
        return false;
    }

    public PushReaction getPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    public static boolean isWoodenDoor(Level level, BlockPos pos) {
        return ShortDoorBlock.isWoodenDoor(level.m_8055_(pos));
    }

    public static boolean isWoodenDoor(BlockState state) {
        return state.m_60734_() instanceof ShortDoorBlock && state.m_204336_(DDTags.SHORT_WOODEN_DOORS);
    }

    public static void tryOpenDoubleDoor(Level world, BlockState state, BlockPos pos) {
        if (Compats.DOUBLE_DOORS_INSTALLED || Compats.MANYIDEAS_DOORS_INSTALLED || QuarkCompat.hasQuarkDoubleDoorsModule()) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            boolean isOpen = (Boolean)state.m_61143_((Property)OPEN);
            DoorHingeSide isMirrored = (DoorHingeSide)state.m_61143_(HINGE);
            BlockPos mirrorPos = pos.m_142300_(isMirrored == DoorHingeSide.RIGHT ? direction.m_122428_() : direction.m_122427_());
            BlockPos doorPos = mirrorPos;
            BlockState other = world.m_8055_(doorPos);
            if (other.m_60734_() == state.m_60734_() && other.m_61143_((Property)FACING) == direction && !((Boolean)other.m_61143_((Property)POWERED)).booleanValue() && (Boolean)other.m_61143_((Property)OPEN) == isOpen && other.m_61143_(HINGE) != isMirrored) {
                BlockState newState = (BlockState)other.m_61122_((Property)OPEN);
                world.m_7731_(doorPos, newState, 10);
            }
        }
    }
}

