/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.blocks;

import com.fizzware.dramaticdoors.blocks.DDBlocks;
import com.fizzware.dramaticdoors.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.state.properties.TripleBlockPart;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class TallCopperDoorBlock
extends TallDoorBlock
implements WeatheringCopper {
    private static Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)DDBlocks.TALL_EC_COPPER_DOOR.get()), (Object)((Block)DDBlocks.TALL_EC_EXPOSED_COPPER_DOOR.get())).put((Object)((Block)DDBlocks.TALL_EC_EXPOSED_COPPER_DOOR.get()), (Object)((Block)DDBlocks.TALL_EC_WEATHERED_COPPER_DOOR.get())).put((Object)((Block)DDBlocks.TALL_EC_WEATHERED_COPPER_DOOR.get()), (Object)((Block)DDBlocks.TALL_EC_OXIDIZED_COPPER_DOOR.get())).build());
    private static Supplier<BiMap<Block, Block>> PREVIOUS_BY_BLOCK = Suppliers.memoize(() -> NEXT_BY_BLOCK.get().inverse());
    private final WeatheringCopper.WeatherState weatherState;

    public TallCopperDoorBlock(Block from, WeatheringCopper.WeatherState state) {
        super(from);
        this.weatherState = state;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        int offset;
        ItemStack itemstack = player.m_21120_(handIn);
        Block block = state.m_60734_();
        int n = state.m_61143_((Property)THIRD) == TripleBlockPart.UPPER ? 2 : (offset = state.m_61143_((Property)THIRD) == TripleBlockPart.MIDDLE ? 1 : 0);
        if (itemstack != null && itemstack.m_41720_() == Items.f_42784_) {
            if (block == DDBlocks.TALL_EC_WAXED_COPPER_DOOR.get() || block == DDBlocks.TALL_EC_WAXED_EXPOSED_COPPER_DOOR.get() || block == DDBlocks.TALL_EC_WAXED_WEATHERED_COPPER_DOOR.get() || block == DDBlocks.TALL_EC_WAXED_OXIDIZED_COPPER_DOOR.get()) {
                return InteractionResult.PASS;
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, itemstack);
            }
            if (player != null && !player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.applyWaxOnCopperDoor(state, level, pos.m_6625_(offset));
            level.m_5898_(player, 3003, pos, 0);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (itemstack != null && itemstack.m_41720_() instanceof AxeItem) {
            if (block == DDBlocks.TALL_EC_WAXED_COPPER_DOOR.get() || block == DDBlocks.TALL_EC_WAXED_EXPOSED_COPPER_DOOR.get() || block == DDBlocks.TALL_EC_WAXED_WEATHERED_COPPER_DOOR.get() || block == DDBlocks.TALL_EC_WAXED_OXIDIZED_COPPER_DOOR.get()) {
                level.m_5594_(player, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5898_(player, 3004, pos, 0);
                this.removeWaxFromCopperDoor(state, level, pos.m_6625_(offset));
            } else if (block == DDBlocks.TALL_EC_EXPOSED_COPPER_DOOR.get() || block == DDBlocks.TALL_EC_WEATHERED_COPPER_DOOR.get() || block == DDBlocks.TALL_EC_OXIDIZED_COPPER_DOOR.get()) {
                level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5898_(player, 3005, pos, 0);
                this.deoxidizeCopperDoor(state, level, pos.m_6625_(offset));
            } else if (block == DDBlocks.TALL_EC_COPPER_DOOR.get()) {
                return InteractionResult.PASS;
            }
            if (player != null && !player.m_7500_()) {
                itemstack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(handIn));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private void applyWaxOnCopperDoor(BlockState state, Level level, BlockPos pos) {
        boolean waterfilled2;
        BlockState newState = state;
        boolean waterfilled0 = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        boolean waterfilled1 = level.m_6425_(pos.m_6630_(1)).m_76152_() == Fluids.f_76193_;
        boolean bl = waterfilled2 = level.m_6425_(pos.m_6630_(2)).m_76152_() == Fluids.f_76193_;
        if (state.m_60734_() == DDBlocks.TALL_EC_COPPER_DOOR.get()) {
            newState = this.copyProperties((Block)DDBlocks.TALL_EC_WAXED_COPPER_DOOR.get(), state);
        } else if (state.m_60734_() == DDBlocks.TALL_EC_EXPOSED_COPPER_DOOR.get()) {
            newState = this.copyProperties((Block)DDBlocks.TALL_EC_WAXED_EXPOSED_COPPER_DOOR.get(), state);
        } else if (state.m_60734_() == DDBlocks.TALL_EC_WEATHERED_COPPER_DOOR.get()) {
            newState = this.copyProperties((Block)DDBlocks.TALL_EC_WAXED_WEATHERED_COPPER_DOOR.get(), state);
        } else if (state.m_60734_() == DDBlocks.TALL_EC_OXIDIZED_COPPER_DOOR.get()) {
            newState = this.copyProperties((Block)DDBlocks.TALL_EC_WAXED_OXIDIZED_COPPER_DOOR.get(), state);
        }
        level.m_7471_(pos, false);
        level.m_7471_(pos.m_6630_(1), false);
        level.m_7471_(pos.m_6630_(2), false);
        level.m_7731_(pos, (BlockState)((BlockState)newState.m_61124_((Property)THIRD, (Comparable)((Object)TripleBlockPart.LOWER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled0)), 35);
        level.m_7731_(pos.m_6630_(1), (BlockState)((BlockState)newState.m_61124_((Property)THIRD, (Comparable)((Object)TripleBlockPart.MIDDLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled1)), 35);
        level.m_7731_(pos.m_6630_(2), (BlockState)((BlockState)newState.m_61124_((Property)THIRD, (Comparable)((Object)TripleBlockPart.UPPER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled2)), 35);
    }

    private void removeWaxFromCopperDoor(BlockState state, Level level, BlockPos pos) {
        boolean waterfilled2;
        BlockState newState = state;
        boolean waterfilled0 = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        boolean waterfilled1 = level.m_6425_(pos.m_6630_(1)).m_76152_() == Fluids.f_76193_;
        boolean bl = waterfilled2 = level.m_6425_(pos.m_6630_(2)).m_76152_() == Fluids.f_76193_;
        if (state.m_60734_() == DDBlocks.TALL_EC_WAXED_COPPER_DOOR.get()) {
            newState = this.copyProperties((Block)DDBlocks.TALL_EC_COPPER_DOOR.get(), state);
        } else if (state.m_60734_() == DDBlocks.TALL_EC_WAXED_EXPOSED_COPPER_DOOR.get()) {
            newState = this.copyProperties((Block)DDBlocks.TALL_EC_EXPOSED_COPPER_DOOR.get(), state);
        } else if (state.m_60734_() == DDBlocks.TALL_EC_WAXED_WEATHERED_COPPER_DOOR.get()) {
            newState = this.copyProperties((Block)DDBlocks.TALL_EC_WEATHERED_COPPER_DOOR.get(), state);
        } else if (state.m_60734_() == DDBlocks.TALL_EC_WAXED_OXIDIZED_COPPER_DOOR.get()) {
            newState = this.copyProperties((Block)DDBlocks.TALL_EC_OXIDIZED_COPPER_DOOR.get(), state);
        }
        level.m_7471_(pos, false);
        level.m_7471_(pos.m_6630_(1), false);
        level.m_7471_(pos.m_6630_(2), false);
        level.m_7731_(pos, (BlockState)((BlockState)newState.m_61124_((Property)THIRD, (Comparable)((Object)TripleBlockPart.LOWER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled0)), 35);
        level.m_7731_(pos.m_6630_(1), (BlockState)((BlockState)newState.m_61124_((Property)THIRD, (Comparable)((Object)TripleBlockPart.MIDDLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled1)), 35);
        level.m_7731_(pos.m_6630_(2), (BlockState)((BlockState)newState.m_61124_((Property)THIRD, (Comparable)((Object)TripleBlockPart.UPPER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled2)), 35);
    }

    private void deoxidizeCopperDoor(BlockState state, Level level, BlockPos pos) {
        boolean waterfilled0 = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        boolean waterfilled1 = level.m_6425_(pos.m_6630_(1)).m_76152_() == Fluids.f_76193_;
        boolean waterfilled2 = level.m_6425_(pos.m_6630_(2)).m_76152_() == Fluids.f_76193_;
        TallCopperDoorBlock.getPrevious(state).ifPresent(newState -> {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            level.m_7731_(pos, (BlockState)((BlockState)newState.m_61124_((Property)THIRD, (Comparable)((Object)TripleBlockPart.LOWER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled0)), 2);
            level.m_7731_(pos.m_6630_(1), (BlockState)((BlockState)newState.m_61124_((Property)THIRD, (Comparable)((Object)TripleBlockPart.MIDDLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled1)), 11);
            level.m_7731_(pos.m_6630_(2), (BlockState)((BlockState)newState.m_61124_((Property)THIRD, (Comparable)((Object)TripleBlockPart.UPPER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled2)), 11);
        });
    }

    private BlockState copyProperties(Block newBlock, BlockState state) {
        BlockState newBlockState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)THIRD, (Comparable)((Object)((TripleBlockPart)((Object)state.m_61143_((Property)THIRD)))))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)HINGE, (Comparable)((DoorHingeSide)state.m_61143_((Property)HINGE)))).m_61124_((Property)POWERED, (Comparable)((Boolean)state.m_61143_((Property)POWERED)))).m_61124_((Property)OPEN, (Comparable)((Boolean)state.m_61143_((Property)OPEN)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
        return newBlockState;
    }

    static Optional<Block> getPrevious(Block p_154891_) {
        return Optional.ofNullable((Block)PREVIOUS_BY_BLOCK.get().get((Object)p_154891_));
    }

    public static Optional<BlockState> getPrevious(BlockState p_154900_) {
        return TallCopperDoorBlock.getPrevious(p_154900_.m_60734_()).map(p_154903_ -> p_154903_.m_152465_(p_154900_));
    }

    public static BlockState getFirst(BlockState p_154907_) {
        return TallCopperDoorBlock.getFirst(p_154907_.m_60734_()).m_152465_(p_154907_);
    }

    static Block getFirst(Block p_154898_) {
        Block block = p_154898_;
        Block block1 = (Block)PREVIOUS_BY_BLOCK.get().get((Object)p_154898_);
        while (block1 != null) {
            block = block1;
            block1 = (Block)PREVIOUS_BY_BLOCK.get().get((Object)block1);
        }
        return block;
    }

    public Optional<BlockState> m_142123_(BlockState state) {
        return TallCopperDoorBlock.getNext(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<Block> getNext(Block state) {
        return Optional.ofNullable((Block)NEXT_BY_BLOCK.get().get((Object)state));
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        this.m_153041_(state, level, pos, random);
        float f = 0.05688889f;
        if (random.nextFloat() < f) {
            this.m_153046_(state, level, pos, random);
        }
    }

    public boolean m_6724_(BlockState state) {
        return TallCopperDoorBlock.getNext(state.m_60734_()).isPresent();
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }

    public void m_153046_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockPos blockpos;
        int l;
        int i = this.getAge().ordinal();
        int j = 0;
        int k = 0;
        Iterator iterator = BlockPos.m_121925_((BlockPos)pos, (int)4, (int)4, (int)4).iterator();
        while (iterator.hasNext() && (l = (blockpos = (BlockPos)iterator.next()).m_123333_((Vec3i)pos)) <= 4) {
            BlockState blockstate;
            Block block;
            if (blockpos.equals((Object)pos) || !((block = (blockstate = level.m_8055_(blockpos)).m_60734_()) instanceof ChangeOverTimeBlock)) continue;
            Enum oenum = ((ChangeOverTimeBlock)block).m_142297_();
            if (this.getAge().getClass() != oenum.getClass()) continue;
            int i1 = oenum.ordinal();
            if (i1 < i) {
                return;
            }
            if (i1 > i) {
                ++k;
                continue;
            }
            ++j;
        }
        float f = (float)(k + 1) / (float)(k + j + 1);
        float f1 = f * f * this.m_142377_();
        if (random.nextFloat() < f1) {
            this.m_142123_(state).ifPresent(newState -> {
                BlockPos replacedPosition = pos;
                if (((TripleBlockPart)((Object)((Object)state.m_61143_((Property)THIRD)))).equals((Object)TripleBlockPart.UPPER)) {
                    replacedPosition = replacedPosition.m_6625_(2);
                } else if (((TripleBlockPart)((Object)((Object)state.m_61143_((Property)THIRD)))).equals((Object)TripleBlockPart.MIDDLE)) {
                    replacedPosition = replacedPosition.m_6625_(1);
                }
                boolean waterfilled0 = level.m_6425_(replacedPosition).m_76152_() == Fluids.f_76193_;
                boolean waterfilled1 = level.m_6425_(replacedPosition.m_6630_(1)).m_76152_() == Fluids.f_76193_;
                boolean waterfilled2 = level.m_6425_(replacedPosition.m_6630_(2)).m_76152_() == Fluids.f_76193_;
                level.m_7731_(replacedPosition, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(replacedPosition, (BlockState)((BlockState)newState.m_61124_((Property)THIRD, (Comparable)((Object)TripleBlockPart.LOWER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled0)), 2);
                level.m_7731_(replacedPosition.m_6630_(1), (BlockState)((BlockState)newState.m_61124_((Property)THIRD, (Comparable)((Object)TripleBlockPart.MIDDLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled1)), 11);
                level.m_7731_(replacedPosition.m_6630_(2), (BlockState)((BlockState)newState.m_61124_((Property)THIRD, (Comparable)((Object)TripleBlockPart.UPPER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled2)), 11);
            });
        }
    }
}

