/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.datagen;

import com.fizzware.dramaticdoors.blocks.DDBlocks;
import com.fizzware.dramaticdoors.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.state.properties.TripleBlockPart;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class DDBlockStateProvider
extends BlockStateProvider {
    public DDBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "dramaticdoors", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.tallDoorBlock((Block)DDBlocks.TALL_AGATHOXYLON_DOOR.get(), "block/tall_agathoxylon");
        this.tallDoorBlock((Block)DDBlocks.TALL_BRACHYPHYLLUM_DOOR.get(), "block/tall_brachyphyllum");
        this.tallDoorBlock((Block)DDBlocks.TALL_GINKGO_DOOR.get(), "block/tall_ginkgo");
        this.tallDoorBlock((Block)DDBlocks.TALL_NEOCALAMITES_DOOR.get(), "block/tall_neocalamites");
        this.tallDoorBlock((Block)DDBlocks.TALL_SCHILDERIA_DOOR.get(), "block/tall_schilderia");
        this.tallDoorBlock((Block)DDBlocks.TALL_TROCHODENDROIDES_DOOR.get(), "block/tall_trochodendroides");
        this.tallDoorBlock((Block)DDBlocks.TALL_WOODWORTHIA_DOOR.get(), "block/tall_woodworthia");
        for (Block blockToGen : ForgeRegistries.BLOCKS.getEntries().stream().map(Map.Entry::getValue).toList()) {
            if (!(blockToGen instanceof ShortDoorBlock) || blockToGen.getRegistryName().m_135815_().equalsIgnoreCase("short_ec_waxed_copper_door") || blockToGen.getRegistryName().m_135815_().equalsIgnoreCase("short_ec_waxed_exposed_copper_door") || blockToGen.getRegistryName().m_135815_().equalsIgnoreCase("short_ec_waxed_weathered_copper_door") || blockToGen.getRegistryName().m_135815_().equalsIgnoreCase("short_ec_waxed_oxidized_copper_door") || blockToGen.getRegistryName().m_135815_().contains("pokecube")) continue;
            this.shortDoorBlock(blockToGen, "block/" + blockToGen.getRegistryName().m_135815_());
        }
    }

    private void tallDoorBlock(Block block, String baseName) {
        this.internalTallDoorBlock((TallDoorBlock)block, baseName, new ResourceLocation("dramaticdoors", baseName + "_door_bottom"), new ResourceLocation("dramaticdoors", baseName + "_door_middle"), new ResourceLocation("dramaticdoors", baseName + "_door_top"));
    }

    private void shortDoorBlock(Block block, String baseName) {
        this.internalShortDoorBlock((ShortDoorBlock)block, baseName, new ResourceLocation("dramaticdoors", baseName));
    }

    private void internalTallDoorBlock(TallDoorBlock block, String baseName, ResourceLocation bottom, ResourceLocation middle, ResourceLocation top) {
        ModelBuilder bottomMdl = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom", "block/door_bottom")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder bottomHinge = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom_hinge", "block/door_bottom_rh")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder middleMdl = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle", "dramaticdoors:block/door_middle")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder middleHinge = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle_hinge", "dramaticdoors:block/door_middle_rh")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder doorTop = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top", "block/door_top")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder doorTopHinge = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top_hinge", "block/door_top_rh")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        this.tallDoorBlock(block, (ModelFile)bottomMdl, (ModelFile)bottomHinge, (ModelFile)middleMdl, (ModelFile)middleHinge, (ModelFile)doorTop, (ModelFile)doorTopHinge);
    }

    public void tallDoorBlock(TallDoorBlock block, ModelFile bottomLeft, ModelFile bottomRight, ModelFile middleLeft, ModelFile middleRight, ModelFile topLeft, ModelFile topRight) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.m_61143_((Property)TallDoorBlock.FACING)).m_122435_() + 90;
            TripleBlockPart third = (TripleBlockPart)((Object)((Object)state.m_61143_(TallDoorBlock.THIRD)));
            boolean rh = state.m_61143_(TallDoorBlock.HINGE) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.m_61143_((Property)TallDoorBlock.OPEN);
            boolean right = rh ^ open;
            if (open) {
                yRot += 90;
            }
            if (rh && open) {
                yRot += 180;
            }
            return ConfiguredModel.builder().modelFile(third == TripleBlockPart.LOWER ? (right ? bottomRight : bottomLeft) : (third == TripleBlockPart.MIDDLE ? (right ? middleRight : middleLeft) : (right ? topRight : topLeft))).rotationY(yRot %= 360).build();
        }, new Property[]{TallDoorBlock.POWERED, TallDoorBlock.WATERLOGGED});
    }

    private void internalShortDoorBlock(ShortDoorBlock block, String baseName, ResourceLocation texture) {
        ModelBuilder shortMdl = ((BlockModelBuilder)this.models().withExistingParent(baseName, "dramaticdoors:block/door_short")).texture("texture", texture);
        ModelBuilder shortHinge = ((BlockModelBuilder)this.models().withExistingParent(baseName + "_hinge", "dramaticdoors:block/door_short_rh")).texture("texture", texture);
        this.shortDoorBlock(block, (ModelFile)shortMdl, (ModelFile)shortHinge);
    }

    public void shortDoorBlock(ShortDoorBlock block, ModelFile shortLeft, ModelFile shortRight) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.m_61143_((Property)TallDoorBlock.FACING)).m_122435_() + 90;
            boolean rh = state.m_61143_(TallDoorBlock.HINGE) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.m_61143_((Property)TallDoorBlock.OPEN);
            boolean right = rh ^ open;
            if (open) {
                yRot += 90;
            }
            if (rh && open) {
                yRot += 180;
            }
            return ConfiguredModel.builder().modelFile(right ? shortRight : shortLeft).rotationY(yRot %= 360).build();
        }, new Property[]{TallDoorBlock.POWERED, TallDoorBlock.WATERLOGGED});
    }
}

