/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import xiroc.dungeoncrawl.theme.Theme;

public class ThemeArgument
implements ArgumentType<Theme> {
    public static final DynamicCommandExceptionType THEME_NOT_FOUND = new DynamicCommandExceptionType(p_208663_0_ -> new TranslatableComponent("Unknown theme: {0}", new Object[]{p_208663_0_}));

    public static ThemeArgument theme() {
        return new ThemeArgument();
    }

    public static Theme getTheme(CommandContext<CommandSourceStack> context, String name) {
        return (Theme)context.getArgument(name, Theme.class);
    }

    public Theme parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation resourceLocation = ResourceLocation.m_135818_((StringReader)reader);
        if (Theme.KEY_TO_THEME.containsKey(resourceLocation)) {
            return Theme.KEY_TO_THEME.get(resourceLocation);
        }
        throw THEME_NOT_FOUND.create((Object)resourceLocation);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82926_(Theme.getThemeKeys(), (SuggestionsBuilder)builder);
    }
}

