/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure.function;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.dungeon.treasure.RandomItems;

public class RandomItem
extends LootItemConditionalFunction {
    public int lootLevel;

    public RandomItem(LootItemCondition[] conditionsIn, int lootLevel) {
        super(conditionsIn);
        this.lootLevel = Math.max(0, lootLevel);
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        if (context.m_78936_(LootContextParams.f_81460_)) {
            return RandomItems.generate(context.m_78933_(), this.lootLevel);
        }
        return ItemStack.f_41583_;
    }

    public static LootItemConditionalFunction.Builder<?> randomItem(int lootLevel) {
        return RandomItem.m_80683_(conditions -> new RandomItem((LootItemCondition[])conditions, lootLevel));
    }

    public LootItemFunctionType m_7162_() {
        return Loot.RANDOM_ITEM;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomItem> {
        public void serialize(JsonObject p_230424_1_, RandomItem p_230424_2_, JsonSerializationContext p_230424_3_) {
            super.m_6170_(p_230424_1_, (LootItemConditionalFunction)p_230424_2_, p_230424_3_);
            p_230424_1_.addProperty("loot_level", (Number)p_230424_2_.lootLevel);
        }

        public RandomItem deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            return new RandomItem(conditionsIn, object.get("loot_level").getAsInt());
        }
    }
}

