/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.mixin;

import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.LunarContext;
import corgitaco.enhancedcelestials.api.lunarevent.LunarMobSpawnInfo;
import corgitaco.enhancedcelestials.mixin.access.ChunkAccess;
import corgitaco.enhancedcelestials.mixin.access.MobSpawnInfoAccess;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NaturalSpawner.class})
public class MixinWorldEntitySpawner {
    @Inject(method={"mobsAt"}, at={@At(value="RETURN")}, cancellable=true)
    private static void useLunarSpawner(ServerLevel world, StructureFeatureManager $$1, ChunkGenerator $$2, MobCategory classification, BlockPos $$4, Holder<Biome> $$5, CallbackInfoReturnable<WeightedRandomList<MobSpawnSettings.SpawnerData>> cir) {
        LunarMobSpawnInfo lunarSpawner;
        LunarContext lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (lunarContext != null && (lunarSpawner = lunarContext.getCurrentEvent().getLunarSpawner()) != null) {
            MobSpawnSettings mobSpawnInfo = lunarSpawner.getSpawnInfo();
            if (lunarSpawner.useBiomeSpawnSettings()) {
                ArrayList unwrap = new ArrayList(mobSpawnInfo.m_151798_(classification).m_146338_());
                unwrap.addAll(((WeightedRandomList)cir.getReturnValue()).m_146338_());
                cir.setReturnValue((Object)WeightedRandomList.m_146328_(unwrap));
            } else {
                cir.setReturnValue((Object)mobSpawnInfo.m_151798_(classification));
            }
        }
    }

    @Inject(method={"getRoughBiome"}, at={@At(value="RETURN")}, cancellable=true)
    private static void useLunarSpawner(BlockPos pos, net.minecraft.world.level.chunk.ChunkAccess chunk, CallbackInfoReturnable<Biome> cir) {
        LunarMobSpawnInfo lunarSpawner;
        Level world;
        LunarContext lunarContext;
        if (chunk instanceof LevelChunk && (lunarContext = ((EnhancedCelestialsWorldData)(world = ((ChunkAccess)chunk).getLevel())).getLunarContext()) != null && (lunarSpawner = lunarContext.getCurrentEvent().getLunarSpawner()) != null) {
            MobSpawnSettings lunarMobSpawnInfo = lunarSpawner.getSpawnInfo();
            Biome.BiomeBuilder fakeBiome = new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47609_(0.5f).m_47611_(0.5f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(1).m_48027_(AmbientMoodSettings.f_47387_).m_48018_());
            if (lunarSpawner.useBiomeSpawnSettings()) {
                MobSpawnSettings biomeMobSpawnInfo = ((Biome)cir.getReturnValue()).m_47518_();
                EnumMap<MobCategory, List<MobSpawnSettings.SpawnerData>> mergedSpawnersMap = new EnumMap<MobCategory, List<MobSpawnSettings.SpawnerData>>(((MobSpawnInfoAccess)biomeMobSpawnInfo).getSpawners());
                mergedSpawnersMap.putAll(((MobSpawnInfoAccess)lunarMobSpawnInfo).getSpawners());
                IdentityHashMap mergedSpawnCosts = new IdentityHashMap(((MobSpawnInfoAccess)biomeMobSpawnInfo).getMobSpawnCosts());
                mergedSpawnCosts.putAll(((MobSpawnInfoAccess)lunarMobSpawnInfo).getMobSpawnCosts());
                MobSpawnSettings mobSpawnInfo = MobSpawnInfoAccess.create(Math.max(lunarMobSpawnInfo.m_48344_(), biomeMobSpawnInfo.m_48344_()), mergedSpawnersMap, mergedSpawnCosts);
                fakeBiome.m_47605_(mobSpawnInfo);
            } else {
                fakeBiome.m_47605_(lunarMobSpawnInfo);
            }
            fakeBiome.m_47601_(BiomeGenerationSettings.f_47777_);
            cir.setReturnValue((Object)fakeBiome.m_47592_());
        }
    }

    @Inject(method={"getRandomPosWithin"}, at={@At(value="RETURN")}, cancellable=true)
    private static void forceSurface(Level world, LevelChunk chunk, CallbackInfoReturnable<BlockPos> cir) {
        BlockPos closestPlayerPosition;
        BlockPos returnValue;
        Player closestPlayer;
        LunarMobSpawnInfo lunarSpawner;
        LunarContext lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (lunarContext != null && (lunarSpawner = lunarContext.getCurrentEvent().getLunarSpawner()) != null && lunarSpawner.isForceSurfaceSpawning() && (closestPlayer = world.m_45924_((double)(returnValue = (BlockPos)cir.getReturnValue()).m_123341_(), (double)returnValue.m_123342_(), (double)returnValue.m_123343_(), -1.0, false)) != null && (closestPlayerPosition = closestPlayer.m_142538_()).m_123342_() > world.m_6924_(Heightmap.Types.WORLD_SURFACE, closestPlayerPosition.m_123341_(), closestPlayerPosition.m_123343_())) {
            cir.setReturnValue((Object)new BlockPos(returnValue.m_123341_(), world.m_6924_(Heightmap.Types.WORLD_SURFACE, returnValue.m_123341_(), returnValue.m_123343_()) + 1, returnValue.m_123343_()));
        }
    }
}

