/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.InvertedJsonPredicate;
import slimeknights.mantle.util.JsonHelper;

public class NestedJsonPredicateLoader<I, T extends IJsonPredicate<I>>
implements GenericLoaderRegistry.IGenericLoader<T> {
    private final GenericLoaderRegistry<IJsonPredicate<I>> loader;
    private final InvertedJsonPredicate.Loader<I> inverter;
    private final BiFunction<NestedJsonPredicateLoader<I, T>, List<IJsonPredicate<I>>, T> constructor;
    private final Function<T, List<IJsonPredicate<I>>> getter;

    @SafeVarargs
    public final T create(IJsonPredicate<I> ... children) {
        if (children.length < 2) {
            throw new IllegalStateException("Too few children for nested predicate loader");
        }
        return (T)((IJsonPredicate)this.constructor.apply(this, (List<IJsonPredicate<I>>)ImmutableList.copyOf((Object[])children)));
    }

    InvertedJsonPredicate<I> invert(T instance) {
        return this.inverter.create((IJsonPredicate<I>)instance);
    }

    @Override
    public T deserialize(JsonObject json) {
        return (T)((IJsonPredicate)this.constructor.apply(this, JsonHelper.parseList(json, "predicates", (e, s) -> this.loader.deserialize((JsonElement)e))));
    }

    @Override
    public T fromNetwork(FriendlyByteBuf buffer) {
        int max = buffer.m_130242_();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < max; ++i) {
            builder.add(this.loader.fromNetwork(buffer));
        }
        return (T)((IJsonPredicate)this.constructor.apply(this, (List<IJsonPredicate<I>>)builder.build()));
    }

    @Override
    public void serialize(T object, JsonObject json) {
        JsonArray array = new JsonArray();
        for (IJsonPredicate<I> predicate : this.getter.apply(object)) {
            array.add(this.loader.serialize(predicate));
        }
        json.add("predicates", (JsonElement)array);
    }

    @Override
    public void toNetwork(T object, FriendlyByteBuf buffer) {
        List<IJsonPredicate<I>> list = this.getter.apply(object);
        buffer.m_130130_(list.size());
        for (IJsonPredicate<I> predicate : list) {
            this.loader.toNetwork(predicate, buffer);
        }
    }

    public NestedJsonPredicateLoader(GenericLoaderRegistry<IJsonPredicate<I>> loader, InvertedJsonPredicate.Loader<I> inverter, BiFunction<NestedJsonPredicateLoader<I, T>, List<IJsonPredicate<I>>, T> constructor, Function<T, List<IJsonPredicate<I>>> getter) {
        this.loader = loader;
        this.inverter = inverter;
        this.constructor = constructor;
        this.getter = getter;
    }
}

