/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate.entity;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.NamedComponentRegistry;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;

public class MobTypePredicate
implements LivingEntityPredicate {
    public static final NamedComponentRegistry<MobType> MOB_TYPES = new NamedComponentRegistry("Unknown mob type");
    private final MobType type;
    public static final GenericLoaderRegistry.IGenericLoader<MobTypePredicate> LOADER = new GenericLoaderRegistry.IGenericLoader<MobTypePredicate>(){

        @Override
        public MobTypePredicate deserialize(JsonObject json) {
            return new MobTypePredicate(MOB_TYPES.deserialize(json, "mobs"));
        }

        @Override
        public MobTypePredicate fromNetwork(FriendlyByteBuf buffer) {
            return new MobTypePredicate(MOB_TYPES.fromNetwork(buffer));
        }

        @Override
        public void serialize(MobTypePredicate object, JsonObject json) {
            json.addProperty("mobs", MOB_TYPES.getKey(object.type).toString());
        }

        @Override
        public void toNetwork(MobTypePredicate object, FriendlyByteBuf buffer) {
            MOB_TYPES.toNetwork(object.type, buffer);
        }
    };

    @Override
    public boolean matches(LivingEntity input) {
        return input.m_6336_() == this.type;
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends LivingEntityPredicate> getLoader() {
        return LOADER;
    }

    public MobTypePredicate(MobType type) {
        this.type = type;
    }
}

