/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;

public interface IRecipeHelper {
    public String getModId();

    default public ResourceLocation modResource(String name) {
        return new ResourceLocation(this.getModId(), name);
    }

    default public String modPrefix(String id) {
        return this.getModId() + ":" + id;
    }

    default public ResourceLocation wrap(ResourceLocation loc, String prefix, String suffix) {
        return this.modResource(prefix + loc.m_135815_() + suffix);
    }

    default public ResourceLocation wrap(IForgeRegistryEntry<?> entry, String prefix, String suffix) {
        return this.wrap(Objects.requireNonNull(entry.getRegistryName()), prefix, suffix);
    }

    default public ResourceLocation wrap(Supplier<? extends IForgeRegistryEntry<?>> entry, String prefix, String suffix) {
        return this.wrap(entry.get(), prefix, suffix);
    }

    default public ResourceLocation prefix(ResourceLocation location, String prefix) {
        return this.modResource(prefix + location.m_135815_());
    }

    default public ResourceLocation prefix(IForgeRegistryEntry<?> entry, String prefix) {
        return this.prefix(Objects.requireNonNull(entry.getRegistryName()), prefix);
    }

    default public ResourceLocation prefix(Supplier<? extends IForgeRegistryEntry<?>> entry, String prefix) {
        return this.prefix(entry.get(), prefix);
    }

    default public TagKey<Item> getItemTag(String modId, String name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(modId, name));
    }

    default public TagKey<Fluid> getFluidTag(String modId, String name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)new ResourceLocation(modId, name));
    }

    default public ICondition tagCondition(String name) {
        return new NotCondition((ICondition)new TagEmptyCondition("forge", name));
    }

    default public Consumer<FinishedRecipe> withCondition(Consumer<FinishedRecipe> consumer, ICondition ... conditions) {
        ConsumerWrapperBuilder builder = ConsumerWrapperBuilder.wrap();
        for (ICondition condition : conditions) {
            builder.addCondition(condition);
        }
        return builder.build(consumer);
    }
}

