/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import potionstudios.byg.BYG;
import potionstudios.byg.common.entity.npc.VillagerTradeRegistry;
import potionstudios.byg.common.world.biome.BYGNetherBiomes;
import potionstudios.byg.common.world.biome.BYGOverworldBiomes;
import potionstudios.byg.common.world.biome.end.BYGEndBiomes;
import potionstudios.byg.common.world.placement.BYGPlacementModifierType;
import potionstudios.byg.common.world.structure.BYGStructurePieceTypes;
import potionstudios.byg.common.world.structure.BYGStructureSets;
import potionstudios.byg.common.world.surfacerules.rulesource.BYGRuleSources;
import potionstudios.byg.reg.RegistrationProvider;
import potionstudios.byg.util.blendingfunction.BlendingFunction;

public class BYGBiomes {
    public static final RegistrationProvider<Biome> PROVIDER = RegistrationProvider.get(BuiltinRegistries.f_123865_, "byg");
    public static final ResourceKey<Biome> ALLIUM_FIELDS = BYGBiomes.createBiome("allium_fields", BYGOverworldBiomes::alliumFields);
    public static final ResourceKey<Biome> AMARANTH_FIELDS = BYGBiomes.createBiome("amaranth_fields", BYGOverworldBiomes::amaranthFields);
    public static final ResourceKey<Biome> ARAUCARIA_SAVANNA = BYGBiomes.createBiome("araucaria_savanna", () -> BYGOverworldBiomes.araucariaSavanna(false));
    public static final ResourceKey<Biome> ASPEN_FOREST = BYGBiomes.createBiome("aspen_forest", BYGOverworldBiomes::aspenForest);
    public static final ResourceKey<Biome> ATACAMA_DESERT = BYGBiomes.createBiome("atacama_desert", BYGOverworldBiomes::atacamaDesert);
    public static final ResourceKey<Biome> AUTUMNAL_VALLEY = BYGBiomes.createBiome("autumnal_valley", BYGOverworldBiomes::autumnalValley);
    public static final ResourceKey<Biome> BAOBAB_SAVANNA = BYGBiomes.createBiome("baobab_savanna", BYGOverworldBiomes::baobabSavanna);
    public static final ResourceKey<Biome> BAYOU = BYGBiomes.createBiome("bayou", BYGOverworldBiomes::bayou);
    public static final ResourceKey<Biome> BLACK_FOREST = BYGBiomes.createBiome("black_forest", BYGOverworldBiomes::blackForest);
    public static final ResourceKey<Biome> BOREALIS_GROVE = BYGBiomes.createBiome("borealis_grove", BYGOverworldBiomes::borealisGrove);
    public static final ResourceKey<Biome> CANADIAN_SHIELD = BYGBiomes.createBiome("canadian_shield", BYGOverworldBiomes::canadianShield);
    public static final ResourceKey<Biome> CHERRY_BLOSSOM_FOREST = BYGBiomes.createBiome("cherry_blossom_forest", BYGOverworldBiomes::cherryBlossomForest);
    public static final ResourceKey<Biome> CIKA_WOODS = BYGBiomes.createBiome("cika_woods", BYGOverworldBiomes::cikaWoods);
    public static final ResourceKey<Biome> CONIFEROUS_FOREST = BYGBiomes.createBiome("coniferous_forest", () -> BYGOverworldBiomes.coniferousForest(false));
    public static final ResourceKey<Biome> CRAG_GARDENS = BYGBiomes.createBiome("crag_gardens", BYGOverworldBiomes::cragGardens);
    public static final ResourceKey<Biome> CYPRESS_SWAMPLANDS = BYGBiomes.createBiome("cypress_swamplands", BYGOverworldBiomes::cypressSwamplands);
    public static final ResourceKey<Biome> LUSH_STACKS = BYGBiomes.createBiome("lush_stacks", BYGOverworldBiomes::lushStacks);
    public static final ResourceKey<Biome> DEAD_SEA = BYGBiomes.createBiome("dead_sea", BYGOverworldBiomes::deadSea);
    public static final ResourceKey<Biome> DACITE_RIDGES = BYGBiomes.createBiome("dacite_ridges", BYGOverworldBiomes::daciteRidges);
    public static final ResourceKey<Biome> WINDSWEPT_DUNES = BYGBiomes.createBiome("windswept_dunes", () -> BYGOverworldBiomes.windsweptDesert(true));
    public static final ResourceKey<Biome> WINDSWEPT_DESERT = BYGBiomes.createBiome("windswept_desert", () -> BYGOverworldBiomes.windsweptDesert(false));
    public static final ResourceKey<Biome> EBONY_WOODS = BYGBiomes.createBiome("ebony_woods", BYGOverworldBiomes::ebonyWoods);
    public static final ResourceKey<Biome> FORGOTTEN_FOREST = BYGBiomes.createBiome("forgotten_forest", BYGOverworldBiomes::forgottenForest);
    public static final ResourceKey<Biome> GROVE = BYGBiomes.createBiome("temperate_grove", () -> BYGOverworldBiomes.temperateGrove(false));
    public static final ResourceKey<Biome> GUIANA_SHIELD = BYGBiomes.createBiome("guiana_shield", BYGOverworldBiomes::guianaShield);
    public static final ResourceKey<Biome> HOWLING_PEAKS = BYGBiomes.createBiome("howling_peaks", BYGOverworldBiomes::howlingPeaks);
    public static final ResourceKey<Biome> JACARANDA_FOREST = BYGBiomes.createBiome("jacaranda_forest", BYGOverworldBiomes::jacarandaForest);
    public static final ResourceKey<Biome> MAPLE_TAIGA = BYGBiomes.createBiome("maple_taiga", BYGOverworldBiomes::mapleTaiga);
    public static final ResourceKey<Biome> COCONINO_MEADOW = BYGBiomes.createBiome("coconino_meadow", () -> BYGOverworldBiomes.coconinoMeadow(false, false));
    public static final ResourceKey<Biome> MOJAVE_DESERT = BYGBiomes.createBiome("mojave_desert", BYGOverworldBiomes::mojaveDesert);
    public static final ResourceKey<Biome> CARDINAL_TUNDRA = BYGBiomes.createBiome("cardinal_tundra", BYGOverworldBiomes::cardinalTundra);
    public static final ResourceKey<Biome> ORCHARD = BYGBiomes.createBiome("orchard", BYGOverworldBiomes::orchard);
    public static final ResourceKey<Biome> PRAIRIE = BYGBiomes.createBiome("prairie", BYGOverworldBiomes::prairie);
    public static final ResourceKey<Biome> RED_OAK_FOREST = BYGBiomes.createBiome("red_oak_forest", BYGOverworldBiomes::redOakForest);
    public static final ResourceKey<Biome> RED_ROCK_VALLEY = BYGBiomes.createBiome("red_rock_valley", BYGOverworldBiomes::redRockValley);
    public static final ResourceKey<Biome> ROSE_FIELDS = BYGBiomes.createBiome("rose_fields", BYGOverworldBiomes::roseFields);
    public static final ResourceKey<Biome> AUTUMNAL_FOREST = BYGBiomes.createBiome("autumnal_forest", BYGOverworldBiomes::autumnalForest);
    public static final ResourceKey<Biome> AUTUMNAL_TAIGA = BYGBiomes.createBiome("autumnal_taiga", () -> BYGOverworldBiomes.autumnalTaiga(false));
    public static final ResourceKey<Biome> SHATTERED_GLACIER = BYGBiomes.createBiome("shattered_glacier", BYGOverworldBiomes::shatteredGlacier);
    public static final ResourceKey<Biome> FIRECRACKER_SHRUBLAND = BYGBiomes.createBiome("firecracker_shrubland", BYGOverworldBiomes::firecrackerShrubland);
    public static final ResourceKey<Biome> SIERRA_BADLANDS = BYGBiomes.createBiome("sierra_badlands", BYGOverworldBiomes::sierraBadlands);
    public static final ResourceKey<Biome> SKYRIS_VALE = BYGBiomes.createBiome("skyris_vale", BYGOverworldBiomes::skyrisVale);
    public static final ResourceKey<Biome> REDWOOD_THICKET = BYGBiomes.createBiome("redwood_thicket", BYGOverworldBiomes::redwoodThicket);
    public static final ResourceKey<Biome> FROSTED_TAIGA = BYGBiomes.createBiome("frosted_taiga", () -> BYGOverworldBiomes.frostedTaiga(true, false));
    public static final ResourceKey<Biome> FROSTED_CONIFEROUS_FOREST = BYGBiomes.createBiome("frosted_coniferous_forest", () -> BYGOverworldBiomes.coniferousForest(true));
    public static final ResourceKey<Biome> FRAGMENT_FOREST = BYGBiomes.createBiome("fragment_forest", BYGOverworldBiomes::fragmentForest);
    public static final ResourceKey<Biome> TROPICAL_RAINFOREST = BYGBiomes.createBiome("tropical_rainforest", BYGOverworldBiomes::tropicalRainforest);
    public static final ResourceKey<Biome> TWILIGHT_MEADOW = BYGBiomes.createBiome("twilight_meadow", BYGOverworldBiomes::twilightMeadow);
    public static final ResourceKey<Biome> WEEPING_WITCH_FOREST = BYGBiomes.createBiome("weeping_witch_forest", BYGOverworldBiomes::weepingWitchForest);
    public static final ResourceKey<Biome> WHITE_MANGROVE_MARSHES = BYGBiomes.createBiome("white_mangrove_marshes", BYGOverworldBiomes::whiteMangroveMarshes);
    public static final ResourceKey<Biome> TEMPERATE_RAINFOREST = BYGBiomes.createBiome("temperate_rainforest", BYGOverworldBiomes::temperateRainForest);
    public static final ResourceKey<Biome> ZELKOVA_FOREST = BYGBiomes.createBiome("zelkova_forest", BYGOverworldBiomes::zelkovaForest);
    public static final ResourceKey<Biome> WINDSWEPT_BEACH = BYGBiomes.createBiome("windswept_beach", BYGOverworldBiomes::windsweptBeach);
    public static final ResourceKey<Biome> RAINBOW_BEACH = BYGBiomes.createBiome("rainbow_beach", BYGOverworldBiomes::rainbowBeach);
    public static final ResourceKey<Biome> BASALT_BARRERA = BYGBiomes.createBiome("basalt_barrera", BYGOverworldBiomes::basaltBarrera);
    public static final ResourceKey<Biome> DACITE_SHORE = BYGBiomes.createBiome("dacite_shore", BYGOverworldBiomes::daciteShore);
    public static final ResourceKey<Biome> BRIMSTONE_CAVERNS = BYGBiomes.createBiome("brimstone_caverns", BYGNetherBiomes::brimstoneCaverns);
    public static final ResourceKey<Biome> CRIMSON_GARDENS = BYGBiomes.createBiome("crimson_gardens", BYGNetherBiomes::crimsonGardens);
    public static final ResourceKey<Biome> EMBUR_BOG = BYGBiomes.createBiome("embur_bog", BYGNetherBiomes::emburBog);
    public static final ResourceKey<Biome> GLOWSTONE_GARDENS = BYGBiomes.createBiome("glowstone_gardens", BYGNetherBiomes::glowstoneGardens);
    public static final ResourceKey<Biome> MAGMA_WASTES = BYGBiomes.createBiome("magma_wastes", BYGNetherBiomes::magmaWastes);
    public static final ResourceKey<Biome> SUBZERO_HYPOGEAL = BYGBiomes.createBiome("subzero_hypogeal", BYGNetherBiomes::subzeroHypogeal);
    public static final ResourceKey<Biome> SYTHIAN_TORRIDS = BYGBiomes.createBiome("sythian_torrids", BYGNetherBiomes::sythianTorrids);
    public static final ResourceKey<Biome> WARPED_DESERT = BYGBiomes.createBiome("warped_desert", BYGNetherBiomes::warpedDesert);
    public static final ResourceKey<Biome> WAILING_GARTH = BYGBiomes.createBiome("wailing_garth", BYGNetherBiomes::wailingGarth);
    public static final ResourceKey<Biome> ARISIAN_UNDERGROWTH = BYGBiomes.createBiome("arisian_undergrowth", BYGNetherBiomes::arisianUndergrowth);
    public static final ResourceKey<Biome> WEEPING_MIRE = BYGBiomes.createBiome("weeping_mire", BYGNetherBiomes::weepingMire);
    public static final ResourceKey<Biome> QUARTZ_DESERT = BYGBiomes.createBiome("quartz_desert", BYGNetherBiomes::quartzDesert);
    public static final ResourceKey<Biome> IVIS_FIELDS = BYGBiomes.createBiome("ivis_fields", BYGEndBiomes::ivisFields);
    public static final ResourceKey<Biome> NIGHTSHADE_FOREST = BYGBiomes.createBiome("nightshade_forest", BYGEndBiomes::nightshadeForest);
    public static final ResourceKey<Biome> ETHEREAL_ISLANDS = BYGBiomes.createBiome("ethereal_islands", BYGEndBiomes::etherealIslands);
    public static final ResourceKey<Biome> VISCAL_ISLES = BYGBiomes.createBiome("viscal_isles", BYGEndBiomes::viscalIsles);
    public static final ResourceKey<Biome> BULBIS_GARDENS = BYGBiomes.createBiome("bulbis_gardens", BYGEndBiomes::bulbisGardens);
    public static final ResourceKey<Biome> SHULKREN_FOREST = BYGBiomes.createBiome("shulkren_forest", BYGEndBiomes::shulkrenForest);
    public static final ResourceKey<Biome> CRYPTIC_WASTES = BYGBiomes.createBiome("cryptic_wastes", BYGEndBiomes::crypticWastes);
    public static final ResourceKey<Biome> IMPARIUS_GROVE = BYGBiomes.createBiome("imparius_grove", BYGEndBiomes::impariusGrove);

    public static <B extends Biome> ResourceKey<Biome> createBiome(String id, Supplier<? extends B> biome) {
        ResourceLocation bygID = BYG.createLocation(id);
        if (BuiltinRegistries.f_123865_.m_6566_().contains(bygID)) {
            throw new IllegalStateException("Biome ID: \"" + bygID + "\" already exists in the Biome registry!");
        }
        PROVIDER.register(id, biome);
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)bygID);
    }

    public static void loadClass() {
        BlendingFunction.register();
        BYGStructurePieceTypes.bootStrap();
        BYGStructureSets.bootStrap();
        BYGPlacementModifierType.bootStrap();
        BYGRuleSources.bootStrap();
        VillagerTradeRegistry.register();
    }
}

