/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import potionstudios.byg.common.world.feature.placement.BYGPlacedFeaturesUtil;

public record LargeLakeFeatureConfig(int minRadius, int maxRadius, int minDepth, int maxDepth, BlockStateProvider lakeFloorStateProvider, BlockStateProvider borderStateProvider, HolderSet<PlacedFeature> lakeSurfaceFeatures, HolderSet<PlacedFeature> lakeEdgeFeatures, List<PlacementModifier> modifiers) implements FeatureConfiguration
{
    public static final Codec<LargeLakeFeatureConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("minRadius").forGetter(largeLakeFeatureConfig -> largeLakeFeatureConfig.minRadius), (App)Codec.INT.fieldOf("maxRadius").forGetter(largeLakeFeatureConfig -> largeLakeFeatureConfig.maxRadius), (App)Codec.INT.fieldOf("minDepth").forGetter(largeLakeFeatureConfig -> largeLakeFeatureConfig.minDepth), (App)Codec.INT.fieldOf("maxDepth").forGetter(largeLakeFeatureConfig -> largeLakeFeatureConfig.maxDepth), (App)BlockStateProvider.f_68747_.fieldOf("floorStateProvider").forGetter(largeLakeFeatureConfig -> largeLakeFeatureConfig.lakeFloorStateProvider), (App)BlockStateProvider.f_68747_.fieldOf("edgeStateProvider").forGetter(largeLakeFeatureConfig -> largeLakeFeatureConfig.borderStateProvider), (App)PlacedFeature.f_191774_.fieldOf("surface_features").forGetter(largeLakeFeatureConfig -> largeLakeFeatureConfig.lakeSurfaceFeatures), (App)PlacedFeature.f_191774_.fieldOf("edge_features").forGetter(largeLakeFeatureConfig -> largeLakeFeatureConfig.lakeEdgeFeatures), (App)PlacementModifier.f_191842_.listOf().fieldOf("edgeStateProvider_placement").forGetter(largeLakeFeatureConfig -> largeLakeFeatureConfig.modifiers)).apply((Applicative)builder, LargeLakeFeatureConfig::new));

    public int getRandomRadius(Random random) {
        return random.nextInt(Math.max(1, this.maxRadius - this.minRadius)) + this.minRadius;
    }

    public int getRandomDepth(Random random) {
        return random.nextInt(Math.max(1, this.maxDepth - this.minDepth)) + this.minRadius;
    }

    public static Holder<PlacedFeature> createDripLeavesPlacedFeature(int rarity, PlacementModifier ... modifiers) {
        ArrayList<PlacementModifier> placementModifiers = new ArrayList<PlacementModifier>();
        placementModifiers.add((PlacementModifier)RarityFilter.m_191900_((int)rarity));
        placementModifiers.addAll(List.of(modifiers));
        placementModifiers.addAll(List.of(BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190430_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190399_((BlockState)Blocks.f_152545_.m_49966_(), (Vec3i)BlockPos.f_121853_), BlockPredicate.m_190399_((BlockState)Blocks.f_152547_.m_49966_(), (Vec3i)BlockPos.f_121853_), BlockPredicate.m_190399_((BlockState)Blocks.f_152547_.m_49966_(), (Vec3i)BlockPos.f_121853_)}))));
        return BYGPlacedFeaturesUtil.createPlacedFeature(CaveFeatures.f_194952_, placementModifiers);
    }
}

