/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.features;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import potionstudios.byg.common.world.feature.features.BYGGlobalFeatureFeatures;
import potionstudios.byg.common.world.feature.features.BYGGlobalFeatures;
import potionstudios.byg.mixin.access.VegetationFeaturesAccess;
import potionstudios.byg.reg.RegistrationProvider;

public class BYGFeaturesUtil {
    public static final RegistrationProvider<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = RegistrationProvider.get(BuiltinRegistries.f_123861_, "byg");

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<FC, ?>> createConfiguredFeature(String id, Supplier<? extends F> feature, FC config) {
        return CONFIGURED_FEATURES.register(id, () -> {
            BYGGlobalFeatureFeatures.loadClass();
            BYGGlobalFeatures.loadClass();
            return new ConfiguredFeature((Feature)feature.get(), config);
        }).asHolder();
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<FC, ?>> createConfiguredFeatureSupplierConfig(String id, Supplier<? extends F> feature, Supplier<? extends FC> config) {
        return CONFIGURED_FEATURES.register(id, () -> new ConfiguredFeature((Feature)feature.get(), (FeatureConfiguration)config.get())).asHolder();
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<FC, ?>> createConfiguredFeature(F feature, FC config) {
        return Holder.m_205709_((Object)new ConfiguredFeature(feature, config));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> createFlowerConfiguredFeature(String id, Block flowerBlock) {
        return BYGFeaturesUtil.createConfiguredFeature(id, () -> Feature.f_65761_, VegetationFeaturesAccess.byg_invokeGrassPatch((BlockStateProvider)SimpleStateProvider.m_191384_((BlockState)flowerBlock.m_49966_()), 15));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> createPatchConfiguredFeature(String id, Block block, int tries) {
        return BYGFeaturesUtil.createPatchConfiguredFeature(id, block.m_49966_(), tries);
    }

    public static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> createPatchConfiguredFeature(String id, BlockState state, int tries) {
        return BYGFeaturesUtil.createConfiguredFeature(id, () -> Feature.f_65763_, FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state)), List.of(), (int)tries));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> createPatchConfiguredFeature(Block block, int tries) {
        return Holder.m_205709_((Object)new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block)), List.of(), (int)tries)));
    }

    public static Holder<ConfiguredFeature<SimpleBlockConfiguration, ?>> createSimpleBlockConfiguredFeature(String id, Block block) {
        return BYGFeaturesUtil.createSimpleBlockConfiguredFeature(id, block.m_49966_());
    }

    public static Holder<ConfiguredFeature<SimpleBlockConfiguration, ?>> createSimpleBlockConfiguredFeature(String id, BlockState state) {
        return BYGFeaturesUtil.createConfiguredFeature(id, () -> Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state)));
    }

    public static BlockPredicateFilter createSolidDownAndAirAllAroundFilter(BlockPredicate ... predicates) {
        return BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190412_((List)new ImmutableList.Builder().add((Object[])new BlockPredicate[]{BlockPredicate.m_190423_((Vec3i)BlockPos.f_121853_.m_142300_(Direction.DOWN)), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_190423_((Vec3i)BlockPos.f_121853_.m_142300_(Direction.WEST))), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_190423_((Vec3i)BlockPos.f_121853_.m_142300_(Direction.EAST))), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_190423_((Vec3i)BlockPos.f_121853_.m_142300_(Direction.NORTH))), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_190423_((Vec3i)BlockPos.f_121853_.m_142300_(Direction.SOUTH))), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_190423_((Vec3i)BlockPos.f_121853_.m_142300_(Direction.UP)))}).add((Object)BlockPredicate.m_198311_(List.of(Blocks.f_50016_, Blocks.f_50627_))).add((Object[])predicates).build()));
    }

    public static String globalGenStagePath(GenerationStep.Decoration stage) {
        return "global/" + stage.toString().toLowerCase(Locale.ROOT);
    }
}

