/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.end.islands.shattered;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import potionstudios.byg.common.world.feature.config.FloatingIslandConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class ShatteredFloatingIslands1
extends Feature<FloatingIslandConfig> {
    FastNoise perlin = null;

    public ShatteredFloatingIslands1(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FloatingIslandConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (FloatingIslandConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, Random rand, BlockPos pos, FloatingIslandConfig config) {
        this.setSeed(world.m_7328_());
        double radius = rand.nextInt(config.getMaxPossibleRadius()) + config.getMinRadius();
        if (world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_()) > 4) {
            return false;
        }
        int modifiedRadiusOnY = (int)(radius + 11.0);
        for (double x = -radius; x <= radius; x += 1.0) {
            for (double y = -radius; y <= (double)modifiedRadiusOnY; y += 1.0) {
                for (double z = -radius; z <= radius; z += 1.0) {
                    double noise = this.perlin.GetNoise((float)x, (float)y, (float)z) * 12.0f;
                    double scaledNoise = noise / 11.0 * (y * 3.0 / (x * x + z * z));
                    if (!(scaledNoise >= 0.5) || !(y >= 1.0)) continue;
                    world.m_7731_(pos.m_142022_(x, y - (double)modifiedRadiusOnY, z), config.getBlockProvider().m_7112_(rand, pos), 2);
                    if (y != (double)modifiedRadiusOnY) continue;
                    world.m_7731_(pos.m_142022_(x, y - (double)modifiedRadiusOnY, z), config.getTopBlockProvider().m_7112_(rand, pos), 2);
                }
            }
        }
        return false;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = new FastNoise((int)seed);
            this.perlin.SetNoiseType(FastNoise.NoiseType.Perlin);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

