/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import potionstudios.byg.common.world.feature.config.LargeLakeFeatureConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;
import potionstudios.byg.util.MLBlockTags;

public class LargeLakeFeature
extends Feature<LargeLakeFeatureConfig> {
    public static final boolean DEBUG = false;
    public static Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN};
    public static FastNoise fastNoise;
    protected static long seed;

    public LargeLakeFeature(Codec<LargeLakeFeatureConfig> $$0) {
        super($$0);
    }

    public boolean m_142674_(FeaturePlaceContext<LargeLakeFeatureConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (LargeLakeFeatureConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos, LargeLakeFeatureConfig config) {
        LargeLakeFeature.setSeed(world.m_7328_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)blockPos);
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutable);
        int xRadius = config.getRandomRadius(random) / 2;
        int yRadius = config.getRandomDepth(random);
        int zRadius = config.getRandomRadius(random) / 2;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> edgePositions = new ArrayList<BlockPos>();
        Function<BlockPos, BlockState> lakeBorderStateFunction = blockPos3 -> config.borderStateProvider().m_7112_(random, blockPos3);
        Function<BlockPos, BlockState> lakeFloorStateFunction = blockPos3 -> config.lakeFloorStateProvider().m_7112_(random, blockPos3);
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int z = -zRadius; z <= zRadius; ++z) {
                for (int y = -yRadius; y <= 0; ++y) {
                    mutable2.m_122190_((Vec3i)mutable).m_122184_(x, y, z);
                    double xSquared = Math.pow(x, 2.0);
                    double ySquared = Math.pow(y, 2.0);
                    double zSquared = Math.pow(z, 2.0);
                    double squaredDistance = xSquared + ySquared + zSquared;
                    double equationResult = xSquared / Math.pow(xRadius, 2.0) + ySquared / Math.pow(yRadius, 2.0) + zSquared / Math.pow(zRadius, 2.0);
                    double threshold = 1.0 + 1.4 * (double)fastNoise.GetNoise(mutable2.m_123341_(), mutable2.m_123342_() * 2, mutable2.m_123343_());
                    if (equationResult >= threshold) continue;
                    if (squaredDistance <= (double)(xRadius * zRadius)) {
                        BlockPos immutable = mutable2.m_7949_();
                        if (y >= 0) continue;
                        positions.add(immutable);
                        continue;
                    }
                    double sizeAmplifier = 1.6;
                    if (y < 0 || !(squaredDistance <= ((double)xRadius + (double)xRadius * sizeAmplifier) * ((double)zRadius + (double)zRadius * sizeAmplifier))) continue;
                    edgePositions.add(mutable2.m_7949_());
                }
            }
        }
        int waterLevel = blockPos.m_123342_();
        for (BlockPos position : positions) {
            waterLevel = Math.min(world.m_6924_(Heightmap.Types.WORLD_SURFACE, position.m_123341_(), position.m_123343_()) - 1, waterLevel);
        }
        ArrayList<Pair> fallingBlocks = new ArrayList<Pair>();
        ArrayList<BlockPos> lakeSurfacePositions = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        block4: for (BlockPos position : positions) {
            BlockPos.MutableBlockPos mutable3 = mutableBlockPos.m_122178_(position.m_123341_(), Math.min(position.m_123342_(), waterLevel), position.m_123343_());
            for (int i = mutable3.m_123342_(); i <= waterLevel; ++i) {
                this.setLakeBlocks(world, mutable3.m_123342_() == waterLevel ? lakeBorderStateFunction : lakeFloorStateFunction, (BlockPos)mutable3);
                mutable3.m_122173_(Direction.UP);
            }
            lakeSurfacePositions.add(mutable3.m_7949_());
            BlockPos.MutableBlockPos mutable4 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutable3);
            for (int i = 0; i < 10; ++i) {
                BlockState blockStateAbove = world.m_8055_((BlockPos)mutable4);
                Block stateAboveBlock = blockStateAbove.m_60734_();
                if (stateAboveBlock instanceof FallingBlock) {
                    fallingBlocks.add(new Pair((Object)mutable4.m_7949_(), (Object)blockStateAbove));
                    world.m_7471_((BlockPos)mutable4, false);
                } else {
                    if (!LargeLakeFeature.canReplace(blockStateAbove)) continue block4;
                    world.m_7471_((BlockPos)mutable4, false);
                }
                mutable4.m_122173_(Direction.UP);
            }
        }
        for (BlockPos lakeSurfacePosition : lakeSurfacePositions) {
            for (Holder lakeSurfaceFeature : config.lakeSurfaceFeatures()) {
                ((PlacedFeature)lakeSurfaceFeature.m_203334_()).m_191782_(world, chunkGenerator, random, lakeSurfacePosition);
            }
        }
        for (BlockPos lakeEdgePosition : edgePositions) {
            for (Holder lakeSurfaceFeature : config.lakeEdgeFeatures()) {
                ((PlacedFeature)lakeSurfaceFeature.m_203334_()).m_191782_(world, chunkGenerator, random, lakeEdgePosition);
            }
        }
        return true;
    }

    private void setLakeBlocks(WorldGenLevel world, Function<BlockPos, BlockState> stateFunction, BlockPos mutable2) {
        world.m_7731_(mutable2, Blocks.f_49990_.m_49966_(), 2);
        world.m_186469_(mutable2, (Fluid)Fluids.f_76193_, 0);
        BlockPos.MutableBlockPos mutable3 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutable2);
        for (Direction value : DIRECTIONS) {
            mutable3.m_122159_((Vec3i)mutable2, value);
            if (world.m_8055_((BlockPos)mutable3).m_60734_() == Blocks.f_49990_) continue;
            world.m_7731_((BlockPos)mutable3, stateFunction.apply((BlockPos)mutable3), 2);
        }
    }

    private void fillDownwards(WorldGenLevel world, Function<BlockPos, BlockState> stateFunction, BlockPos.MutableBlockPos mutable3) {
        while (mutable3.m_123342_() > world.m_141937_()) {
            world.m_7731_((BlockPos)mutable3, stateFunction.apply((BlockPos)mutable3), 2);
            mutable3.m_122173_(Direction.DOWN);
        }
    }

    public static void setSeed(long worldSeed) {
        if (seed != worldSeed || fastNoise == null) {
            fastNoise = new FastNoise((int)worldSeed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            fastNoise.SetFrequency(0.8f);
            seed = worldSeed;
        }
    }

    private static boolean canReplace(BlockState state) {
        Material material = state.m_60767_();
        return !state.m_60795_() && material.m_76336_() || state.m_204336_(BlockTags.f_13061_) || state.m_204336_(MLBlockTags.END_STONES) || state.m_204336_(MLBlockTags.SANDSTONE) || state.m_204336_(BlockTags.f_13041_) || state.m_204336_(MLBlockTags.ORES) || state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_198156_) || material == Material.f_76300_ || material == Material.f_76301_ || material == Material.f_76304_ || material == Material.f_76277_;
    }
}

