/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.surfacerules.rulesource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import potionstudios.byg.mixin.access.SurfaceRuleContextAccess;
import potionstudios.byg.mixin.access.SurfaceSystemAccess;

public final class BandsRuleSource
implements SurfaceRules.RuleSource {
    public static final Codec<BandsRuleSource> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockState.f_61039_.listOf().fieldOf("states").forGetter(bandsRuleSource -> Arrays.asList(bandsRuleSource.bandStates))).apply((Applicative)builder, BandsRuleSource::new));
    private final BlockState[] bandStates = new BlockState[8];
    @Nullable
    private BlockState[] generatedBands = null;

    public BandsRuleSource(List<BlockState> bandStates) {
        this((BlockState[])bandStates.toArray(BlockState[]::new));
    }

    public BandsRuleSource(BlockState[] bandStates) {
        for (int i = 0; i < this.bandStates.length; ++i) {
            this.bandStates[i] = bandStates[Math.min(i, bandStates.length - 1)];
        }
    }

    public Codec<? extends SurfaceRules.RuleSource> m_183290_() {
        return CODEC;
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
        SurfaceSystem system = ((SurfaceRuleContextAccess)context).byg_getSystem();
        if (this.generatedBands == null) {
            this.generatedBands = this.generateBands(((SurfaceSystemAccess)system).byg_getRandomFactory().m_189318_(new ResourceLocation("clay_bands")));
        }
        return (x, y, z) -> BandsRuleSource.getBand(x, y, z, this.generatedBands, ((SurfaceSystemAccess)system).byg_getClayBandsOffsetNoise());
    }

    private static BlockState getBand(int x, int y, int z, BlockState[] bands, NormalNoise offsetNoise) {
        int noiseVal = (int)Math.round(offsetNoise.m_75380_((double)x, 0.0, (double)z) * 4.0);
        return bands[(y + noiseVal + bands.length) % bands.length];
    }

    private BlockState[] generateBands(RandomSource p_189965_) {
        Object[] ablockstate = new BlockState[192];
        Arrays.fill(ablockstate, this.bandStates[0]);
        for (int k = 0; k < ablockstate.length; ++k) {
            if ((k += p_189965_.nextInt(5) + 1) >= ablockstate.length) continue;
            ablockstate[k] = this.bandStates[1];
        }
        SurfaceSystemAccess.byg_invokeMakeBands(p_189965_, (BlockState[])ablockstate, 1, this.bandStates[2]);
        SurfaceSystemAccess.byg_invokeMakeBands(p_189965_, (BlockState[])ablockstate, 2, this.bandStates[3]);
        SurfaceSystemAccess.byg_invokeMakeBands(p_189965_, (BlockState[])ablockstate, 1, this.bandStates[4]);
        int l = p_189965_.m_189320_(9, 15);
        int i = 0;
        for (int j = 0; i < l && j < ablockstate.length; ++i, j += p_189965_.nextInt(16) + 4) {
            ablockstate[j] = this.bandStates[5];
            BlockState state6 = this.bandStates[6];
            if (j - 1 > 0 && p_189965_.nextBoolean()) {
                ablockstate[j - 1] = state6;
            }
            if (j + 1 >= ablockstate.length || !p_189965_.nextBoolean()) continue;
            ablockstate[j + 1] = state6;
        }
        return ablockstate;
    }

    public BlockState[] bandStates() {
        return this.bandStates;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BandsRuleSource that = (BandsRuleSource)obj;
        return Objects.equals(this.bandStates, that.bandStates);
    }

    public int hashCode() {
        return Objects.hash(this.bandStates);
    }

    public String toString() {
        return "ShatteredGlacierIceBands[bandStates=" + Arrays.toString(this.bandStates) + "]";
    }
}

