/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import potionstudios.byg.BYG;
import potionstudios.byg.common.block.sapling.GrowingPatterns;
import potionstudios.byg.util.BYGUtil;

public interface FeatureGrowerFromBlockPattern {
    public static final List<Supplier<? extends FeatureGrowerFromBlockPattern>> ENTRIES = new ArrayList<Supplier<? extends FeatureGrowerFromBlockPattern>>();

    public void load();

    public static void serializePatterns(ResourceLocation key, List<Pair<List<BlockPos>, SimpleWeightedRandomList<GrowingPatterns.FeatureSpawner>>> patternsToSpawner) {
        patternsToSpawner.clear();
        Map<ResourceLocation, List<GrowingPatterns.GrowingPatternEntry>> patterns = GrowingPatterns.getConfig().patternsForBlock();
        if (patterns.containsKey(key)) {
            ArrayList<GrowingPatterns.GrowingPatternEntry> growingPatternEntries = new ArrayList<GrowingPatterns.GrowingPatternEntry>((Collection)patterns.get(key));
            growingPatternEntries.sort(Comparator.comparingInt(p -> {
                int saplingCount = 0;
                for (String s : p.pattern()) {
                    char[] chars;
                    for (char aChar : chars = s.toCharArray()) {
                        if (aChar != 'x' && aChar != 'X') continue;
                        ++saplingCount;
                    }
                }
                return saplingCount;
            }));
            ArrayList<Pair> patternsToSpawnerMapped = new ArrayList<Pair>();
            for (GrowingPatterns.GrowingPatternEntry growingPatternEntry : growingPatternEntries) {
                List<String> pattern = growingPatternEntry.pattern();
                SimpleWeightedRandomList<GrowingPatterns.FeatureSpawner> spawner = growingPatternEntry.spawners();
                Pair newEntry = Pair.of(new ArrayList(), spawner);
                patternsToSpawnerMapped.add(newEntry);
                int patternLoopSize = Math.min(pattern.size(), 5);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < patternLoopSize; ++i) {
                    String s = pattern.get(i);
                    String substring = s.substring(0, Math.min(s.length(), 5));
                    builder.append(substring);
                }
                String patternCombined = builder.toString();
                String trimmed = patternCombined.trim();
                if (trimmed.length() > 1) {
                    int zOffset = -patternLoopSize / 2;
                    for (int i = 0; i < patternLoopSize; ++i) {
                        char[] charArray;
                        String s = pattern.get(i);
                        int range = Math.min(s.length(), 5);
                        String substring = s.substring(0, range);
                        int xOffset = -range / 2;
                        for (char c : charArray = substring.toCharArray()) {
                            if (c == 'x' || c == 'X') {
                                ((List)newEntry.getFirst()).add(new BlockPos(xOffset, 0, zOffset));
                            }
                            ++xOffset;
                        }
                        ++zOffset;
                    }
                    continue;
                }
                ((List)newEntry.getFirst()).add(new BlockPos(0, 0, 0));
            }
            patternsToSpawner.addAll(patternsToSpawnerMapped);
            Collections.reverse(patternsToSpawner);
        }
    }

    public static boolean growFeature(Block block, ServerLevel world, BlockPos pos, Random rand, List<Pair<List<BlockPos>, SimpleWeightedRandomList<GrowingPatterns.FeatureSpawner>>> patternsToSpawner) {
        int range = 2;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        for (Pair<List<BlockPos>, SimpleWeightedRandomList<GrowingPatterns.FeatureSpawner>> entry : patternsToSpawner) {
            for (int xMove = -range; xMove <= range; ++xMove) {
                for (int zMove = -range; zMove <= range; ++zMove) {
                    Optional configuredFeaturesOptionalRegistry;
                    boolean matchedPattern = true;
                    BlockPos.MutableBlockPos mutableBlockPos1 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutableBlockPos.m_122190_((Vec3i)pos).m_122184_(xMove, 0, zMove));
                    List offsets = (List)entry.getFirst();
                    SimpleWeightedRandomList treePicker = (SimpleWeightedRandomList)entry.getSecond();
                    for (BlockPos offset : offsets) {
                        BlockPos.MutableBlockPos movedPos = mutableBlockPos1.m_122190_((Vec3i)mutableBlockPos).m_122193_((Vec3i)offset);
                        BlockState offsetState = world.m_8055_((BlockPos)movedPos);
                        if (offsetState.m_60734_() == block) continue;
                        matchedPattern = false;
                        break;
                    }
                    if (!matchedPattern || !(configuredFeaturesOptionalRegistry = world.m_5962_().m_142664_(Registry.f_122881_)).isPresent()) continue;
                    Registry configuredFeaturesRegistry = (Registry)configuredFeaturesOptionalRegistry.get();
                    Optional randomValue = treePicker.m_146266_(rand);
                    if (!randomValue.isPresent()) continue;
                    GrowingPatterns.FeatureSpawner featureSpawner = (GrowingPatterns.FeatureSpawner)randomValue.get();
                    ConfiguredFeature configuredFeature = (ConfiguredFeature)configuredFeaturesRegistry.m_7745_(featureSpawner.spawnerID());
                    if (configuredFeature != null) {
                        BlockPos spawnOffset = featureSpawner.spawnOffset();
                        BlockPos growthPos = mutableBlockPos1.m_141952_((Vec3i)spawnOffset);
                        if (configuredFeature.m_65385_((WorldGenLevel)world, world.m_7726_().m_8481_(), rand, growthPos)) {
                            for (BlockPos offset : offsets) {
                                BlockPos.MutableBlockPos movedPos = mutableBlockPos1.m_122190_((Vec3i)mutableBlockPos).m_122193_((Vec3i)offset);
                                BlockState offsetState = world.m_8055_((BlockPos)movedPos);
                                if (offsetState.m_60734_() != block) continue;
                                world.m_7471_((BlockPos)movedPos, false);
                            }
                            if (GrowingPatterns.getConfig().logGrowth()) {
                                BYG.LOGGER.info(String.format("Grower \"%s\" grew configured feature \"%s\" at position %s(growth offset: %s).", Registry.f_122824_.m_7981_((Object)block).toString(), featureSpawner.toString(), growthPos, spawnOffset));
                            }
                            return true;
                        }
                        if (!GrowingPatterns.getConfig().logGrowth()) continue;
                        BYG.LOGGER.info(String.format("Grower \"%s\" couldn't grow configured feature \"%s\" at position %s(growth offset: %s).", Registry.f_122824_.m_7981_((Object)block).toString(), featureSpawner.toString(), growthPos, spawnOffset));
                        continue;
                    }
                    BYG.LOGGER.error(String.format("Grower \"%s\" failed when attempting to spawn configured feature \"%s\" at position %s. \"%s\" is not a valid configured feature ID in this world's datapack configured feature registry! Valid entries:\n %s", Registry.f_122824_.m_7981_((Object)block).toString(), featureSpawner, pos, featureSpawner, BYGUtil.dumpRegistry(configuredFeaturesRegistry)));
                }
            }
        }
        return false;
    }
}

