/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.mantle.client.render.MantleRenderTypes;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;

public final class RenderUtils {
    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    public static void setup(ResourceLocation texture, float red, float green, float blue, float alpha) {
        RenderUtils.bindTexture(texture);
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void setup(ResourceLocation texture) {
        RenderUtils.setup(texture, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderTransparentCuboid(PoseStack matrices, MultiBufferSource buffer, FluidCuboid cube, FluidStack fluid, int opacity, int light) {
        if (opacity < 0 || fluid.isEmpty()) {
            return;
        }
        FluidAttributes attributes = fluid.getFluid().getAttributes();
        TextureAtlasSprite still = FluidRenderer.getBlockSprite((ResourceLocation)attributes.getStillTexture(fluid));
        TextureAtlasSprite flowing = FluidRenderer.getBlockSprite((ResourceLocation)attributes.getFlowingTexture(fluid));
        boolean isGas = attributes.isGaseous(fluid);
        light = FluidRenderer.withBlockLight((int)light, (int)attributes.getLuminosity(fluid));
        int color = attributes.getColor(fluid);
        if (opacity < 255) {
            int alpha = (color >> 24 & 0xFF) * opacity / 255;
            color = color & 0xFFFFFF | alpha << 24;
        }
        FluidRenderer.renderCuboid((PoseStack)matrices, (VertexConsumer)buffer.m_6299_(MantleRenderTypes.FLUID), (FluidCuboid)cube, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (Vector3f)cube.getFromScaled(), (Vector3f)cube.getToScaled(), (int)color, (int)light, (boolean)isGas);
    }

    public static void renderFluidTank(PoseStack matrices, MultiBufferSource buffer, FluidCuboid cube, FluidTankAnimated tank, int light, float partialTicks, boolean flipGas) {
        FluidStack liquid = tank.getFluid();
        int capacity = tank.getCapacity();
        if (!liquid.isEmpty() && capacity > 0) {
            float offset = tank.getRenderOffset();
            if (offset > 1.2f || offset < -1.2f) {
                offset -= (offset / 12.0f + 0.1f) * partialTicks;
                tank.setRenderOffset(offset);
            } else {
                tank.setRenderOffset(0.0f);
            }
            FluidRenderer.renderScaledCuboid((PoseStack)matrices, (MultiBufferSource)buffer, (FluidCuboid)cube, (FluidStack)liquid, (float)offset, (int)capacity, (int)light, (boolean)flipGas);
        } else {
            tank.setRenderOffset(0.0f);
        }
    }

    public static void setColorRGBA(int color) {
        float a = (float)RenderUtils.alpha(color) / 255.0f;
        float r = (float)RenderUtils.red(color) / 255.0f;
        float g = (float)RenderUtils.green(color) / 255.0f;
        float b = (float)RenderUtils.blue(color) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }

    private RenderUtils() {
    }
}

