/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.util.JsonHelper;

public class JsonRedirect {
    private final ResourceLocation id;
    @Nullable
    private final ICondition condition;

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id.toString());
        if (this.condition != null) {
            json.add("condition", (JsonElement)CraftingHelper.serialize((ICondition)this.condition));
        }
        return json;
    }

    public static JsonRedirect fromJson(JsonObject json) {
        ResourceLocation id = JsonHelper.getResourceLocation((JsonObject)json, (String)"id");
        ICondition condition = null;
        if (json.has("condition")) {
            condition = CraftingHelper.getCondition((JsonObject)json);
        }
        return new JsonRedirect(id, condition);
    }

    public JsonRedirect(ResourceLocation id, @Nullable ICondition condition) {
        this.id = id;
        this.condition = condition;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    @Nullable
    public ICondition getCondition() {
        return this.condition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonRedirect)) {
            return false;
        }
        JsonRedirect other = (JsonRedirect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResourceLocation this$id = this.getId();
        ResourceLocation other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ICondition this$condition = this.getCondition();
        ICondition other$condition = other.getCondition();
        return !(this$condition == null ? other$condition != null : !this$condition.equals(other$condition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonRedirect;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceLocation $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ICondition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        return result;
    }

    public String toString() {
        return "JsonRedirect(id=" + this.getId() + ", condition=" + this.getCondition() + ")";
    }
}

