/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.AbstractCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public abstract class MaterialCastingRecipe
extends AbstractCastingRecipe
implements IMultiRecipe<IDisplayableCastingRecipe> {
    protected final int itemCost;
    protected final IMaterialItem result;
    protected Optional<MaterialFluidRecipe> cachedFluidRecipe = Optional.empty();
    protected List<IDisplayableCastingRecipe> multiRecipes;

    public MaterialCastingRecipe(RecipeType<?> type, ResourceLocation id, String group, Ingredient cast, int itemCost, IMaterialItem result, boolean consumed, boolean switchSlots) {
        super(type, id, group, cast, consumed, switchSlots);
        this.itemCost = itemCost;
        this.result = result;
        MaterialCastingLookup.registerItemCost(result, itemCost);
    }

    protected Optional<MaterialFluidRecipe> getMaterialFluid(ICastingContainer inv) {
        return MaterialCastingLookup.getCastingFluid(inv);
    }

    protected Optional<MaterialFluidRecipe> getCachedMaterialFluid(ICastingContainer inv) {
        Optional<MaterialFluidRecipe> fluidRecipe = this.cachedFluidRecipe;
        if (fluidRecipe.filter(recipe -> recipe.matches(inv)).isEmpty() && (fluidRecipe = this.getMaterialFluid(inv)).isPresent()) {
            this.cachedFluidRecipe = fluidRecipe;
        }
        return fluidRecipe;
    }

    public boolean matches(ICastingContainer inv, Level worldIn) {
        if (!this.cast.test(inv.getStack())) {
            return false;
        }
        return this.getCachedMaterialFluid(inv).filter(recipe -> this.result.canUseMaterial(recipe.getOutput().getId())).isPresent();
    }

    @Override
    public int getCoolingTime(ICastingContainer inv) {
        return this.getCachedMaterialFluid(inv).map(recipe -> ICastingRecipe.calcCoolingTime(recipe.getTemperature(), recipe.getFluidAmount(inv.getFluid()) * this.itemCost)).orElse(1);
    }

    @Override
    public int getFluidAmount(ICastingContainer inv) {
        return this.getCachedMaterialFluid(inv).map(recipe -> recipe.getFluidAmount(inv.getFluid())).orElse(1) * this.itemCost;
    }

    @Override
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)this.result);
    }

    public ItemStack assemble(ICastingContainer inv) {
        MaterialVariant material = this.getCachedMaterialFluid(inv).map(MaterialFluidRecipe::getOutput).orElse(MaterialVariant.UNKNOWN);
        return this.result.withMaterial(material.getVariant());
    }

    protected List<FluidStack> resizeFluids(List<FluidStack> fluids) {
        if (this.itemCost != 1) {
            return fluids.stream().map(fluid -> new FluidStack(fluid, fluid.getAmount() * this.itemCost)).collect(Collectors.toList());
        }
        return fluids;
    }

    public List<IDisplayableCastingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            RecipeType<?> type = this.m_6671_();
            List<ItemStack> castItems = Arrays.asList(this.cast.m_43908_());
            this.multiRecipes = MaterialCastingLookup.getAllCastingFluids().stream().filter(recipe -> {
                MaterialVariant output = recipe.getOutput();
                return !output.isUnknown() && !output.get().isHidden() && this.result.canUseMaterial(output.getId());
            }).map(recipe -> {
                List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                int fluidAmount = fluids.stream().mapToInt(FluidStack::getAmount).max().orElse(0);
                return new DisplayCastingRecipe(type, castItems, fluids, this.result.withMaterial(recipe.getOutput().getVariant()), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * fluidAmount), this.consumed);
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public static class Serializer<T extends MaterialCastingRecipe>
    extends AbstractCastingRecipe.Serializer<T> {
        private final IFactory<T> factory;

        @Override
        protected T create(ResourceLocation idIn, String groupIn, @Nullable Ingredient cast, boolean consumed, boolean switchSlots, JsonObject json) {
            int itemCost = GsonHelper.m_13927_((JsonObject)json, (String)"item_cost");
            IMaterialItem result = (IMaterialItem)RecipeHelper.deserializeItem((String)GsonHelper.m_13906_((JsonObject)json, (String)"result"), (String)"result", IMaterialItem.class);
            return this.factory.create(idIn, groupIn, cast, itemCost, result, consumed, switchSlots);
        }

        @Override
        protected T create(ResourceLocation idIn, String groupIn, @Nullable Ingredient cast, boolean consumed, boolean switchSlots, FriendlyByteBuf buffer) {
            int fluidAmount = buffer.readInt();
            IMaterialItem result = (IMaterialItem)RecipeHelper.readItem((FriendlyByteBuf)buffer, IMaterialItem.class);
            return this.factory.create(idIn, groupIn, cast, fluidAmount, result, consumed, switchSlots);
        }

        @Override
        protected void writeExtra(FriendlyByteBuf buffer, MaterialCastingRecipe recipe) {
            buffer.writeInt(recipe.itemCost);
            RecipeHelper.writeItem((FriendlyByteBuf)buffer, (ItemLike)recipe.result);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    public static interface IFactory<T extends MaterialCastingRecipe> {
        public T create(ResourceLocation var1, String var2, @Nullable Ingredient var3, int var4, IMaterialItem var5, boolean var6, boolean var7);
    }

    public static class Table
    extends MaterialCastingRecipe {
        public Table(ResourceLocation id, String group, Ingredient cast, int itemCost, IMaterialItem result, boolean consumed, boolean switchSlots) {
            super((RecipeType)TinkerRecipeTypes.CASTING_TABLE.get(), id, group, cast, itemCost, result, consumed, switchSlots);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TinkerSmeltery.tableMaterialSerializer.get();
        }
    }

    public static class Basin
    extends MaterialCastingRecipe {
        public Basin(ResourceLocation id, String group, Ingredient cast, int itemCost, IMaterialItem result, boolean consumed, boolean switchSlots) {
            super((RecipeType)TinkerRecipeTypes.CASTING_BASIN.get(), id, group, cast, itemCost, result, consumed, switchSlots);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TinkerSmeltery.basinMaterialSerializer.get();
        }
    }
}

