/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifiableItemUtil;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerToolActions;

public abstract class ModifiableLauncherItem
extends ProjectileWeaponItem
implements IModifiableDisplay {
    public static final TinkerDataCapability.TinkerDataKey<Float> DRAWSPEED = TConstruct.createKey("drawspeed");
    protected static final ResourceLocation KEY_DRAWTIME = TConstruct.getResource("drawtime");
    private final ToolDefinition toolDefinition;
    private ItemStack toolForRendering;

    public ModifiableLauncherItem(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties);
        this.toolDefinition = toolDefinition;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.m_6589_() && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int m_6473_() {
        return 0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ToolCapabilityProvider(stack);
    }

    public void m_142312_(CompoundTag nbt) {
        ToolStack.verifyTag((Item)this, nbt, this.getToolDefinition());
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        ToolStack.ensureInitialized(stack, this.getToolDefinition());
    }

    public boolean m_5812_(ItemStack stack) {
        return ModifierUtil.checkVolatileFlag(stack, SHINY);
    }

    public Rarity m_41460_(ItemStack stack) {
        int rarity = ModifierUtil.getVolatileInt(stack, RARITY);
        return Rarity.values()[Mth.m_14045_((int)rarity, (int)0, (int)3)];
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return IndestructibleItemEntity.hasCustomEntity(stack);
    }

    public Entity createEntity(Level world, Entity original, ItemStack stack) {
        return IndestructibleItemEntity.createFrom(world, original, stack);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_41465_() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        if (!this.m_41465_()) {
            return 0;
        }
        ToolStack tool = ToolStack.from(stack);
        int durability = tool.getStats().getInt(ToolStats.DURABILITY);
        return tool.isBroken() ? durability + 1 : durability;
    }

    public int getDamage(ItemStack stack) {
        if (!this.m_41465_()) {
            return 0;
        }
        return ToolStack.from(stack).getDamage();
    }

    public void setDamage(ItemStack stack, int damage) {
        if (this.m_41465_()) {
            ToolStack.from(stack).setDamage(damage);
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T damager, Consumer<T> onBroken) {
        ToolDamageUtil.handleDamageItem(stack, amount, damager, onBroken);
        return 0;
    }

    public boolean m_142522_(ItemStack pStack) {
        return ToolDamageUtil.showDurabilityBar(pStack);
    }

    public int m_142159_(ItemStack pStack) {
        return ToolDamageUtil.getRGBDurabilityForDisplay(pStack);
    }

    public int m_142158_(ItemStack pStack) {
        return ToolDamageUtil.getDamageForDisplay(pStack);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ModifiableItemUtil.heldInventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity target) {
        return EntityInteractionModifierHook.leftClickEntity(stack, player, target);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ModifierUtil.canPerformAction(ToolStack.from(stack), toolAction);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(IToolStackView tool, EquipmentSlot slot) {
        return ModifiableItemUtil.getMeleeAttributeModifiers(tool, slot);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || slot.m_20743_() != EquipmentSlot.Type.HAND) {
            return ImmutableMultimap.of();
        }
        return this.getAttributeModifiers(ToolStack.from(stack), slot);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return !ToolDamageUtil.isBroken(stack) && this.toolDefinition.getData().canPerformAction(TinkerToolActions.SHIELD_DISABLE);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public abstract UseAnim m_6164_(ItemStack var1);

    public Component m_7626_(ItemStack stack) {
        return TooltipUtil.getDisplayName(stack, this.getToolDefinition());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        TooltipUtil.addInformation((IModifiableDisplay)this, stack, level, tooltip, SafeClientAccess.getTooltipKey(), flag);
    }

    public int getDefaultTooltipHideFlags(ItemStack stack) {
        return TooltipUtil.getModifierHideFlags(this.getToolDefinition());
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            ToolBuildHandler.addDefaultSubItems(this, items, new MaterialVariantId[0]);
        }
    }

    @Override
    public ItemStack getRenderTool() {
        if (this.toolForRendering == null) {
            this.toolForRendering = ToolBuildHandler.buildToolForRendering((Item)this, this.getToolDefinition());
        }
        return this.toolForRendering;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return this.shouldCauseReequipAnimation(oldStack, newStack, false);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return ModifiableItemUtil.shouldCauseReequip(oldStack, newStack, slotChanged);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return ToolHarvestLogic.isEffective(ToolStack.from(stack), state);
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return ToolHarvestLogic.mineBlock(stack, worldIn, state, pos, entityLiving);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return ToolHarvestLogic.getDestroySpeed(stack, state);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        return ToolHarvestLogic.handleBlockBreak(stack, pos, player);
    }

    protected static float getAngleStart(int count) {
        return -5 * (count - 1);
    }

    @Override
    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }
}

