/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.client;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.client.data.util.ResourceManagerSpriteReader;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoJson;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.DynamicTextureLoader;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.shared.network.GeneratePartTexturesPacket;

public class ClientGeneratePartTexturesCommand {
    private static final Logger log = LogManager.getLogger(ClientGeneratePartTexturesCommand.class);
    private static final String SUCCESS_KEY = TConstruct.makeTranslationKey("command", "generate_part_textures.finish");
    private static final Component NO_PARTS = TConstruct.makeTranslation("command", "generate_part_textures.no_parts");
    private static final Component NO_MATERIALS = TConstruct.makeTranslation("command", "generate_part_textures.no_materials");
    private static final String PACK_NAME = "TinkersConstructGeneratedPartTextures";
    private static final String GENERATOR_PART_TEXTURES = "tinkering/generator_part_textures.json";

    protected static Component getOutputComponent(File file) {
        return new TextComponent(file.getAbsolutePath()).m_130938_(style -> style.setUnderlined(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
    }

    public static void generateTextures(GeneratePartTexturesPacket.Operation operation, String modId, String materialPath) {
        long time = System.nanoTime();
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        MaterialPartTextureGenerator.runCallbacks(null, manager);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        List<AbstractPartSpriteProvider.PartSpriteInfo> partSprites = ClientGeneratePartTexturesCommand.loadPartSprites(manager);
        if (partSprites.isEmpty()) {
            if (player != null) {
                player.m_5661_(NO_PARTS, false);
            }
            return;
        }
        Predicate<MaterialVariantId> validMaterialId = loc -> !(!modId.isEmpty() && !modId.equals(loc.getId().m_135827_()) || !materialPath.isEmpty() && !materialPath.equals(loc.getId().m_135815_()));
        List<AbstractMaterialSpriteProvider.MaterialSpriteInfo> materialSprites = ClientGeneratePartTexturesCommand.loadMaterialRenderInfoGenerators(manager, validMaterialId);
        if (materialSprites.isEmpty()) {
            if (player != null) {
                player.m_5661_(NO_MATERIALS, false);
            }
            return;
        }
        Path path = Minecraft.m_91087_().m_91101_().toPath().resolve(PACK_NAME);
        BiConsumer<ResourceLocation, NativeImage> saver = (outputPath, image) -> ClientGeneratePartTexturesCommand.saveImage(path, outputPath, image);
        ClientGeneratePartTexturesCommand.savePackMcmeta(path);
        ResourceManagerSpriteReader spriteReader = new ResourceManagerSpriteReader(manager, "textures");
        MutableInt generated = new MutableInt(0);
        Predicate<ResourceLocation> shouldGenerate = operation == GeneratePartTexturesPacket.Operation.ALL ? exists -> {
            generated.add(1);
            return true;
        } : loc -> {
            if (!spriteReader.exists((ResourceLocation)loc)) {
                generated.add(1);
                return true;
            }
            return false;
        };
        for (AbstractMaterialSpriteProvider.MaterialSpriteInfo material : materialSprites) {
            for (AbstractPartSpriteProvider.PartSpriteInfo part : partSprites) {
                if (!material.supportStatType(part.getStatType())) continue;
                MaterialPartTextureGenerator.generateSprite(spriteReader, material, part, shouldGenerate, saver);
            }
        }
        spriteReader.closeAll();
        DynamicTextureLoader.clearCache();
        long deltaTime = System.nanoTime() - time;
        int count = generated.getValue();
        MaterialPartTextureGenerator.runCallbacks(null, null);
        log.info("Finished generating {} textures in {} ms", (Object)count, (Object)Float.valueOf((float)deltaTime / 1000000.0f));
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent(SUCCESS_KEY, new Object[]{count, Float.valueOf((float)(deltaTime / 1000000L) / 1000.0f), ClientGeneratePartTexturesCommand.getOutputComponent(path.toFile())}), false);
        }
    }

    private static void savePackMcmeta(Path folder) {
        Path path = folder.resolve("pack.mcmeta");
        JsonObject meta = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", "Generated Resources from the Tinkers' Construct Part Texture Generator");
        pack.addProperty("pack_format", (Number)8);
        meta.add("pack", (JsonElement)pack);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String json = MaterialRenderInfoLoader.GSON.toJson((JsonElement)meta);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                bufferedwriter.write(json);
            }
        }
        catch (IOException e) {
            log.error("Couldn't create pack.mcmeta for part textures", (Throwable)e);
        }
    }

    private static void saveImage(Path folder, ResourceLocation location, NativeImage image) {
        Path path = folder.resolve(Paths.get(PackType.CLIENT_RESOURCES.m_10305_(), location.m_135827_(), "textures", location.m_135815_() + ".png"));
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            image.m_85066_(path);
        }
        catch (IOException e) {
            log.error("Couldn't create image for {}", (Object)location, (Object)e);
        }
    }

    private static List<AbstractPartSpriteProvider.PartSpriteInfo> loadPartSprites(ResourceManager manager) {
        ImmutableList.Builder builder = ImmutableList.builder();
        block9: for (String namespace : manager.m_7187_()) {
            ResourceLocation location = new ResourceLocation(namespace, GENERATOR_PART_TEXTURES);
            if (!manager.m_7165_(location)) continue;
            try {
                List resources = manager.m_7396_(location);
                for (int r = resources.size() - 1; r >= 0; --r) {
                    Resource resource = (Resource)resources.get(r);
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8));
                        try {
                            JsonObject object = GsonHelper.m_13859_((Reader)reader);
                            List parts = JsonHelper.parseList((JsonObject)object, (String)"parts", (element, name) -> {
                                JsonObject part = GsonHelper.m_13918_((JsonElement)element, (String)name);
                                ResourceLocation path = JsonHelper.getResourceLocation((JsonObject)part, (String)"path");
                                MaterialStatsId statId = new MaterialStatsId(JsonHelper.getResourceLocation((JsonObject)part, (String)"statType"));
                                return new AbstractPartSpriteProvider.PartSpriteInfo(path, statId);
                            });
                            builder.addAll((Iterable)parts);
                            if (!GsonHelper.m_13855_((JsonObject)object, (String)"replace", (boolean)false)) continue;
                            continue block9;
                        }
                        finally {
                            reader.close();
                            continue block9;
                        }
                    }
                    catch (IOException ex) {
                        log.error("Failed to load modifier models from {} for pack {}", (Object)location, (Object)resource.m_7816_(), (Object)ex);
                    }
                }
            }
            catch (IOException ex) {
                log.error("Failed to load modifier models from {}", (Object)location, (Object)ex);
            }
        }
        return builder.build();
    }

    private static List<AbstractMaterialSpriteProvider.MaterialSpriteInfo> loadMaterialRenderInfoGenerators(ResourceManager manager, Predicate<MaterialVariantId> validMaterialId) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int trim = "tinkering/materials".length() + 1;
        for (ResourceLocation location : manager.m_6540_("tinkering/materials", loc -> loc.endsWith(".json"))) {
            MaterialVariantId id;
            String path = location.m_135815_();
            String localPath = path.substring(trim, path.length() - 5);
            String variant = "";
            int slashIndex = localPath.lastIndexOf(47);
            if (slashIndex >= 0) {
                variant = localPath.substring(slashIndex + 1);
                localPath = localPath.substring(0, slashIndex);
            }
            if (!validMaterialId.test(id = MaterialVariantId.create(location.m_135827_(), localPath, variant))) continue;
            try {
                Resource iresource = manager.m_142591_(location);
                try {
                    InputStream inputstream = iresource.m_6679_();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                        MaterialRenderInfoJson json = (MaterialRenderInfoJson)MaterialRenderInfoLoader.GSON.fromJson((Reader)reader, MaterialRenderInfoJson.class);
                        MaterialRenderInfoJson.MaterialGeneratorJson generator = json.getGenerator();
                        if (generator == null) continue;
                        builder.add((Object)new AbstractMaterialSpriteProvider.MaterialSpriteInfo(Objects.requireNonNullElse(json.getTexture(), id.getLocation('_')), Objects.requireNonNullElse(json.getFallbacks(), new String[0]), generator));
                    }
                    finally {
                        if (inputstream == null) continue;
                        inputstream.close();
                    }
                }
                finally {
                    if (iresource == null) continue;
                    iresource.close();
                }
            }
            catch (JsonSyntaxException e) {
                log.error("Failed to read tool part texture generator info for {}", (Object)id, (Object)e);
            }
            catch (Exception exception) {}
        }
        return builder.build();
    }
}

