/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.inventory;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.tconstruct.TConstruct;

public class BlockContainerOpenedTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = TConstruct.getResource("block_container_opened");

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected Instance createInstance(JsonObject json, EntityPredicate.Composite entityPredicate, DeserializationContext conditionsParser) {
        ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"type"));
        BlockEntityType type = (BlockEntityType)ForgeRegistries.BLOCK_ENTITIES.getValue(id);
        if (type == null) {
            throw new JsonSyntaxException("Unknown tile entity '" + id + "'");
        }
        return new Instance(entityPredicate, type);
    }

    public void trigger(@Nullable BlockEntity tileEntity, @Nullable Inventory inv) {
        if (tileEntity != null && inv != null && inv.f_35978_ instanceof ServerPlayer) {
            this.m_66234_((ServerPlayer)inv.f_35978_, instance -> instance.test(tileEntity.m_58903_()));
        }
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final BlockEntityType<?> type;

        public Instance(EntityPredicate.Composite playerCondition, BlockEntityType<?> type) {
            super(ID, playerCondition);
            this.type = type;
        }

        public static Instance container(BlockEntityType<?> type) {
            return new Instance(EntityPredicate.Composite.f_36667_, type);
        }

        public boolean test(BlockEntityType<?> type) {
            return this.type == type;
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject json = super.m_7683_(conditions);
            json.addProperty("type", Objects.requireNonNull(this.type.getRegistryName()).toString());
            return json;
        }
    }
}

