/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.tools.TinkerTools;

public class CrystalshotItem
extends ArrowItem {
    public static final List<String> RANDOM_VARIANTS = new ArrayList<String>();
    private static final String TAG_VARIANT = "variant";

    public CrystalshotItem(Item.Properties props) {
        super(props);
    }

    public AbstractArrow m_6394_(Level pLevel, ItemStack pStack, LivingEntity pShooter) {
        CrystalshotEntity arrow = new CrystalshotEntity(pLevel, pShooter);
        String variant = "random";
        CompoundTag tag = pStack.m_41783_();
        if (tag != null) {
            variant = tag.m_128461_(TAG_VARIANT);
        }
        if ("random".equals(variant)) {
            variant = RANDOM_VARIANTS.get(pShooter.m_21187_().nextInt(RANDOM_VARIANTS.size()));
        }
        arrow.setVariant(variant);
        return arrow;
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, Player player) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)bow) > 0;
    }

    public void m_6787_(CreativeModeTab pCategory, NonNullList<ItemStack> pItems) {
    }

    public static ItemStack withVariant(String variant, int size) {
        ItemStack stack = new ItemStack(TinkerTools.crystalshotItem);
        stack.m_41764_(size);
        stack.m_41784_().m_128359_(TAG_VARIANT, variant);
        return stack;
    }

    static {
        RANDOM_VARIANTS.add("amethyst");
        RANDOM_VARIANTS.add("earthslime");
        RANDOM_VARIANTS.add("skyslime");
        RANDOM_VARIANTS.add("ichor");
        RANDOM_VARIANTS.add("enderslime");
        RANDOM_VARIANTS.add("quartz");
    }

    public static class CrystalshotEntity
    extends AbstractArrow {
        private static final EntityDataAccessor<String> SYNC_VARIANT = SynchedEntityData.m_135353_(CrystalshotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

        public CrystalshotEntity(EntityType<? extends CrystalshotEntity> type, Level level) {
            super(type, level);
            this.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            this.f_36700_ = Sounds.CRYSTALSHOT.getSound();
        }

        public CrystalshotEntity(Level level, LivingEntity shooter) {
            super((EntityType)TinkerTools.crystalshotEntity.get(), shooter, level);
            this.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            this.f_36700_ = Sounds.CRYSTALSHOT.getSound();
        }

        public void m_36740_(SoundEvent sound) {
            if (sound != SoundEvents.f_11685_ && sound != SoundEvents.f_11840_) {
                super.m_36740_(sound);
            }
        }

        protected void m_8097_() {
            super.m_8097_();
            this.f_19804_.m_135372_(SYNC_VARIANT, (Object)"");
        }

        public String getVariant() {
            String variant = (String)this.f_19804_.m_135370_(SYNC_VARIANT);
            if (variant.isEmpty()) {
                return "amethyst";
            }
            return variant;
        }

        public void setVariant(String variant) {
            this.f_19804_.m_135381_(SYNC_VARIANT, (Object)variant);
        }

        public ItemStack m_7941_() {
            return CrystalshotItem.withVariant(this.getVariant(), 1);
        }

        public void m_7380_(CompoundTag tag) {
            super.m_7380_(tag);
            tag.m_128359_(CrystalshotItem.TAG_VARIANT, this.getVariant());
        }

        public void m_7378_(CompoundTag tag) {
            super.m_7378_(tag);
            this.setVariant(tag.m_128461_(CrystalshotItem.TAG_VARIANT));
        }
    }
}

