/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.modifiers.upgrades.general.ReinforcedModifier;

public class TemperateModifier
extends Modifier
implements ConditionalStatModifierHook {
    private static final float BASELINE_TEMPERATURE = 0.75f;
    private static final float MAX_MINING_BOOST = 7.5f;
    private static final float MAX_DRAWSPEED_BOOST = 0.15f;
    private static final Component SPEED = TConstruct.makeTranslation("modifier", "temperate.speed");
    private static final Component REINFORCED = TConstruct.makeTranslation("modifier", "temperate.reinforced");

    private static float getBonus(LivingEntity living, BlockPos pos, int level) {
        return (((Biome)living.f_19853_.m_204166_(pos).m_203334_()).m_47505_(pos) - 0.75f) * (float)level / 1.25f;
    }

    @Override
    public int onDamageTool(IToolStackView tool, int level, int amount, @Nullable LivingEntity holder) {
        float bonus;
        if (holder != null && (bonus = TemperateModifier.getBonus(holder, holder.m_142538_(), level)) > 0.0f) {
            return ReinforcedModifier.damageReinforced(amount, ReinforcedModifier.diminishingPercent(bonus * 2.0f));
        }
        return amount;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        float bonus;
        if (isEffective && (bonus = TemperateModifier.getBonus((LivingEntity)event.getPlayer(), event.getPos(), level)) < 0.0f) {
            event.setNewSpeed(event.getNewSpeed() - bonus * 7.5f * tool.getMultiplier(ToolStats.MINING_SPEED) * miningSpeedModifier);
        }
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        float bonus;
        if (stat == ToolStats.DRAW_SPEED && (bonus = TemperateModifier.getBonus(living, living.m_142538_(), modifier.getLevel())) < 0.0f) {
            baseValue -= bonus * 0.15f * multiplier;
        }
        return baseValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (harvest || tool.hasTag(TinkerTags.Items.RANGED)) {
            float bonus = player != null && key == TooltipKey.SHIFT ? TemperateModifier.getBonus((LivingEntity)player, player.m_142538_(), level) : (float)(-level);
            if (bonus < -0.01f) {
                if (harvest) {
                    this.addFlatBoost(SPEED, -bonus * tool.getMultiplier(ToolStats.MINING_SPEED) * 7.5f, tooltip);
                } else {
                    this.addFlatBoost(SPEED, -bonus * tool.getMultiplier(ToolStats.DRAW_SPEED) * 0.15f, tooltip);
                }
            }
            if (bonus > 0.01f) {
                tooltip.add((Component)this.applyStyle(new TextComponent(Util.PERCENT_FORMAT.format(ReinforcedModifier.diminishingPercent(bonus * 2.0f)) + " ").m_7220_(REINFORCED)));
            }
        }
    }
}

