/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import quek.undergarden.entity.Minion;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;

public class CarvedGloomgourdBlock
extends CarvedPumpkinBlock {
    @Nullable
    private BlockPattern minionBasePattern;
    @Nullable
    private BlockPattern minionPattern;

    public CarvedGloomgourdBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private BlockPattern getMinionBasePattern() {
        if (this.minionBasePattern == null) {
            this.minionBasePattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{" ", "#"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)UGBlocks.FORGOTTEN_BLOCK.get())))).m_61249_();
        }
        return this.minionBasePattern;
    }

    private BlockPattern getMinionPattern() {
        if (this.minionPattern == null) {
            this.minionPattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"^", "#"}).m_61244_('^', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)UGBlocks.CARVED_GLOOMGOURD.get())))).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)UGBlocks.FORGOTTEN_BLOCK.get())))).m_61249_();
        }
        return this.minionPattern;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.trySpawnMinion(worldIn, pos);
        }
    }

    public boolean m_51381_(LevelReader reader, BlockPos pos) {
        return this.getMinionBasePattern().m_61184_(reader, pos) != null;
    }

    private void trySpawnMinion(Level world, BlockPos pos) {
        BlockPattern.BlockPatternMatch minionPattern = this.getMinionPattern().m_61184_((LevelReader)world, pos);
        if (minionPattern != null) {
            for (int i = 0; i < this.getMinionPattern().m_61202_(); ++i) {
                BlockInWorld cachedblockinfo = minionPattern.m_61229_(0, i, 0);
                world.m_7731_(cachedblockinfo.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                world.m_46796_(2001, cachedblockinfo.m_61176_(), Block.m_49956_((BlockState)cachedblockinfo.m_61168_()));
            }
            Minion minionEntity = (Minion)((EntityType)UGEntityTypes.MINION.get()).m_20615_(world);
            BlockPos blockpos1 = minionPattern.m_61229_(0, 2, 0).m_61176_();
            minionEntity.m_7678_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 1.0, (double)blockpos1.m_123343_() + 0.5, 0.0f, 0.0f);
            world.m_7967_((Entity)minionEntity);
            for (ServerPlayer serverplayerentity : world.m_45976_(ServerPlayer.class, minionEntity.m_142469_().m_82400_(5.0))) {
                CriteriaTriggers.f_10580_.m_68256_(serverplayerentity, (Entity)minionEntity);
            }
            for (int l = 0; l < this.getMinionPattern().m_61202_(); ++l) {
                BlockInWorld cachedblockinfo3 = minionPattern.m_61229_(0, l, 0);
                world.m_6289_(cachedblockinfo3.m_61176_(), Blocks.f_50016_);
            }
        }
    }
}

