/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.LocationTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlacedBlockTrigger;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.advancements.critereon.SummonedEntityTrigger;
import net.minecraft.advancements.critereon.TickTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import quek.undergarden.criterion.SlingshotFireTrigger;
import quek.undergarden.criterion.StonebornTradeTrigger;
import quek.undergarden.registry.UGBiomes;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGStructures;

public class UndergardenAdvancements
implements Consumer<Consumer<Advancement>> {
    private static final List<ResourceKey<Biome>> UNDERGARDEN_BIOMES = ImmutableList.of(UGBiomes.ANCIENT_SEA, UGBiomes.BARREN_ABYSS, UGBiomes.DEAD_SEA, UGBiomes.DENSE_FOREST, UGBiomes.FORGOTTEN_FIELD, UGBiomes.FROSTFIELDS, UGBiomes.GRONGLEGROWTH, UGBiomes.ICY_SEA, UGBiomes.MUSHROOM_BOG, UGBiomes.SMOG_SPIRES, UGBiomes.SMOGSTEM_FOREST, UGBiomes.WIGGLEWOOD_FOREST, (Object[])new ResourceKey[0]);

    @Override
    public void accept(Consumer<Advancement> consumer) {
        Advancement root = Advancement.Builder.m_138353_().m_138371_((ItemLike)UGBlocks.DEEPTURF_BLOCK.get(), (Component)new TranslatableComponent("advancement.undergarden.root.title"), (Component)new TranslatableComponent(""), new ResourceLocation("undergarden", "textures/block/depthrock_bricks.png"), FrameType.TASK, false, false, false).m_138386_("tick", (CriterionTriggerInstance)new TickTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_)).m_138389_(consumer, "undergarden:undergarden/root");
        Advancement catalyst = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)UGItems.CATALYST.get(), (Component)new TranslatableComponent("advancement.undergarden.catalyst.title"), (Component)new TranslatableComponent("advancement.undergarden.catalyst.desc"), null, FrameType.TASK, true, true, false).m_138386_("has_catalyst", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.CATALYST.get()})).m_138389_(consumer, "undergarden:undergarden/catalyst");
        Advancement enter_undergarden = Advancement.Builder.m_138353_().m_138398_(catalyst).m_138371_((ItemLike)UGBlocks.DEEPTURF_BLOCK.get(), (Component)new TranslatableComponent("advancement.undergarden.enter_undergarden.title"), (Component)new TranslatableComponent("advancement.undergarden.enter_undergarden.desc"), null, FrameType.TASK, true, true, false).m_138386_("enter_undergarden", (CriterionTriggerInstance)ChangeDimensionTrigger.TriggerInstance.m_19782_(UGDimensions.UNDERGARDEN_LEVEL)).m_138389_(consumer, "undergarden:undergarden/enter_undergarden");
        Advancement slingshot = Advancement.Builder.m_138353_().m_138398_(enter_undergarden).m_138371_((ItemLike)UGItems.SLINGSHOT.get(), (Component)new TranslatableComponent("advancement.undergarden.slingshot.title"), (Component)new TranslatableComponent("advancement.undergarden.slingshot.desc"), null, FrameType.TASK, true, true, false).m_138386_("has_slingshot", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.SLINGSHOT.get()})).m_138389_(consumer, "undergarden:undergarden/slingshot");
        Advancement shoot_slingshot = Advancement.Builder.m_138353_().m_138398_(slingshot).m_138371_((ItemLike)UGItems.DEPTHROCK_PEBBLE.get(), (Component)new TranslatableComponent("advancement.undergarden.shoot_slingshot.title"), (Component)new TranslatableComponent("advancement.undergarden.shoot_slingshot.desc"), null, FrameType.TASK, true, true, false).m_138386_("shoot_slingshot", (CriterionTriggerInstance)SlingshotFireTrigger.TriggerInstance.shotItem((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).m_138389_(consumer, "undergarden:undergarden/shoot_slingshot");
        Advancement shoot_slingshot_goo = Advancement.Builder.m_138353_().m_138398_(slingshot).m_138371_((ItemLike)UGItems.GOO_BALL.get(), (Component)new TranslatableComponent("advancement.undergarden.shoot_slingshot_goo.title"), (Component)new TranslatableComponent("advancement.undergarden.shoot_slingshot_goo.desc"), null, FrameType.TASK, true, true, false).m_138386_("shoot_slingshot_goo", (CriterionTriggerInstance)SlingshotFireTrigger.TriggerInstance.shotItem((ItemLike)UGItems.GOO_BALL.get())).m_138389_(consumer, "undergarden:undergarden/shoot_slingshot_goo");
        Advancement shoot_slingshot_rotten_blisterberry = Advancement.Builder.m_138353_().m_138398_(slingshot).m_138371_((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get(), (Component)new TranslatableComponent("advancement.undergarden.shoot_slingshot_rotten_blisterberry.title"), (Component)new TranslatableComponent("advancement.undergarden.shoot_slingshot_rotten_blisterberry.desc"), null, FrameType.TASK, true, true, false).m_138386_("shoot_slingshot_rotten_blisterberry", (CriterionTriggerInstance)SlingshotFireTrigger.TriggerInstance.shotItem((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get())).m_138389_(consumer, "undergarden:undergarden/shoot_slingshot_rotten_blisterberry");
        Advancement slingshot_20_damage = Advancement.Builder.m_138353_().m_138398_(shoot_slingshot).m_138371_((ItemLike)UGItems.DEPTHROCK_PEBBLE.get(), (Component)new TranslatableComponent("advancement.undergarden.slingshot_20_damage.title"), (Component)new TranslatableComponent("advancement.undergarden.slingshot_20_damage.desc"), null, FrameType.CHALLENGE, true, true, false).m_138386_("20_damage", (CriterionTriggerInstance)PlayerHurtEntityTrigger.TriggerInstance.m_60149_((DamagePredicate.Builder)DamagePredicate.Builder.m_24931_().m_148145_(MinMaxBounds.Doubles.m_154804_((double)20.0)).m_24932_(DamageSourcePredicate.Builder.m_25471_().m_25472_(EntityPredicate.Builder.m_36633_().m_36636_((EntityType)UGEntityTypes.DEPTHROCK_PEBBLE.get()))))).m_138389_(consumer, "undergarden:undergarden/slingshot_20_damage");
        Advancement shoot_slingshot_gronglet = Advancement.Builder.m_138353_().m_138398_(slingshot).m_138371_((ItemLike)UGBlocks.GRONGLET.get(), (Component)new TranslatableComponent("advancement.undergarden.shoot_slingshot_gronglet.title"), (Component)new TranslatableComponent("advancement.undergarden.shoot_slingshot_gronglet.desc"), null, FrameType.TASK, true, true, false).m_138386_("shoot_slingshot_gronglet", (CriterionTriggerInstance)SlingshotFireTrigger.TriggerInstance.shotItem((ItemLike)UGBlocks.GRONGLET.get())).m_138389_(consumer, "undergarden:undergarden/shoot_slingshot_gronglet");
        Advancement underbeans = Advancement.Builder.m_138353_().m_138398_(enter_undergarden).m_138371_((ItemLike)UGItems.UNDERBEANS.get(), (Component)new TranslatableComponent("advancement.undergarden.underbeans.title"), (Component)new TranslatableComponent("advancement.undergarden.underbeans.desc"), null, FrameType.TASK, true, true, false).m_138386_("has_underbeans", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.UNDERBEANS.get()})).m_138389_(consumer, "undergarden:undergarden/underbeans");
        Advancement stoneborn_trade = Advancement.Builder.m_138353_().m_138398_(enter_undergarden).m_138371_((ItemLike)UGItems.REGALIUM_CRYSTAL.get(), (Component)new TranslatableComponent("advancement.undergarden.stoneborn_trade.title"), (Component)new TranslatableComponent("advancement.undergarden.stoneborn_trade.desc"), null, FrameType.TASK, true, true, false).m_138386_("trade_with_stoneborn", (CriterionTriggerInstance)StonebornTradeTrigger.TriggerInstance.tradeWithStoneborn()).m_138389_(consumer, "undergarden:undergarden/stoneborn_trade");
        Advancement mine_ore = Advancement.Builder.m_138353_().m_138398_(enter_undergarden).m_138371_((ItemLike)UGItems.RAW_CLOGGRUM.get(), (Component)new TranslatableComponent("advancement.undergarden.mine_ore.title"), (Component)new TranslatableComponent("advancement.undergarden.mine_ore.desc"), null, FrameType.TASK, true, true, false).m_138360_(RequirementsStrategy.f_15979_).m_138386_("has_raw_cloggrum", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.RAW_CLOGGRUM.get()})).m_138386_("has_raw_froststeel", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.RAW_FROSTSTEEL.get()})).m_138386_("has_utherium", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.UTHERIUM_CRYSTAL.get()})).m_138386_("has_regalium_crystal", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.REGALIUM_CRYSTAL.get()})).m_138386_("has_depthrock_cloggrum", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.DEPTHROCK_CLOGGRUM_ORE.get()})).m_138386_("has_shiverstone_cloggrum", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.SHIVERSTONE_CLOGGRUM_ORE.get()})).m_138386_("has_shiverstone_froststeel", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.SHIVERSTONE_FROSTSTEEL_ORE.get()})).m_138386_("has_depthrock_utherium", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.DEPTHROCK_UTHERIUM_ORE.get()})).m_138386_("has_shiverstone_utherium", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.SHIVERSTONE_UTHERIUM_ORE.get()})).m_138386_("has_depthrock_regalium", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.DEPTHROCK_REGALIUM_ORE.get()})).m_138386_("has_shiverstone_regalium", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.SHIVERSTONE_REGALIUM_ORE.get()})).m_138389_(consumer, "undergarden:undergarden/mine_ore");
        Advancement all_ore_blocks = Advancement.Builder.m_138353_().m_138398_(mine_ore).m_138371_((ItemLike)UGBlocks.REGALIUM_BLOCK.get(), (Component)new TranslatableComponent("advancement.undergarden.all_ore_blocks.title"), (Component)new TranslatableComponent("advancement.undergarden.all_ore_blocks.desc"), null, FrameType.CHALLENGE, true, true, false).m_138386_("has_all_ore_blocks", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.CLOGGRUM_BLOCK.get(), (ItemLike)UGBlocks.FROSTSTEEL_BLOCK.get(), (ItemLike)UGBlocks.UTHERIUM_BLOCK.get(), (ItemLike)UGBlocks.REGALIUM_BLOCK.get()})).m_138389_(consumer, "undergarden:undergarden/all_ore_blocks");
        Advancement cloggrum_armor = Advancement.Builder.m_138353_().m_138398_(mine_ore).m_138371_((ItemLike)UGItems.CLOGGRUM_CHESTPLATE.get(), (Component)new TranslatableComponent("advancement.undergarden.cloggrum_armor.title"), (Component)new TranslatableComponent("advancement.undergarden.cloggrum_armor.desc"), null, FrameType.GOAL, true, true, false).m_138386_("has_cloggrum_armor", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.CLOGGRUM_HELMET.get(), (ItemLike)UGItems.CLOGGRUM_CHESTPLATE.get(), (ItemLike)UGItems.CLOGGRUM_LEGGINGS.get(), (ItemLike)UGItems.CLOGGRUM_BOOTS.get()})).m_138389_(consumer, "undergarden:undergarden/cloggrum_armor");
        UndergardenAdvancements.addBiomes(Advancement.Builder.m_138353_(), UNDERGARDEN_BIOMES).m_138398_(enter_undergarden).m_138371_((ItemLike)UGItems.CLOGGRUM_BOOTS.get(), (Component)new TranslatableComponent("advancement.undergarden.all_undergarden_biomes.title"), (Component)new TranslatableComponent("advancement.undergarden.all_undergarden_biomes.desc"), null, FrameType.CHALLENGE, true, true, false).m_138389_(consumer, "undergarden:undergarden/all_undergarden_biomes");
        Advancement plant_gloomgourd = Advancement.Builder.m_138353_().m_138398_(enter_undergarden).m_138371_((ItemLike)UGItems.GLOOMGOURD_SEEDS.get(), (Component)new TranslatableComponent("advancement.undergarden.plant_gloomgourd.title"), (Component)new TranslatableComponent("advancement.undergarden.plant_gloomgourd.desc"), null, FrameType.TASK, true, true, false).m_138386_("plant_gloomgourd", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)UGBlocks.GLOOMGOURD_STEM.get()))).m_138389_(consumer, "undergarden:undergarden/plant_gloomgourd");
        Advancement stack_of_gloomgourds = Advancement.Builder.m_138353_().m_138398_(plant_gloomgourd).m_138371_((ItemLike)UGBlocks.GLOOMGOURD.get(), (Component)new TranslatableComponent("advancement.undergarden.stack_of_gloomgourds.title"), (Component)new TranslatableComponent("advancement.undergarden.stack_of_gloomgourds.desc"), null, FrameType.GOAL, true, true, true).m_138386_("has_64_gloomgourds", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)UGBlocks.GLOOMGOURD.get()}).m_151443_(MinMaxBounds.Ints.m_55371_((int)64)).m_45077_()})).m_138389_(consumer, "undergarden:undergarden/stack_of_gloomgourds");
        Advancement catch_gwibling = Advancement.Builder.m_138353_().m_138398_(enter_undergarden).m_138371_((ItemLike)UGItems.GWIBLING_BUCKET.get(), (Component)new TranslatableComponent("advancement.undergarden.catch_gwibling.title"), (Component)new TranslatableComponent("advancement.undergarden.catch_gwibling.desc"), null, FrameType.TASK, true, true, false).m_138386_("has_gwibling_bucket", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.GWIBLING_BUCKET.get()})).m_138389_(consumer, "undergarden:undergarden/catch_gwibling");
        Advancement kill_rotling = Advancement.Builder.m_138353_().m_138398_(enter_undergarden).m_138371_((ItemLike)UGItems.UTHERIC_SHARD.get(), (Component)new TranslatableComponent("advancement.undergarden.kill_rotling.title"), (Component)new TranslatableComponent("advancement.undergarden.kill_rotling.desc"), null, FrameType.TASK, true, true, false).m_138386_("kill_rotling", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_152108_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)UGEntityTypes.ROTLING.get()).m_36662_())).m_138389_(consumer, "undergarden:undergarden/kill_rotling");
        Advancement shard_torch = Advancement.Builder.m_138353_().m_138398_(kill_rotling).m_138371_((ItemLike)UGBlocks.SHARD_TORCH.get(), (Component)new TranslatableComponent("advancement.undergarden.shard_torch.title"), (Component)new TranslatableComponent("advancement.undergarden.shard_torch.desc"), null, FrameType.TASK, true, true, false).m_138386_("has_shard_torch", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.SHARD_TORCH.get()})).m_138389_(consumer, "undergarden:undergarden/shard_torch");
        Advancement kill_all_rotspawn = Advancement.Builder.m_138353_().m_138398_(kill_rotling).m_138371_((ItemLike)UGItems.UTHERIUM_SWORD.get(), (Component)new TranslatableComponent("advancement.undergarden.kill_all_rotspawn.title"), (Component)new TranslatableComponent("advancement.undergarden.kill_all_rotspawn.desc"), null, FrameType.CHALLENGE, true, true, false).m_138360_(RequirementsStrategy.f_15978_).m_138386_("kill_rotling", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_152108_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)UGEntityTypes.ROTLING.get()).m_36662_())).m_138386_("kill_rotwalker", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_152108_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)UGEntityTypes.ROTWALKER.get()).m_36662_())).m_138386_("kill_rotbeast", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_152108_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)UGEntityTypes.ROTBEAST.get()).m_36662_())).m_138389_(consumer, "undergarden:undergarden/kill_all_rotspawn");
        Advancement kill_scintling = Advancement.Builder.m_138353_().m_138398_(enter_undergarden).m_138371_((ItemLike)UGItems.GOO_BALL.get(), (Component)new TranslatableComponent("advancement.undergarden.kill_scintling.title"), (Component)new TranslatableComponent("advancement.undergarden.kill_scintling.desc"), null, FrameType.TASK, true, true, true).m_138386_("kill_scintling", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_152108_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)UGEntityTypes.SCINTLING.get()).m_36662_())).m_138389_(consumer, "undergarden:undergarden/kill_scintling");
        Advancement catacombs = Advancement.Builder.m_138353_().m_138398_(enter_undergarden).m_138371_((ItemLike)UGBlocks.DEPTHROCK_BRICK_STAIRS.get(), (Component)new TranslatableComponent("advancement.undergarden.catacombs.title"), (Component)new TranslatableComponent("advancement.undergarden.catacombs.desc"), null, FrameType.TASK, true, true, false).m_138386_("enter_catacombs", (CriterionTriggerInstance)LocationTrigger.TriggerInstance.m_53670_((LocationPredicate)LocationPredicate.m_207928_(UGStructures.CATACOMBS_KEY))).m_138389_(consumer, "undergarden:undergarden/catacombs");
        Advancement kill_guardian = Advancement.Builder.m_138353_().m_138398_(catacombs).m_138371_((ItemLike)UGBlocks.FORGOTTEN_BLOCK.get(), (Component)new TranslatableComponent("advancement.undergarden.kill_forgotten_guardian.title"), (Component)new TranslatableComponent("advancement.undergarden.kill_forgotten_guardian.desc"), null, FrameType.GOAL, true, true, false).m_138386_("kill_forgotten_guardian", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_152108_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)UGEntityTypes.FORGOTTEN_GUARDIAN.get()).m_36662_())).m_138389_(consumer, "undergarden:undergarden/kill_forgotten_guardian");
        Advancement forgotten_ingot = Advancement.Builder.m_138353_().m_138398_(kill_guardian).m_138371_((ItemLike)UGItems.FORGOTTEN_INGOT.get(), (Component)new TranslatableComponent("advancement.undergarden.forgotten_ingot.title"), (Component)new TranslatableComponent("advancement.undergarden.forgotten_ingot.desc"), null, FrameType.TASK, true, true, false).m_138386_("has_forgotten_ingot", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.FORGOTTEN_INGOT.get()})).m_138389_(consumer, "undergarden:undergarden/forgotten_ingot");
        Advancement forgotten_tools = Advancement.Builder.m_138353_().m_138398_(forgotten_ingot).m_138371_((ItemLike)UGItems.FORGOTTEN_PICKAXE.get(), (Component)new TranslatableComponent("advancement.undergarden.forgotten_tools.title"), (Component)new TranslatableComponent("advancement.undergarden.forgotten_tools.desc"), null, FrameType.CHALLENGE, true, true, false).m_138386_("has_forgotten_tools", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.FORGOTTEN_BATTLEAXE.get(), (ItemLike)UGItems.FORGOTTEN_SWORD.get(), (ItemLike)UGItems.FORGOTTEN_PICKAXE.get(), (ItemLike)UGItems.FORGOTTEN_AXE.get(), (ItemLike)UGItems.FORGOTTEN_SHOVEL.get(), (ItemLike)UGItems.FORGOTTEN_HOE.get()})).m_138389_(consumer, "undergarden:undergarden/forgotten_tools");
        Advancement forgotten_battleaxe = Advancement.Builder.m_138353_().m_138398_(forgotten_ingot).m_138371_((ItemLike)UGItems.FORGOTTEN_BATTLEAXE.get(), (Component)new TranslatableComponent("advancement.undergarden.forgotten_battleaxe.title"), (Component)new TranslatableComponent("advancement.undergarden.forgotten_battleaxe.desc"), null, FrameType.CHALLENGE, true, true, false).m_138386_("has_forgotten_battleaxe", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.FORGOTTEN_BATTLEAXE.get()})).m_138389_(consumer, "undergarden:undergarden/forgotten_battleaxe");
        Advancement summon_minion = Advancement.Builder.m_138353_().m_138398_(forgotten_ingot).m_138371_((ItemLike)UGBlocks.CARVED_GLOOMGOURD.get(), (Component)new TranslatableComponent("advancement.undergarden.summon_minion.title"), (Component)new TranslatableComponent("advancement.undergarden.summon_minion.desc"), null, FrameType.GOAL, true, true, false).m_138386_("summoned_minion", (CriterionTriggerInstance)SummonedEntityTrigger.TriggerInstance.m_68275_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)UGEntityTypes.MINION.get()))).m_138389_(consumer, "undergarden:undergarden/summon_minion");
        Advancement gloomper_secret_disc = Advancement.Builder.m_138353_().m_138398_(enter_undergarden).m_138371_((ItemLike)UGItems.GLOOMPER_SECRET_DISC.get(), (Component)new TranslatableComponent("advancement.undergarden.gloomper_secret_disc.title"), (Component)new TranslatableComponent("advancement.undergarden.gloomper_secret_disc.desc"), null, FrameType.CHALLENGE, true, true, true).m_138386_("has_disc", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.GLOOMPER_SECRET_DISC.get()})).m_138389_(consumer, "undergarden:undergarden/gloomper_secret_disc");
    }

    protected static Advancement.Builder addBiomes(Advancement.Builder builder, List<ResourceKey<Biome>> biomes) {
        for (ResourceKey<Biome> resourcekey : biomes) {
            builder.m_138386_(resourcekey.m_135782_().toString(), (CriterionTriggerInstance)LocationTrigger.TriggerInstance.m_53670_((LocationPredicate)LocationPredicate.m_52634_(resourcekey)));
        }
        return builder;
    }
}

