/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data.provider;

import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class UGItemModelProvider
extends ItemModelProvider {
    public UGItemModelProvider(DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, "undergarden", fileHelper);
    }

    private String blockName(Supplier<? extends Block> block) {
        return block.get().getRegistryName().m_135815_();
    }

    private ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    public ItemModelBuilder itemFence(Supplier<? extends Block> block, String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/fence_inventory"))).texture("texture", "block/" + name);
    }

    public ItemModelBuilder block(Supplier<? extends Block> block) {
        return this.block(block, this.blockName(block));
    }

    public ItemModelBuilder block(Supplier<? extends Block> block, String name) {
        return (ItemModelBuilder)this.withExistingParent(this.blockName(block), this.modLoc("block/" + name));
    }

    public ItemModelBuilder blockFlat(Supplier<? extends Block> block) {
        return this.blockFlat(block, this.blockName(block));
    }

    public ItemModelBuilder blockFlat(Supplier<? extends Block> block, String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + name));
    }

    public ItemModelBuilder blockFlatWithItemName(Supplier<? extends Block> block, String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + name));
    }

    public ItemModelBuilder normalItem(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.get().getRegistryName().m_135815_(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + item.get().getRegistryName().m_135815_()));
    }

    public ItemModelBuilder torchItem(Supplier<? extends Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.get().getRegistryName().m_135815_(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + item.get().getRegistryName().m_135815_()));
    }

    public ItemModelBuilder toolItem(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.get().getRegistryName().m_135815_(), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + item.get().getRegistryName().m_135815_()));
    }

    public ItemModelBuilder rodItem(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.get().getRegistryName().m_135815_(), this.mcLoc("item/handheld_rod"))).texture("layer0", this.modLoc("item/" + item.get().getRegistryName().m_135815_()));
    }

    public ItemModelBuilder egg(Supplier<? extends Item> item) {
        return (ItemModelBuilder)this.withExistingParent(item.get().getRegistryName().m_135815_(), this.mcLoc("item/template_spawn_egg"));
    }

    public ItemModelBuilder sign(Supplier<? extends SignBlock> sign) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(sign), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + this.blockName(sign)));
    }

    public ItemModelBuilder wall(Supplier<? extends WallBlock> wall, Supplier<? extends Block> fullBlock) {
        return (ItemModelBuilder)this.wallInventory(wall.get().getRegistryName().m_135815_(), this.texture(this.blockName(fullBlock)));
    }
}

