/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data.provider;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.UpgradeRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SignBlock;
import net.minecraftforge.common.Tags;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGItems;

public class UGRecipeProvider
extends RecipeProvider {
    public UGRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public ShapelessRecipeBuilder makePlanks(Supplier<? extends Block> plankOut, TagKey<Item> logIn) {
        return ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)plankOut.get()), (int)4).m_206419_(logIn).m_142409_("planks").m_142284_("has_log", (CriterionTriggerInstance)UGRecipeProvider.m_206406_(logIn));
    }

    public ShapedRecipeBuilder makeDoor(Supplier<? extends Block> doorOut, Supplier<? extends Block> plankIn) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)doorOut.get()), (int)3).m_126130_("PP").m_126130_("PP").m_126130_("PP").m_126127_(Character.valueOf('P'), (ItemLike)plankIn.get()).m_142284_("has_" + plankIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)plankIn.get())));
    }

    public ShapedRecipeBuilder makeTrapdoor(Supplier<? extends Block> trapdoorOut, Supplier<? extends Block> plankIn) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)trapdoorOut.get()), (int)2).m_126130_("PPP").m_126130_("PPP").m_126127_(Character.valueOf('P'), (ItemLike)plankIn.get()).m_142284_("has_" + plankIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)plankIn.get())));
    }

    public ShapelessRecipeBuilder makeButton(Supplier<? extends Block> buttonOut, Supplier<? extends Block> blockIn) {
        return ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)buttonOut.get())).m_126209_((ItemLike)blockIn.get()).m_142284_("has_" + blockIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makePressurePlate(Supplier<? extends Block> pressurePlateOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)pressurePlateOut.get())).m_126130_("BB").m_126127_(Character.valueOf('B'), (ItemLike)blockIn.get()).m_142284_("has_" + blockIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeStairs(Supplier<? extends Block> stairsOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)stairsOut.get()), (int)4).m_126130_("M  ").m_126130_("MM ").m_126130_("MMM").m_126127_(Character.valueOf('M'), (ItemLike)blockIn.get()).m_142284_("has_" + blockIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeSlab(Supplier<? extends Block> slabOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)slabOut.get()), (int)6).m_126130_("MMM").m_126127_(Character.valueOf('M'), (ItemLike)blockIn.get()).m_142284_("has_" + blockIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeWall(Supplier<? extends Block> wallOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)wallOut.get()), (int)6).m_126130_("MMM").m_126130_("MMM").m_126127_(Character.valueOf('M'), (ItemLike)blockIn.get()).m_142284_("has_" + blockIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeFence(Supplier<? extends Block> fenceOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)fenceOut.get()), (int)6).m_126130_("M/M").m_126130_("M/M").m_126127_(Character.valueOf('M'), (ItemLike)blockIn.get()).m_206416_(Character.valueOf('/'), Tags.Items.RODS_WOODEN).m_142284_("has_" + blockIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeFenceGate(Supplier<? extends Block> fenceGateOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)fenceGateOut.get())).m_126130_("/M/").m_126130_("/M/").m_126127_(Character.valueOf('M'), (ItemLike)blockIn.get()).m_206416_(Character.valueOf('/'), Tags.Items.RODS_WOODEN).m_142284_("has_" + blockIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeBricks(Supplier<? extends Block> bricksOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)bricksOut.get()), (int)4).m_126130_("MM").m_126130_("MM").m_126127_(Character.valueOf('M'), (ItemLike)blockIn.get()).m_142284_("has_" + blockIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeChiseledBricks(Supplier<? extends Block> bricksOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)bricksOut.get())).m_126130_("M").m_126130_("M").m_126127_(Character.valueOf('M'), (ItemLike)blockIn.get()).m_142284_("has_" + blockIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeWood(Supplier<? extends Block> woodOut, Supplier<? extends Block> logIn) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)woodOut.get()), (int)3).m_126130_("MM").m_126130_("MM").m_126127_(Character.valueOf('M'), (ItemLike)logIn.get()).m_142284_("has_" + logIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)logIn.get())));
    }

    public ShapedRecipeBuilder makeIngotToBlock(Supplier<? extends Block> blockOut, Supplier<? extends Item> ingotIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)blockOut.get())).m_126130_("###").m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)ingotIn.get()).m_142284_("has_" + ingotIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)ingotIn.get())));
    }

    public ShapelessRecipeBuilder makeBlockToIngot(Supplier<? extends Item> ingotOut, Supplier<? extends Block> blockIn) {
        return ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ingotOut.get()), (int)9).m_126209_((ItemLike)blockIn.get()).m_142284_("has_" + blockIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeNuggetToIngot(Supplier<? extends Item> ingotOut, Supplier<? extends Item> nuggetIn) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ingotOut.get()), (int)1).m_126130_("NNN").m_126130_("NNN").m_126130_("NNN").m_126127_(Character.valueOf('N'), (ItemLike)nuggetIn.get()).m_142284_("has_" + nuggetIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)nuggetIn.get())));
    }

    public ShapelessRecipeBuilder makeIngotToNugget(Supplier<? extends Item> nuggetOut, Supplier<? extends Item> ingotIn) {
        return ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)nuggetOut.get()), (int)9).m_126209_((ItemLike)ingotIn.get()).m_142284_("has_" + ingotIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)ingotIn.get())));
    }

    public ShapedRecipeBuilder makeSword(Supplier<? extends Item> swordOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)swordOut.get())).m_126130_("#").m_126130_("#").m_126130_("/").m_126127_(Character.valueOf('#'), (ItemLike)materialIn.get()).m_206416_(Character.valueOf('/'), Tags.Items.RODS_WOODEN).m_142284_("has_" + materialIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makePickaxe(Supplier<? extends Item> pickaxeOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)pickaxeOut.get())).m_126130_("###").m_126130_(" / ").m_126130_(" / ").m_126127_(Character.valueOf('#'), (ItemLike)materialIn.get()).m_206416_(Character.valueOf('/'), Tags.Items.RODS_WOODEN).m_142284_("has_" + materialIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeAxe(Supplier<? extends Item> axeOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)axeOut.get())).m_126130_("##").m_126130_("#/").m_126130_(" /").m_126127_(Character.valueOf('#'), (ItemLike)materialIn.get()).m_206416_(Character.valueOf('/'), Tags.Items.RODS_WOODEN).m_142284_("has_" + materialIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeShovel(Supplier<? extends Item> shovelOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)shovelOut.get())).m_126130_("#").m_126130_("/").m_126130_("/").m_126127_(Character.valueOf('#'), (ItemLike)materialIn.get()).m_206416_(Character.valueOf('/'), Tags.Items.RODS_WOODEN).m_142284_("has_" + materialIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeHoe(Supplier<? extends Item> hoeOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)hoeOut.get())).m_126130_("##").m_126130_(" /").m_126130_(" /").m_126127_(Character.valueOf('#'), (ItemLike)materialIn.get()).m_206416_(Character.valueOf('/'), Tags.Items.RODS_WOODEN).m_142284_("has_" + materialIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeHelmet(Supplier<? extends Item> helmetOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)helmetOut.get())).m_126130_("MMM").m_126130_("M M").m_126127_(Character.valueOf('M'), (ItemLike)materialIn.get()).m_142284_("has_" + materialIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeChestplate(Supplier<? extends Item> helmetOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)helmetOut.get())).m_126130_("M M").m_126130_("MMM").m_126130_("MMM").m_126127_(Character.valueOf('M'), (ItemLike)materialIn.get()).m_142284_("has_" + materialIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeLeggings(Supplier<? extends Item> helmetOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)helmetOut.get())).m_126130_("MMM").m_126130_("M M").m_126130_("M M").m_126127_(Character.valueOf('M'), (ItemLike)materialIn.get()).m_142284_("has_" + materialIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeBoots(Supplier<? extends Item> helmetOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)helmetOut.get())).m_126130_("M M").m_126130_("M M").m_126127_(Character.valueOf('M'), (ItemLike)materialIn.get()).m_142284_("has_" + materialIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapelessRecipeBuilder makeStew(Supplier<? extends Item> stewOut, Supplier<? extends Block> mushroomIn) {
        return ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)stewOut.get())).m_126209_((ItemLike)Items.f_42399_).m_126211_((ItemLike)mushroomIn.get(), 3).m_142284_("has_" + mushroomIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)mushroomIn.get())));
    }

    public ShapedRecipeBuilder makeBoat(Supplier<? extends Item> boatOut, Supplier<? extends Block> planksIn) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)boatOut.get())).m_126130_("P P").m_126130_("PPP").m_126127_(Character.valueOf('P'), (ItemLike)planksIn.get()).m_142284_("in_water", (CriterionTriggerInstance)UGRecipeProvider.m_125979_((Block)Blocks.f_49990_));
    }

    public ShapedRecipeBuilder makeSign(Supplier<? extends SignBlock> signOut, Supplier<? extends Block> planksIn) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)signOut.get()), (int)3).m_126130_("PPP").m_126130_("PPP").m_126130_(" / ").m_126127_(Character.valueOf('P'), (ItemLike)planksIn.get()).m_206416_(Character.valueOf('/'), Tags.Items.RODS_WOODEN).m_142284_("has_" + planksIn.get().getRegistryName().m_135815_(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)planksIn.get())));
    }

    public void ore(ItemLike result, List<ItemLike> ingredients, float xp, String group, Consumer<FinishedRecipe> consumer) {
        this.oreSmeltingRecipe(result, ingredients, xp, group, consumer);
        this.oreBlastingRecipe(result, ingredients, xp, group, consumer);
    }

    public SimpleCookingRecipeBuilder smeltingRecipe(ItemLike result, ItemLike ingredient, float exp) {
        return this.smeltingRecipe(result, ingredient, exp, 1);
    }

    private void oreSmeltingRecipe(ItemLike result, List<ItemLike> ingredients, float xp, String group, Consumer<FinishedRecipe> consumer) {
        for (ItemLike ingredient : ingredients) {
            this.smeltingRecipe(result, ingredient, xp, 1).m_142409_(group).m_142700_(consumer, new ResourceLocation("undergarden", "smelt_" + ingredient.m_5456_().getRegistryName().m_135815_()));
        }
    }

    public SimpleCookingRecipeBuilder smeltingRecipe(ItemLike result, ItemLike ingredient, float exp, int count) {
        return SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack(ingredient, count)}), (ItemLike)result, (float)exp, (int)200).m_142284_("has_" + ingredient.m_5456_().getRegistryName(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)ingredient));
    }

    public SimpleCookingRecipeBuilder smeltingRecipeTag(ItemLike result, TagKey<Item> ingredient, float exp) {
        return this.smeltingRecipeTag(result, ingredient, exp, 1);
    }

    public SimpleCookingRecipeBuilder smeltingRecipeTag(ItemLike result, TagKey<Item> ingredient, float exp, int count) {
        return SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_204132_(ingredient), (ItemLike)result, (float)exp, (int)200).m_142284_("has_" + ingredient, (CriterionTriggerInstance)UGRecipeProvider.m_206406_(ingredient));
    }

    public SimpleCookingRecipeBuilder blastingRecipe(ItemLike result, ItemLike ingredient, float exp) {
        return this.blastingRecipe(result, ingredient, exp, 1);
    }

    private void oreBlastingRecipe(ItemLike result, List<ItemLike> ingredients, float xp, String group, Consumer<FinishedRecipe> consumer) {
        for (ItemLike ingredient : ingredients) {
            this.blastingRecipe(result, ingredient, xp, 1).m_142409_(group).m_142700_(consumer, new ResourceLocation("undergarden", "blast_" + ingredient.m_5456_().getRegistryName().m_135815_()));
        }
    }

    public SimpleCookingRecipeBuilder blastingRecipe(ItemLike result, ItemLike ingredient, float exp, int count) {
        return SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack(ingredient, count)}), (ItemLike)result, (float)exp, (int)100).m_142284_("has_" + ingredient.m_5456_().getRegistryName(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)ingredient));
    }

    public SimpleCookingRecipeBuilder blastingRecipeTag(ItemLike result, TagKey<Item> ingredient, float exp) {
        return this.blastingRecipeTag(result, ingredient, exp, 1);
    }

    public SimpleCookingRecipeBuilder blastingRecipeTag(ItemLike result, TagKey<Item> ingredient, float exp, int count) {
        return SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_204132_(ingredient), (ItemLike)result, (float)exp, (int)100).m_142284_("has_" + ingredient, (CriterionTriggerInstance)UGRecipeProvider.m_206406_(ingredient));
    }

    public SimpleCookingRecipeBuilder smokingRecipe(ItemLike result, ItemLike ingredient, float exp) {
        return this.smokingRecipe(result, ingredient, exp, 1);
    }

    public SimpleCookingRecipeBuilder smokingRecipe(ItemLike result, ItemLike ingredient, float exp, int count) {
        return SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack(ingredient, count)}), (ItemLike)result, (float)exp, (int)100, (SimpleCookingSerializer)RecipeSerializer.f_44093_).m_142284_("has_" + ingredient.m_5456_().getRegistryName(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)ingredient));
    }

    public UpgradeRecipeBuilder smithingRecipe(Supplier<Item> input, Supplier<Item> upgradeItem, Supplier<Item> result) {
        return UpgradeRecipeBuilder.m_126385_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)input.get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)upgradeItem.get()}), (Item)result.get()).m_126389_("has_" + upgradeItem.get().getRegistryName(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)upgradeItem.get())));
    }

    public UpgradeRecipeBuilder smithingForgotten(Supplier<Item> input, Supplier<Item> result) {
        return this.smithingRecipe(input, (Supplier<Item>)UGItems.FORGOTTEN_INGOT, result);
    }

    public SingleItemRecipeBuilder stonecutting(Supplier<Block> input, ItemLike result) {
        return SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)input.get()}), (ItemLike)result).m_142284_("has_" + input.get().getRegistryName(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get())));
    }

    public SingleItemRecipeBuilder stonecutting(Supplier<Block> input, ItemLike result, int resultAmount) {
        return SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)input.get()}), (ItemLike)result, (int)resultAmount).m_142284_("has_" + input.get().getRegistryName(), (CriterionTriggerInstance)UGRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get())));
    }

    public SingleItemRecipeBuilder depthrockStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DEPTHROCK, result);
    }

    public SingleItemRecipeBuilder depthrockStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DEPTHROCK, result, resultAmount);
    }

    public SingleItemRecipeBuilder depthrockBricksStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DEPTHROCK_BRICKS, result);
    }

    public SingleItemRecipeBuilder depthrockBricksStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DEPTHROCK_BRICKS, result, resultAmount);
    }

    public SingleItemRecipeBuilder depthrockTilesStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DEPTHROCK_TILES, result);
    }

    public SingleItemRecipeBuilder depthrockTilesStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DEPTHROCK_TILES, result, resultAmount);
    }

    public SingleItemRecipeBuilder polishedDepthrockStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.POLISHED_DEPTHROCK, result);
    }

    public SingleItemRecipeBuilder polishedDepthrockStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.POLISHED_DEPTHROCK, result, resultAmount);
    }

    public SingleItemRecipeBuilder shiverstoneStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.SHIVERSTONE, result);
    }

    public SingleItemRecipeBuilder shiverstoneStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.SHIVERSTONE, result, resultAmount);
    }

    public SingleItemRecipeBuilder shiverstoneBricksStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.SHIVERSTONE_BRICKS, result);
    }

    public SingleItemRecipeBuilder shiverstoneBricksStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.SHIVERSTONE_BRICKS, result, resultAmount);
    }

    public SingleItemRecipeBuilder tremblecrustStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.TREMBLECRUST, result);
    }

    public SingleItemRecipeBuilder tremblecrustStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.TREMBLECRUST, result, resultAmount);
    }

    public SingleItemRecipeBuilder tremblecrustBricksStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.TREMBLECRUST_BRICKS, result);
    }

    public SingleItemRecipeBuilder tremblecrustBricksStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.TREMBLECRUST_BRICKS, result, resultAmount);
    }
}

