/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class UGBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"undergarden");
    public static final ResourceKey<Biome> ANCIENT_SEA = UGBiomes.register("ancient_sea");
    public static final ResourceKey<Biome> BARREN_ABYSS = UGBiomes.register("barren_abyss");
    public static final ResourceKey<Biome> DEAD_SEA = UGBiomes.register("dead_sea");
    public static final ResourceKey<Biome> DENSE_FOREST = UGBiomes.register("dense_forest");
    public static final ResourceKey<Biome> FORGOTTEN_FIELD = UGBiomes.register("forgotten_field");
    public static final ResourceKey<Biome> FROSTFIELDS = UGBiomes.register("frostfields");
    public static final ResourceKey<Biome> GRONGLEGROWTH = UGBiomes.register("gronglegrowth");
    public static final ResourceKey<Biome> ICY_SEA = UGBiomes.register("icy_sea");
    public static final ResourceKey<Biome> MUSHROOM_BOG = UGBiomes.register("mushroom_bog");
    public static final ResourceKey<Biome> SMOGSTEM_FOREST = UGBiomes.register("smogstem_forest");
    public static final ResourceKey<Biome> SMOG_SPIRES = UGBiomes.register("smog_spires");
    public static final ResourceKey<Biome> WIGGLEWOOD_FOREST = UGBiomes.register("wigglewood_forest");

    public static void toDictionary() {
        BiomeDictionary.addTypes(ANCIENT_SEA, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WET, BiomeDictionary.Type.OCEAN});
        BiomeDictionary.addTypes(BARREN_ABYSS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.addTypes(DEAD_SEA, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.addTypes(DENSE_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes(FORGOTTEN_FIELD, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WET, BiomeDictionary.Type.PLAINS});
        BiomeDictionary.addTypes(FROSTFIELDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.PLAINS});
        BiomeDictionary.addTypes(GRONGLEGROWTH, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes(ICY_SEA, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.OCEAN});
        BiomeDictionary.addTypes(MUSHROOM_BOG, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.SWAMP});
        BiomeDictionary.addTypes(SMOGSTEM_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WET, BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes(SMOG_SPIRES, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes(WIGGLEWOOD_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WET, BiomeDictionary.Type.FOREST});
    }

    private static ResourceLocation name(String name) {
        return new ResourceLocation("undergarden", name);
    }

    private static ResourceKey<Biome> register(String name) {
        BIOMES.register(name, OverworldBiomes::m_194913_);
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)UGBiomes.name(name));
    }
}

